/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public class XURI {
    static final String QUERYSEP = "&";
    static final String FRAGMENTSEP = "&";
    protected String originaluri = null;
    protected String[] protocols = null;
    protected String coreuri = null;
    protected URI uri = null;
    protected String[] allprotocols = null;
    protected String baseprotocol = null;
    protected String userinfo = null;
    protected String host = null;
    protected String path = null;
    protected String query = null;
    protected String frag = null;
    Map<String, String> fields = new HashMap<String, String>();
    Map<String, String> parameters = new HashMap<String, String>();

    public XURI(String path) throws URISyntaxException {
        String value;
        String name;
        String[] pair;
        char c;
        if (path == null) {
            throw new URISyntaxException(path, "Null URI");
        }
        this.originaluri = path;
        this.protocols = DapUtil.getProtocols((String)path);
        if (this.protocols.length == 0) {
            this.protocols = new String[]{"file:"};
            this.path = "file://" + this.path;
        } else if (this.protocols.length == 1 && this.protocols[0].length() == 1 && ((c = this.protocols[0].charAt(0)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            this.protocols = new String[]{"file"};
            path = "file://" + path;
        }
        if (this.protocols.length == 0) {
            this.coreuri = path;
        } else if (this.protocols.length == 1) {
            this.coreuri = path;
        } else {
            int prefix = 0;
            for (int i = 0; i < this.protocols.length - 1; ++i) {
                prefix += (this.protocols[i] + ":").length();
            }
            this.coreuri = path.substring(prefix);
        }
        this.uri = new URI(this.coreuri);
        String lastproto = this.protocols[this.protocols.length - 1];
        if (!lastproto.equals(XURI.canonical(this.uri.getScheme()))) {
            throw new URISyntaxException(this.uri.toString(), String.format("malformed url: %s :: %s", lastproto, this.uri.getScheme()));
        }
        this.baseprotocol = this.protocols[this.protocols.length - 1];
        this.userinfo = XURI.canonical(this.uri.getRawUserInfo());
        this.host = XURI.canonical(this.uri.getRawAuthority());
        this.path = XURI.canonical(this.uri.getRawPath());
        this.query = XURI.canonical(this.uri.getRawQuery());
        this.frag = XURI.canonical(this.uri.getRawFragment());
        if (this.query != null) {
            String[] pieces;
            for (String piece : pieces = this.query.split("&")) {
                pair = piece.split("=");
                name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.fields.put(name, value);
            }
        }
        if (this.frag != null) {
            String[] pieces;
            for (String piece : pieces = this.frag.split("&")) {
                pair = piece.split("=");
                name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.parameters.put(name, value);
            }
        }
    }

    public String getOriginal() {
        return this.originaluri;
    }

    public String[] getProtocols() {
        return this.protocols;
    }

    public String getLeadProtocol() {
        return this.protocols[0];
    }

    public String getBaseProtocol() {
        return this.baseprotocol;
    }

    public void setBaseProtocol(String base) {
        this.baseprotocol = base;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFrag() {
        return this.frag;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String pureURI() {
        try {
            String auth = this.host;
            if (this.userinfo != null) {
                auth = this.userinfo + "@" + auth;
            }
            URI urx = new URI(this.getBaseProtocol(), auth, this.path, null, null);
            return urx.toString();
        }
        catch (URISyntaxException e) {
            assert (false) : "Internal Error";
            return null;
        }
    }

    public static String canonical(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }
}

