/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataDataset;
import dap4.core.dmr.DapDataset;
import dap4.core.util.DapException;
import dap4.dap4shared.AbstractDSP;
import dap4.dap4shared.ChecksumMode;
import dap4.dap4shared.D4DataDataset;
import dap4.dap4shared.DataCompiler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class D4DSP
extends AbstractDSP {
    public static boolean DEBUG = false;
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected D4DataDataset d4data = null;
    protected byte[] serialization = null;
    protected ByteBuffer databuffer = null;
    protected ByteOrder order = null;
    protected ChecksumMode checksummode = ChecksumMode.DAP;

    @Override
    public DataDataset getDataDataset() {
        return this.d4data;
    }

    public ByteBuffer getData() {
        return this.databuffer;
    }

    public void setDataDataset(D4DataDataset data) {
        this.d4data = data;
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public void setOrder(ByteOrder order) {
        this.order = order;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksummode;
    }

    public void setChecksumMode(ChecksumMode mode) {
        this.checksummode = mode;
    }

    protected void build(String document, byte[] serialdata, ByteOrder order) throws DapException {
        this.build(this.parseDMR(document), serialdata, order);
    }

    protected void build(DapDataset dmr, byte[] serialdata, ByteOrder order) throws DapException {
        this.dmr = dmr;
        this.databuffer = ByteBuffer.wrap(serialdata).order(order);
        DataCompiler compiler = new DataCompiler(this, this.checksummode, this.databuffer);
        compiler.compile();
    }
}

