/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataDataset;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapFactory;
import dap4.core.dmr.DapFactoryDMR;
import dap4.core.dmr.parser.Dap4Parser;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import org.xml.sax.SAXException;

public abstract class AbstractDSP
implements DSP {
    protected static final boolean PARSEDEBUG = false;
    protected Object context = null;
    protected DapDataset dmr = null;
    protected String path = null;

    @Override
    public abstract DSP open(String var1, DapContext var2) throws DapException;

    @Override
    public abstract DataDataset getDataDataset();

    @Override
    public DSP open(String path) throws DapException {
        return this.open(path, null);
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public DapDataset getDMR() {
        return this.dmr;
    }

    protected void setContext(Object context) {
        this.context = context;
    }

    protected void setDataset(DapDataset dataset) throws DapException {
        this.dmr = dataset;
    }

    public void setPath(String path) throws DapException {
        this.path = path;
    }

    protected DapDataset parseDMR(String document) throws DapException {
        Dap4Parser pushparser = new Dap4Parser((DapFactory)new DapFactoryDMR());
        try {
            if (!pushparser.parse(document)) {
                throw new DapException("DMR Parse failed");
            }
        }
        catch (SAXException se) {
            throw new DapException((Throwable)se);
        }
        if (pushparser.getErrorResponse() != null) {
            throw new DapException("Error Response Document not supported");
        }
        return pushparser.getDMR();
    }
}

