/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XURI {
    static final String QUERYSEP = "&";
    static final String FRAGMENTSEP = "&";
    public static final EnumSet<Parts> URLONLY = EnumSet.of(Parts.BASE, Parts.PWD, Parts.HOST, Parts.PATH);
    public static final EnumSet<Parts> URLALL = EnumSet.of(Parts.LEAD, new Parts[]{Parts.BASE, Parts.PWD, Parts.HOST, Parts.PATH, Parts.QUERY, Parts.FRAG});
    protected String originaluri = null;
    protected List<String> protocols = null;
    protected String trueurl = null;
    protected URI url = null;
    protected boolean isfile = false;
    protected String baseprotocol = null;
    protected String userinfo = null;
    protected String host = null;
    protected String path = null;
    protected String query = null;
    protected String frag = null;
    Map<String, String> fields = new HashMap<String, String>();
    Map<String, String> parameters = new HashMap<String, String>();

    public XURI(String path) throws URISyntaxException {
        String value;
        String name;
        String[] pair;
        if (path == null) {
            throw new URISyntaxException(path, "Null URI");
        }
        this.originaluri = path;
        this.isfile = false;
        this.protocols = DapUtil.getProtocols((String)path);
        if (this.protocols.size() == 0) {
            this.protocols.add("file");
            path = "file://" + path;
        }
        String lastproto = this.protocols.get(this.protocols.size() - 1);
        if (this.protocols.size() == 0) {
            this.trueurl = path;
            this.isfile = true;
        } else if (this.protocols.size() == 1) {
            String theproto = this.protocols.get(0);
            this.trueurl = path;
            this.isfile = theproto.equals("file");
        } else {
            int prefix = 0;
            for (int i = 0; i < this.protocols.size() - 1; ++i) {
                prefix += (this.protocols.get(i) + ":").length();
            }
            this.trueurl = path.substring(prefix);
            this.isfile = this.protocols.get(this.protocols.size() - 1).equals("file");
        }
        try {
            this.url = new URI(this.trueurl);
        }
        catch (URISyntaxException mue) {
            throw new URISyntaxException(this.trueurl, mue.getMessage());
        }
        if (!lastproto.equals(XURI.canonical(this.url.getScheme()))) {
            throw new URISyntaxException(this.url.toString(), String.format("malformed url: %s :: %s", lastproto, this.url.getScheme()));
        }
        this.baseprotocol = lastproto;
        this.userinfo = XURI.canonical(this.url.getUserInfo());
        if (this.isfile && DapUtil.hasDriveLetter((String)(this.url.getHost() + ":"))) {
            this.host = null;
            this.path = this.url.getHost() + ":";
            this.path = XURI.canonical(this.path + this.url.getPath());
        } else {
            this.host = XURI.canonical(this.url.getHost());
            if (this.url.getPort() > 0) {
                this.host = this.host + ":" + this.url.getPort();
            }
            this.path = XURI.canonical(this.url.getPath());
        }
        String query = this.url.getRawQuery();
        String[] params = null;
        if (query != null) {
            params = this.url.getRawQuery().split("&");
        }
        if (params != null && params.length > 0) {
            this.query = "";
            for (String param : params) {
                pair = param.split("[=]");
                name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                value = "";
                if (pair.length <= 1) continue;
                value = Escape.urlDecode((String)pair[1]);
                this.fields.put(name, value);
                this.query = this.query + name + "=" + value;
            }
        }
        this.frag = XURI.canonical(this.url.getFragment());
        if (this.frag != null) {
            for (String param : params = this.frag.split("&")) {
                pair = param.split("=");
                name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.parameters.put(name, value);
            }
        }
    }

    public String getOriginal() {
        return this.originaluri;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public String getLeadProtocol() {
        return this.protocols.get(0);
    }

    public String getBaseProtocol() {
        return this.baseprotocol;
    }

    public void setBaseProtocol(String base) {
        this.baseprotocol = base;
    }

    public boolean isFile() {
        return this.isfile;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFrag() {
        return this.frag;
    }

    public Map<String, String> getFields() {
        return this.fields;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String assemble(EnumSet<Parts> parts) {
        StringBuilder uri = new StringBuilder();
        if (parts.contains((Object)Parts.LEAD) && parts.contains((Object)Parts.BASE) && this.protocols.size() == 1) {
            uri.append(this.protocols.get(0) + ":");
        } else {
            if (parts.contains((Object)Parts.LEAD)) {
                uri.append(this.protocols.get(0) + ":");
            }
            if (parts.contains((Object)Parts.BASE)) {
                uri.append(this.baseprotocol + ":");
            }
        }
        if (parts.contains((Object)Parts.LEAD) || parts.contains((Object)Parts.BASE) && this.protocols.size() > 0) {
            uri.append("//");
        }
        if (this.userinfo != null && parts.contains((Object)Parts.PWD)) {
            uri.append(this.userinfo + ":");
        }
        if (this.host != null && parts.contains((Object)Parts.HOST)) {
            uri.append(this.host);
        }
        if (this.path != null && parts.contains((Object)Parts.PATH)) {
            uri.append(this.path);
        }
        if (this.query != null && parts.contains((Object)Parts.QUERY)) {
            uri.append("?" + this.query);
        }
        if (this.frag != null && parts.contains((Object)Parts.FRAG)) {
            uri.append("#" + this.frag);
        }
        return uri.toString();
    }

    public static String canonical(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public String toString() {
        return this.originaluri;
    }

    public static enum Parts {
        LEAD,
        BASE,
        PWD,
        HOST,
        PATH,
        QUERY,
        FRAG;

    }
}

