/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.Data;
import dap4.core.data.DataAtomic;
import dap4.core.data.DataCompoundArray;
import dap4.core.data.DataDataset;
import dap4.core.data.DataException;
import dap4.core.data.DataRecord;
import dap4.core.data.DataSequence;
import dap4.core.data.DataSort;
import dap4.core.data.DataStructure;
import dap4.core.dmr.DapNode;

public abstract class AbstractData
implements Data {
    protected DataSort sort = null;
    protected DapNode template = null;

    protected AbstractData(DapNode template) throws DataException {
        this.template = template;
        this.sort = this.computesort();
    }

    public DataSort getSort() {
        return this.sort;
    }

    public DapNode getTemplate() {
        return this.template;
    }

    protected DataSort computesort() {
        if (this instanceof DataAtomic) {
            return DataSort.ATOMIC;
        }
        if (this instanceof DataRecord) {
            return DataSort.RECORD;
        }
        if (this instanceof DataSequence) {
            return DataSort.SEQUENCE;
        }
        if (this instanceof DataStructure) {
            return DataSort.STRUCTURE;
        }
        if (this instanceof DataDataset) {
            return DataSort.DATASET;
        }
        if (this instanceof DataCompoundArray) {
            return DataSort.COMPOUNDARRAY;
        }
        assert (false) : "Cannot compute sort";
        return null;
    }
}

