/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.d4ts.URLMap;

public class URLMapDefault
extends URLMap {
    String urlprefix;
    String pathprefix;

    public URLMapDefault(String urlprefix, String pathprefix) {
        this.urlprefix = urlprefix;
        pathprefix = pathprefix.replace('\\', '/');
        this.pathprefix = pathprefix = DapUtil.canonicalpath((String)pathprefix, (boolean)false);
    }

    @Override
    public String mapURL(String url) throws DapException {
        if (!url.startsWith(this.urlprefix)) {
            throw new DapException("URL not mappable: " + url);
        }
        String suffix = url.substring(this.urlprefix.length(), url.length());
        while (suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        return this.pathprefix + "/" + suffix;
    }

    @Override
    public String mapPath(String path) throws DapException {
        if (!(path = DapUtil.canonicalpath((String)path, (boolean)false)).startsWith(this.pathprefix)) {
            throw new DapException("Path not mappable: " + path);
        }
        String suffix = path.substring(this.pathprefix.length(), path.length());
        while (suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        return this.urlprefix + "/" + suffix;
    }
}

