/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.d4ts.FrontPage;
import dap4.servlet.DapRequest;
import dap4.servlet.DapServlet;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.servlet.ServletException;

public class D4TSServlet
extends DapServlet {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final String TESTDATADIR = "testfiles";

    public void init() throws ServletException {
        super.init();
        try {
            String urlprefix = "/" + DapUtil.canonicalpath((String)this.svcinfo.getServletname());
            String fileprefix = DapUtil.canonicalpath((String)this.svcinfo.getResourcePath()) + "/" + TESTDATADIR;
            this.urlmap.addEntry(urlprefix, fileprefix);
        }
        catch (DapException de) {
            throw new ServletException((Throwable)de);
        }
    }

    protected void doCapabilities(DapRequest drq) throws IOException {
        this.addCommonHeaders(drq);
        String url = drq.getURL().toString();
        String dir = this.getResourceFile(drq, true);
        if (dir == null) {
            throw new DapException("Cannot locate resources directory");
        }
        FrontPage front = new FrontPage(dir, this.urlmap, this.svcinfo);
        String frontpage = front.buildPage();
        if (frontpage == null) {
            throw new DapException("Cannot create front page").setCode(500);
        }
        byte[] frontpage8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(frontpage));
        OutputStream out = drq.getOutputStream();
        out.write(frontpage8);
    }
}

