/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.d4ts.FrontPage;
import dap4.servlet.CDMDSP;
import dap4.servlet.DSPFactory;
import dap4.servlet.DapCache;
import dap4.servlet.DapRequest;
import dap4.servlet.DapServlet;
import dap4.servlet.SynDSP;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class D4TSServlet
extends DapServlet {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final String TESTDATADIR = "/WEB-INF/resources/testfiles";

    protected void doFavicon(DapRequest drq) throws IOException {
        String favfile = this.getResourcePath(drq);
        if (favfile != null) {
            try (FileInputStream fav = new FileInputStream(favfile);){
                byte[] content = DapUtil.readbinaryfile((InputStream)fav);
                OutputStream out = drq.getOutputStream();
                out.write(content);
            }
        }
    }

    protected void doCapabilities(DapRequest drq) throws IOException {
        this.addCommonHeaders(drq);
        String dir = this.getResourcePath(drq);
        if (dir == null) {
            throw new DapException("Cannot locate resources directory");
        }
        FrontPage front = new FrontPage(dir, this.svcinfo);
        String frontpage = front.buildPage();
        if (frontpage == null) {
            throw new DapException("Cannot create front page").setCode(500);
        }
        byte[] frontpage8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(frontpage));
        OutputStream out = drq.getOutputStream();
        out.write(frontpage8);
    }

    protected String getResourcePath(DapRequest drq) throws IOException {
        String suffix = DapUtil.denullify((String)drq.getDataset());
        String datasetfilepath = drq.getRealPath(TESTDATADIR + DapUtil.canonicalpath((String)suffix));
        File dataset = new File(datasetfilepath);
        if (!dataset.exists()) {
            throw new DapException("Requested file does not exist: " + datasetfilepath).setCode(404);
        }
        if (!dataset.canRead()) {
            throw new DapException("Requested file not readable: " + datasetfilepath).setCode(403);
        }
        return datasetfilepath;
    }

    protected long getBinaryWriteLimit() {
        return 100000000L;
    }

    static {
        DapCache.setFactory((DSPFactory)new D4TSFactory());
    }

    static class D4TSFactory
    extends DSPFactory {
        public D4TSFactory() {
            this.registerDSP(SynDSP.class, true);
            this.registerDSP(CDMDSP.class, true);
        }
    }
}

