/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.SliceIterator;
import java.util.ArrayList;
import java.util.List;

public class Slice {
    public static final long UNDEFINED = -1L;
    public static final long MAXLENGTH = 0x3FFFFFFFFFFFFFFFL;
    public static List<Slice> SCALARSLICES;
    public static Slice SCALARSLICE;
    protected Sort sort = Sort.Single;
    long first = -1L;
    long stop = -1L;
    long stride = -1L;
    long maxsize = 0x3FFFFFFFFFFFFFFFL;
    Boolean whole = null;
    protected boolean constrained = true;

    public Slice() {
    }

    public Slice(long first, long stop, long stride) throws DapException {
        this(first, stop, stride, -1L);
    }

    public Slice(long first, long stop, long stride, long maxsize) throws DapException {
        this();
        this.setIndices(first, stop, stride, maxsize);
    }

    public Slice(Slice s2) throws DapException {
        this();
        this.setIndices(s2.getFirst(), s2.getStop(), s2.getStride(), s2.getMax());
        this.setConstrained(s2.isConstrained());
        this.setWhole(s2.isWhole());
    }

    public Slice(DapDimension dim) throws DapException {
        this();
        this.setIndices(0L, dim.getSize(), 1L, dim.getSize());
        this.setWhole(true);
        this.setConstrained(false);
    }

    public Slice finish() throws DapException {
        if (this.first == -1L) {
            this.first = 0L;
        }
        if (this.stride == -1L) {
            this.stride = 1L;
        }
        if (this.stop == -1L && this.maxsize != -1L) {
            this.stop = this.maxsize;
        }
        if (this.stop == -1L && this.maxsize == -1L) {
            this.stop = this.first + 1L;
        }
        if (this.maxsize == -1L && this.stop != -1L) {
            this.maxsize = this.stop;
        }
        assert (this.first != -1L);
        assert (this.stride != -1L);
        assert (this.stop != -1L);
        if (this.first > this.maxsize) {
            throw new DapException("Slice: first index > max size");
        }
        if (this.stop > this.maxsize + 1L) {
            throw new DapException("Slice: stop > max size");
        }
        if (this.first < 0L) {
            throw new DapException("Slice: first index < 0");
        }
        if (this.stop < 0L) {
            throw new DapException("Slice: stop index < 0");
        }
        if (this.stride <= 0L) {
            throw new DapException("Slice: stride index <= 0");
        }
        if (this.first > this.stop) {
            throw new DapException("Slice: first index > last");
        }
        return this;
    }

    public SliceIterator iterator() {
        return new SliceIterator(this);
    }

    public Sort getSort() {
        return this.sort;
    }

    public long getFirst() {
        return this.first;
    }

    public long getStop() {
        return this.stop;
    }

    public long getLast() {
        return this.stop - this.first == 0L ? 0L : this.stop - 1L;
    }

    public long getStride() {
        return this.stride;
    }

    public long getSize() {
        return this.stop - this.first;
    }

    public long getMax() {
        return this.maxsize;
    }

    public Slice setMaxSize(long size) throws DapException {
        return this.setIndices(this.first, this.stop, this.stride, size);
    }

    public Slice setIndices(long first, long stop, long stride) throws DapException {
        return this.setIndices(first, stop, stride, -1L);
    }

    public Slice setIndices(long first, long stop, long stride, long maxsize) throws DapException {
        this.first = first;
        this.stop = stop;
        this.stride = stride;
        this.maxsize = maxsize;
        return this.finish();
    }

    public Boolean isWhole() {
        return this.whole;
    }

    public Slice setWhole(Boolean tf) {
        this.whole = tf;
        return this;
    }

    public Boolean isConstrained() {
        return this.constrained;
    }

    public Slice setConstrained(Boolean tf) {
        this.constrained = tf;
        return this;
    }

    public long getCount() {
        assert (this.first != -1L && this.stride != -1L && this.stop != -1L);
        long count = this.stop - this.first;
        count = count + this.stride - 1L;
        return count /= this.stride;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Slice)) {
            return false;
        }
        Slice other = (Slice)o;
        if (other == this) {
            return true;
        }
        return other.getFirst() == this.getFirst() && other.getStop() == this.getStop() && other.getStride() == this.getStride();
    }

    public int hashCode() {
        return (int)(this.getFirst() << 20 | this.getStop() << 10 | this.getStride());
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean withbrackets) {
        StringBuilder buf = new StringBuilder();
        if (withbrackets) {
            buf.append("[");
        }
        if (this.stop - this.first == 0L) {
            buf.append("0");
        } else if (this.stride == 1L) {
            buf.append(String.format("%d:%d", this.first, this.stop - 1L));
        } else {
            buf.append(String.format("%d:%d:%d", this.first, this.stride, this.stop - 1L));
        }
        buf.append(String.format("|%d", this.stop - this.first));
        if (withbrackets) {
            buf.append("]");
        }
        return buf.toString();
    }

    public String toConstraintString() throws DapException {
        assert (this.first != -1L && this.stride != -1L && this.stop != -1L);
        if (this.stop - this.first == 0L) {
            return String.format("[0]", new Object[0]);
        }
        if (this.stride == 1L) {
            if (this.stop - this.first == 1L) {
                return String.format("[%d]", this.first);
            }
            return String.format("[%d:%d]", this.first, this.stop - 1L);
        }
        return String.format("[%d:%d:%d]", this.first, this.stride, this.stop - 1L);
    }

    public static Slice compose(Slice target, Slice src) throws DapException {
        long sr_stride = target.getStride() * src.getStride();
        long sr_first = Slice.MAP(target, src.getFirst());
        long lastx = Slice.MAP(target, src.getLast());
        long sr_last = target.getLast() < lastx ? target.getLast() : lastx;
        return new Slice(sr_first, sr_last + 1L, sr_stride, sr_last + 1L).finish();
    }

    static long MAP(Slice target, long i) throws DapException {
        if (i < 0L) {
            throw new DapException("Slice.compose: i must be >= 0");
        }
        if (i > target.getStop()) {
            throw new DapException("i must be < stop");
        }
        return target.getFirst() + i * target.getStride();
    }

    public List<Slice> getSubSlices() {
        ArrayList<Slice> list = new ArrayList<Slice>();
        list.add(this);
        return list;
    }

    public Slice getSubSlice(int i) {
        if (i != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    static {
        try {
            SCALARSLICE = new Slice(0L, 1L, 1L, 1L).finish();
            SCALARSLICES = new ArrayList<Slice>();
            SCALARSLICES.add(SCALARSLICE);
        }
        catch (DapException de) {
            SCALARSLICES = null;
        }
    }

    public static enum Sort {
        Single,
        Multi;

    }
}

