/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.DMRFactory;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.DapXML;
import dap4.core.dmr.ErrorResponse;
import dap4.core.dmr.TypeSort;
import dap4.core.dmr.parser.Dap4Actions;
import dap4.core.dmr.parser.Dap4BisonParser;
import dap4.core.dmr.parser.Dap4Parser;
import dap4.core.dmr.parser.ParseException;
import dap4.core.dmr.parser.ParseUtil;
import dap4.core.dmr.parser.SaxEvent;
import dap4.core.dmr.parser.SaxEventType;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class Dap4ParserImpl
extends Dap4BisonParser
implements Dap4Parser {
    protected static int globaldebuglevel = 0;
    protected DMRFactory factory = null;
    protected ErrorResponse errorresponse = null;
    protected Deque<DapNode> scopestack = new ArrayDeque<DapNode>();
    protected DapDataset root = null;
    protected boolean debug = false;

    public static void setGlobalDebugLevel(int level) {
        globaldebuglevel = level;
    }

    public Dap4ParserImpl(DMRFactory factory) {
        DMRFactory dMRFactory = this.factory = factory == null ? new DMRFactory() : factory;
        if (globaldebuglevel > 0) {
            this.setDebugLevel(globaldebuglevel);
        }
    }

    @Override
    public ErrorResponse getErrorResponse() {
        return this.errorresponse;
    }

    @Override
    public DapDataset getDMR() {
        return this.root;
    }

    @Override
    public boolean parse(String input) throws SAXException {
        return super.parse(input);
    }

    DapGroup getGroupScope() throws DapException {
        DapGroup gscope = (DapGroup)this.searchScope(DapSort.GROUP, DapSort.DATASET);
        if (gscope == null) {
            throw new DapException("Undefined Group Scope");
        }
        return gscope;
    }

    DapNode getMetadataScope() throws DapException {
        DapNode match = this.searchScope(METADATASCOPES);
        if (match == null) {
            throw new ParseException("No enclosing metadata capable scope");
        }
        return match;
    }

    DapNode getParentScope() throws DapException {
        DapNode parent = this.searchScope(DapSort.VARIABLE, DapSort.GROUP, DapSort.DATASET);
        if (parent == null) {
            throw new DapException("Undefined parent scope");
        }
        return parent;
    }

    DapVariable getVariableScope() throws DapException {
        DapNode match = this.searchScope(DapSort.VARIABLE);
        if (match == null) {
            throw new ParseException("No enclosing variable scope");
        }
        return (DapVariable)match;
    }

    DapNode getScope(DapSort ... sort) throws DapException {
        DapNode node = this.searchScope(sort);
        if (node == null) {
            throw new ParseException("No enclosing scope of specified type");
        }
        return node;
    }

    DapNode searchScope(DapSort ... sort) {
        for (DapNode node : this.scopestack) {
            for (int j = 0; j < sort.length; ++j) {
                if (node.getSort() != sort[j]) continue;
                return node;
            }
        }
        return null;
    }

    DapVariable findVariable(DapNode parent, String name) {
        DapVariable var = null;
        block0 : switch (parent.getSort()) {
            case DATASET: 
            case GROUP: {
                var = ((DapGroup)parent).findVariable(name);
                break;
            }
            case VARIABLE: {
                DapVariable v = (DapVariable)parent;
                DapType t = v.getBaseType();
                switch (t.getTypeSort()) {
                    case Structure: {
                        var = ((DapStructure)t).findByName(name);
                        break block0;
                    }
                    case Sequence: {
                        var = ((DapSequence)t).findByName(name);
                        break block0;
                    }
                }
                assert (false) : "Container cannot be atomic variable";
                break;
            }
        }
        return var;
    }

    SaxEvent pull(Dap4Actions.XMLAttributeMap map, String name) {
        SaxEvent event = (SaxEvent)map.remove(name.toLowerCase());
        return event;
    }

    void passReserved(Dap4Actions.XMLAttributeMap map, DapNode node) throws ParseException {
        try {
            Object attr = null;
            for (Map.Entry entry : map.entrySet()) {
                SaxEvent event = (SaxEvent)entry.getValue();
                String key = (String)entry.getKey();
                String value = event.value;
                if (!Dap4ParserImpl.isReserved(key)) continue;
                node.addXMLAttribute(key, value);
            }
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    SaxEvent peek(Dap4Actions.XMLAttributeMap map, String name) {
        SaxEvent event = (SaxEvent)map.get(name.toLowerCase());
        return event;
    }

    DapAttribute makeAttribute(DapSort sort, String name, DapType basetype, List<String> nslist, DapNode parent) throws DapException {
        DapAttribute attr = new DapAttribute(name, basetype);
        if (sort == DapSort.ATTRIBUTE) {
            attr.setBaseType(basetype);
        }
        parent.addAttribute(attr);
        attr.setNamespaceList(nslist);
        return attr;
    }

    boolean isempty(SaxEvent token) {
        return token == null || this.isempty(token.value);
    }

    boolean isempty(String text) {
        return text == null || text.length() == 0;
    }

    List<String> convertNamespaceList(Dap4Actions.NamespaceList nslist) {
        return nslist;
    }

    boolean islegalenumtype(DapType kind) {
        return kind.isIntegerType();
    }

    boolean islegalattributetype(DapType kind) {
        return kind.isLegalAttrType();
    }

    DapAttribute lookupAttribute(DapNode parent, Dap4Actions.XMLAttributeMap attrs) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String attrname = name.value;
        return parent.findAttribute(attrname);
    }

    void changeAttribute(DapAttribute attr, Dap4Actions.XMLAttributeMap description) throws DapException {
        SaxEvent name = this.pull(description, "name");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String attrname = name.value;
        if (!attr.getShortName().equals(attrname)) {
            throw new ParseException("Attribute: DATA DMR: Attribute name mismatch:" + name.name);
        }
        switch (attr.getSort()) {
            case ATTRIBUTE: {
                DapType basetype;
                String typename;
                SaxEvent atype = this.pull(description, "type");
                String string = typename = atype == null ? "Int32" : atype.value;
                if ("Byte".equalsIgnoreCase(typename)) {
                    typename = "UInt8";
                }
                if ((basetype = (DapType)this.root.lookup(typename, DapSort.ENUMERATION, DapSort.ATOMICTYPE)) != attr.getBaseType()) {
                    throw new ParseException("Attribute: DATA DMR: Attempt to change attribute type: " + typename);
                }
                attr.clearValues();
                SaxEvent value = this.pull(description, "value");
                if (value == null) break;
                attr.setValues(new String[]{value.value});
                break;
            }
            case ATTRIBUTESET: {
                attr.setAttributes(new HashMap<String, DapAttribute>());
                break;
            }
            case OTHERXML: {
                throw new ParseException("Attribute: DATA DMR: OtherXML attributes not supported");
            }
        }
    }

    DapAttribute createatomicattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist, DapNode parent) throws DapException {
        DapType basetype;
        String typename;
        SaxEvent name = this.pull(attrs, "name");
        if (this.isempty(name)) {
            throw new ParseException("Attribute: Empty attribute name");
        }
        String attrname = name.value;
        SaxEvent atype = this.pull(attrs, "type");
        String string = typename = atype == null ? "Int32" : atype.value;
        if ("Byte".equalsIgnoreCase(typename)) {
            typename = "UInt8";
        }
        if ((basetype = (DapType)this.root.lookup(typename, DapSort.ENUMERATION, DapSort.ATOMICTYPE)) == null || !this.islegalattributetype(basetype)) {
            throw new ParseException("Attribute: Invalid attribute type: " + typename);
        }
        List<String> hreflist = this.convertNamespaceList(nslist);
        DapAttribute attr = this.makeAttribute(DapSort.ATTRIBUTE, name.value, basetype, hreflist, parent);
        return attr;
    }

    DapAttribute createcontainerattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist, DapNode parent) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        if (this.isempty(name)) {
            throw new ParseException("ContainerAttribute: Empty attribute name");
        }
        List<String> hreflist = this.convertNamespaceList(nslist);
        DapAttribute attr = this.makeAttribute(DapSort.ATTRIBUTESET, name.value, null, hreflist, parent);
        return attr;
    }

    void createvalue(String value, DapAttribute parent) throws DapException {
        value = this.cleanup(value);
        if (parent != null) {
            parent.setValues(new String[]{value});
        }
    }

    protected String cleanup(String value) {
        value = value.trim();
        int first = -1;
        for (int i = 0; i < value.length(); ++i) {
            if (first >= 0 || value.charAt(i) <= ' ') continue;
            first = i;
            break;
        }
        int last = -1;
        for (int i = value.length() - 1; i >= 0; --i) {
            if (last >= 0 || value.charAt(i) <= ' ') continue;
            last = i;
            break;
        }
        if (last < 0) {
            last = value.length() - 1;
        }
        if (first < 0) {
            first = 0;
        }
        value = value.substring(first, last + 1);
        return value;
    }

    void createvalue(SaxEvent value, DapAttribute parent) throws DapException {
        List<String> textlist = null;
        if (value.eventtype == SaxEventType.CHARACTERS) {
            textlist = ParseUtil.collectValues(value.text);
        } else if (value.eventtype == SaxEventType.ATTRIBUTE) {
            textlist = new ArrayList<String>();
            textlist.add(value.value);
        }
        if (textlist != null) {
            parent.setValues(textlist.toArray(new String[textlist.size()]));
        }
    }

    DapOtherXML createotherxml(Dap4Actions.XMLAttributeMap attrs, DapNode parent) throws DapException {
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent href = this.pull(attrs, "href");
        if (this.isempty(name)) {
            throw new ParseException("OtherXML: Empty name");
        }
        ArrayList<String> nslist = new ArrayList<String>();
        if (!this.isempty(href)) {
            nslist.add(href.value);
        }
        DapOtherXML other = (DapOtherXML)this.makeAttribute(DapSort.OTHERXML, name.value, null, nslist, parent);
        parent.setAttribute(other);
        return other;
    }

    @Override
    void enterdataset(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        boolean bl = this.debug = this.getDebugLevel() > 0;
        if (this.debug) {
            this.report("enterdataset");
        }
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent dapversion = this.pull(attrs, "dapversion");
        SaxEvent dmrversion = this.pull(attrs, "dmrversion");
        if (this.isempty(name)) {
            throw new ParseException("Empty dataset name attribute");
        }
        float ndapversion = 4.0f;
        if (dapversion != null) {
            try {
                ndapversion = Float.parseFloat(dapversion.value);
            }
            catch (NumberFormatException nfe) {
                ndapversion = 4.0f;
            }
        }
        if (ndapversion != 4.0f) {
            throw new ParseException("Dataset dapVersion mismatch: " + dapversion.value);
        }
        float ndmrversion = 1.0f;
        if (dmrversion != null) {
            try {
                ndmrversion = Float.parseFloat(dmrversion.value);
            }
            catch (NumberFormatException nfe) {
                ndmrversion = 1.0f;
            }
        }
        if (ndmrversion != 1.0f) {
            throw new ParseException("Dataset dmrVersion mismatch: " + dmrversion.value);
        }
        this.root = new DapDataset(name.value);
        this.root.setDapVersion(Float.toString(ndapversion));
        this.root.setDMRVersion(Float.toString(ndmrversion));
        this.root.setDataset(this.root);
        this.passReserved(attrs, this.root);
        this.scopestack.push(this.root);
    }

    @Override
    void leavedataset() throws ParseException {
        if (this.debug) {
            this.report("leavedataset");
        }
        assert (this.scopestack.peek() != null && this.scopestack.peek().getSort() == DapSort.DATASET);
        this.root.sort();
        this.scopestack.pop();
        if (!this.scopestack.isEmpty()) {
            throw new ParseException("Dataset: nested dataset");
        }
        this.root.finish();
    }

    @Override
    void entergroup(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        SaxEvent name;
        if (this.debug) {
            this.report("entergroup");
        }
        if (this.isempty(name = this.pull(attrs, "name"))) {
            throw new ParseException("Empty group name");
        }
        try {
            DapGroup parent = this.getGroupScope();
            DapGroup group = new DapGroup(name.value);
            this.passReserved(attrs, group);
            parent.addDecl(group);
            this.scopestack.push(group);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavegroup() throws ParseException {
        if (this.debug) {
            this.report("leavegroup");
        }
        this.scopestack.pop();
    }

    @Override
    void enterenumdef(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterenumdef");
        }
        try {
            SaxEvent name = this.pull(attrs, "name");
            if (this.isempty(name)) {
                throw new ParseException("Enumdef: Empty Enum Declaration name");
            }
            SaxEvent basetype = this.pull(attrs, "basetype");
            DapType basedaptype = null;
            if (basetype == null) {
                basedaptype = DapEnumeration.DEFAULTBASETYPE;
            } else {
                String typename = basetype.value;
                if ("Byte".equalsIgnoreCase(typename)) {
                    typename = "UInt8";
                }
                if ((basedaptype = (DapType)this.root.lookup(typename, DapSort.ATOMICTYPE)) == null || !this.islegalenumtype(basedaptype)) {
                    throw new ParseException("Enumdef: Invalid Enum Declaration Type name: " + basetype.value);
                }
            }
            DapEnumeration dapenum = null;
            dapenum = new DapEnumeration(name.value, basedaptype);
            this.passReserved(attrs, dapenum);
            DapGroup parent = this.getGroupScope();
            parent.addDecl(dapenum);
            this.scopestack.push(dapenum);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveenumdef() throws ParseException {
        DapEnumeration eparent;
        List<String> econsts;
        if (this.debug) {
            this.report("leaveenumdef");
        }
        if ((econsts = (eparent = (DapEnumeration)this.scopestack.pop()).getNames()).size() == 0) {
            throw new ParseException("Enumdef: no enum constants specified");
        }
    }

    @Override
    void enumconst(SaxEvent name, SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("enumconst");
        }
        if (this.isempty(name)) {
            throw new ParseException("Enumconst: Empty enum constant name");
        }
        if (this.isempty(value)) {
            throw new ParseException("Enumdef: Invalid enum constant value: " + value.value);
        }
        long lvalue = 0L;
        try {
            BigInteger bivalue = new BigInteger(value.value);
            bivalue = DapUtil.BIG_UMASK64.and(bivalue);
            lvalue = bivalue.longValue();
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Enumconst: illegal value: " + value.value);
        }
        try {
            DapEnumeration parent = (DapEnumeration)this.getScope(DapSort.ENUMERATION);
            if (!ParseUtil.isLegalEnumConstName(name.value)) {
                throw new ParseException("Enumconst: illegal enumeration constant name: " + name.value);
            }
            parent.addEnumConst(new DapEnumConst(name.value, lvalue));
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void enterdimdef(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterdimdef");
        }
        SaxEvent name = this.pull(attrs, "name");
        SaxEvent size = this.pull(attrs, "size");
        long lvalue = 0L;
        if (this.isempty(name)) {
            throw new ParseException("Dimdef: Empty dimension declaration name");
        }
        if (this.isempty(size)) {
            throw new ParseException("Dimdef: Empty dimension declaration size");
        }
        try {
            lvalue = Long.parseLong(size.value);
            if (lvalue <= 0L) {
                throw new ParseException("Dimdef: value <= 0: " + lvalue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Dimdef: non-integer value: " + size.value);
        }
        DapDimension dim = null;
        try {
            dim = new DapDimension(name.value, lvalue);
            this.passReserved(attrs, dim);
            dim.setShared(true);
            DapGroup parent = this.getGroupScope();
            parent.addDecl(dim);
            this.scopestack.push(dim);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavedimdef() throws ParseException {
        if (this.debug) {
            this.report("leavedimdef");
        }
        this.scopestack.pop();
    }

    @Override
    void dimref(SaxEvent nameorsize) throws ParseException {
        if (this.debug) {
            this.report("dimref");
        }
        try {
            DapDimension dim = null;
            DapVariable var = this.getVariableScope();
            assert (var != null) : "Internal error";
            boolean isname = nameorsize.name.equals("name");
            if (isname && this.isempty(nameorsize)) {
                throw new ParseException("Dimref: Empty dimension reference name");
            }
            if (this.isempty(nameorsize)) {
                throw new ParseException("Dimref: Empty dimension size");
            }
            if (isname) {
                DapGroup dg = var.getGroup();
                if (dg == null) {
                    throw new ParseException("Internal error: variable has no containing group");
                }
                DapGroup grp = var.getGroup();
                if (grp == null) {
                    throw new ParseException("Variable has no group");
                }
                dim = (DapDimension)grp.findByFQN(nameorsize.value, DapSort.DIMENSION);
            } else {
                long anonsize;
                String ssize = nameorsize.value.trim();
                assert (this.root != null);
                try {
                    anonsize = Long.parseLong(nameorsize.value.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Dimref: Illegal dimension size");
                }
                dim = this.root.createAnonymous(anonsize);
            }
            if (dim == null) {
                throw new ParseException("Unknown dimension: " + nameorsize.value);
            }
            var.addDimension(dim);
        }
        catch (DapException de) {
            throw new ParseException(de.getMessage(), de.getCause());
        }
    }

    @Override
    void enteratomicvariable(SaxEvent open, Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enteratomicvariable");
        }
        try {
            DapType basetype;
            SaxEvent name = this.pull(attrs, "name");
            if (this.isempty(name)) {
                throw new ParseException("Atomicvariable: Empty dimension reference name");
            }
            String typename = open.name;
            if ("Byte".equals(typename)) {
                typename = "UInt8";
            }
            if ((basetype = (DapType)this.root.lookup(typename, DapSort.ENUMERATION, DapSort.ATOMICTYPE)) == null) {
                throw new ParseException("AtomicVariable: Illegal type: " + open.name);
            }
            DapVariable var = null;
            var = new DapVariable(name.value, basetype);
            this.passReserved(attrs, var);
            DapNode parent = this.scopestack.peek();
            if (parent == null) {
                throw new ParseException("Variable has no parent");
            }
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case VARIABLE: {
                    this.addField((DapVariable)parent, var);
                    break;
                }
                default: {
                    assert (false) : "Atomic variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    void openclosematch(SaxEvent close, DapSort sort) throws ParseException {
        String typename = close.name;
        if ("Byte".equals(typename)) {
            typename = "UInt8";
        }
        switch (sort) {
            case VARIABLE: {
                TypeSort atype = TypeSort.getTypeSort(typename);
                DapVariable var = (DapVariable)this.searchScope(sort);
                assert (var != null);
                TypeSort vartype = var.getBaseType().getTypeSort();
                if (atype == null) {
                    throw new ParseException("Variable: Illegal type: " + typename);
                }
                if (atype == vartype) break;
                throw new ParseException(String.format("variable: open/close type mismatch: <%s> </%s>", new Object[]{vartype, atype}));
            }
            default: {
                throw new ParseException("Variable: Illegal type: " + typename);
            }
        }
    }

    void leavevariable() throws ParseException {
        this.scopestack.pop();
    }

    @Override
    void leaveatomicvariable(SaxEvent close) throws ParseException {
        this.openclosematch(close, DapSort.VARIABLE);
        this.leavevariable();
    }

    @Override
    void enterenumvariable(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        if (this.debug) {
            this.report("enterenumvariable");
        }
        try {
            SaxEvent name = this.pull(attrs, "name");
            SaxEvent enumtype = this.pull(attrs, "enum");
            if (this.isempty(name)) {
                throw new ParseException("Enumvariable: Empty variable name");
            }
            if (this.isempty(enumtype)) {
                throw new ParseException("Enumvariable: Empty enum type name");
            }
            DapEnumeration target = (DapEnumeration)this.root.findByFQN(enumtype.value, DapSort.ENUMERATION);
            if (target == null) {
                throw new ParseException("EnumVariable: no such enum: " + name.value);
            }
            DapVariable var = null;
            var = new DapVariable(name.value, target);
            this.passReserved(attrs, var);
            DapNode parent = this.scopestack.peek();
            if (parent == null) {
                throw new ParseException("Variable has no parent");
            }
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    break;
                }
                case VARIABLE: {
                    this.addField((DapVariable)parent, var);
                    break;
                }
                default: {
                    assert (false) : "Atomic variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveenumvariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leaveenumvariable");
        }
        this.openclosematch(close, DapSort.VARIABLE);
        this.leavevariable();
    }

    @Override
    void entermap(SaxEvent name) throws ParseException {
        DapNode scope;
        DapVariable var;
        if (this.debug) {
            this.report("entermap");
        }
        if (this.isempty(name)) {
            throw new ParseException("Mapref: Empty map name");
        }
        try {
            var = (DapVariable)this.root.findByFQN(name.value, DapSort.VARIABLE);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if (var == null) {
            throw new ParseException("Mapref: undefined variable: " + name.name);
        }
        DapNode container = var.getContainer();
        try {
            scope = this.getParentScope();
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if ((container.getSort() == DapSort.STRUCTURE || container.getSort() == DapSort.SEQUENCE) && container == scope) {
            throw new ParseException("Mapref: map variable not in outer scope: " + name.name);
        }
        DapMap map = new DapMap(var);
        try {
            DapVariable parent = (DapVariable)this.searchScope(DapSort.VARIABLE);
            if (parent == null) {
                throw new ParseException("Variable has no parent: " + var);
            }
            parent.addMap(map);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        this.scopestack.push(map);
    }

    @Override
    void leavemap() throws ParseException {
        if (this.debug) {
            this.report("leavemap");
        }
        this.scopestack.pop();
    }

    @Override
    void enterstructurevariable(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        SaxEvent name;
        if (this.debug) {
            this.report("enterstructurevariable");
        }
        if (this.isempty(name = this.pull(attrs, "name"))) {
            throw new ParseException("Structure: Empty structure name");
        }
        try {
            DapStructure type = null;
            DapVariable var = null;
            type = new DapStructure(name.value);
            this.passReserved(attrs, type);
            var = new DapVariable(name.value, type);
            DapNode parent = this.scopestack.peek();
            if (parent == null) {
                throw new ParseException("Variable has no parent");
            }
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    var.getGroup().addDecl(type);
                    break;
                }
                case VARIABLE: {
                    this.addField((DapVariable)parent, var);
                    var.getGroup().addDecl(type);
                    break;
                }
                default: {
                    assert (false) : "Structure variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavestructurevariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leavestructurevariable");
        }
        this.openclosematch(close, DapSort.VARIABLE);
        this.leavevariable();
    }

    @Override
    void entersequencevariable(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        SaxEvent name;
        if (this.debug) {
            this.report("entersequencevariable");
        }
        if (this.isempty(name = this.pull(attrs, "name"))) {
            throw new ParseException("Sequence: Empty sequence name");
        }
        try {
            DapVariable var = null;
            DapSequence type = null;
            type = new DapSequence(name.value);
            this.passReserved(attrs, type);
            var = new DapVariable(name.value, type);
            DapNode parent = this.scopestack.peek();
            if (parent == null) {
                throw new ParseException("Variable has no parent");
            }
            switch (parent.getSort()) {
                case DATASET: 
                case GROUP: {
                    ((DapGroup)parent).addDecl(var);
                    var.getGroup().addDecl(type);
                    break;
                }
                case VARIABLE: {
                    this.addField((DapVariable)parent, var);
                    var.getGroup().addDecl(type);
                    break;
                }
                default: {
                    assert (false) : "Structure variable in illegal scope";
                    break;
                }
            }
            this.scopestack.push(var);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavesequencevariable(SaxEvent close) throws ParseException {
        if (this.debug) {
            this.report("leavesequencevariable");
        }
        this.openclosematch(close, DapSort.VARIABLE);
        this.leavevariable();
    }

    @Override
    void enteratomicattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist) throws ParseException {
        if (this.debug) {
            this.report("enteratomicattribute");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapAttribute attr = null;
            attr = this.createatomicattribute(attrs, nslist, parent);
            this.scopestack.push(attr);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leaveatomicattribute() throws ParseException {
        DapAttribute attr;
        if (this.debug) {
            this.report("leaveatomicattribute");
        }
        if (Array.getLength((attr = (DapAttribute)this.scopestack.pop()).getValues()) == 0) {
            throw new ParseException("AtomicAttribute: attribute has no values");
        }
    }

    @Override
    void entercontainerattribute(Dap4Actions.XMLAttributeMap attrs, Dap4Actions.NamespaceList nslist) throws ParseException {
        if (this.debug) {
            this.report("entercontainerattribute");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapAttribute attr = null;
            attr = this.createcontainerattribute(attrs, nslist, parent);
            this.scopestack.push(attr);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void leavecontainerattribute() throws ParseException {
        if (this.debug) {
            this.report("leavecontainerattribute");
        }
        this.scopestack.pop();
    }

    @Override
    void value(String value) throws ParseException {
        if (this.debug) {
            this.report("value");
        }
        try {
            DapAttribute parent = (DapAttribute)this.getScope(DapSort.ATTRIBUTE);
            this.createvalue(value, parent);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void value(SaxEvent value) throws ParseException {
        if (this.debug) {
            this.report("value");
        }
        try {
            DapAttribute parent = (DapAttribute)this.getScope(DapSort.ATTRIBUTE);
            this.createvalue(value, parent);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    void otherxml(Dap4Actions.XMLAttributeMap attrs, DapXML root) throws ParseException {
        if (this.debug) {
            this.report("enterotherxml");
        }
        try {
            DapNode parent = this.getMetadataScope();
            DapOtherXML other = this.createotherxml(attrs, parent);
            parent.setAttribute(other);
            other.setRoot(root);
            if (this.debug) {
                this.report("leaveotherxml");
            }
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    @Override
    DapXML.XMLList xml_body(DapXML.XMLList body, DapXML elemortext) throws ParseException {
        if (this.debug) {
            this.report("xml_body.enter");
        }
        if (body == null) {
            body = new DapXML.XMLList();
        }
        if (elemortext != null) {
            body.add(elemortext);
        }
        if (this.debug) {
            this.report("xml_body.exit");
        }
        return body;
    }

    @Override
    DapXML element_or_text(SaxEvent open, Dap4Actions.XMLAttributeMap map, DapXML.XMLList body, SaxEvent close) throws ParseException {
        try {
            if (this.debug) {
                this.report("element_or_text.enter");
            }
            if (!open.name.equalsIgnoreCase(close.name)) {
                throw new ParseException(String.format("OtherXML: mismatch: <%s> vs </%s>", open.name, close.name));
            }
            DapXML thisxml = this.createxmlelement(open, map);
            for (DapXML xml : body) {
                thisxml.addElement(xml);
            }
            if (this.debug) {
                this.report("element_or_text.exit");
            }
            return thisxml;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    @Override
    DapXML xmltext(SaxEvent text) throws ParseException {
        try {
            if (this.debug) {
                this.report("xmltext");
            }
            DapXML txt = this.createxmltext(text.text);
            return txt;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    @Override
    void entererror(Dap4Actions.XMLAttributeMap attrs) throws ParseException {
        SaxEvent xhttpcode;
        if (this.debug) {
            this.report("entererror");
        }
        String shttpcode = (xhttpcode = this.pull(attrs, "httpcode")) == null ? "400" : xhttpcode.value;
        int httpcode = 0;
        try {
            httpcode = Integer.parseInt(shttpcode);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error Response; illegal http code: " + shttpcode);
        }
        this.errorresponse = new ErrorResponse();
        this.errorresponse.setCode(httpcode);
    }

    @Override
    void leaveerror() throws ParseException {
        if (this.debug) {
            this.report("leaveerror");
        }
        assert (this.errorresponse != null) : "Internal Error";
    }

    @Override
    void errormessage(String value) throws ParseException {
        if (this.debug) {
            this.report("errormessage");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String message = value;
        message = Escape.entityUnescape(message);
        this.errorresponse.setMessage(message);
    }

    @Override
    void errorcontext(String value) throws ParseException {
        if (this.debug) {
            this.report("errorcontext");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String context = value;
        context = Escape.entityUnescape(context);
        this.errorresponse.setContext(context);
    }

    @Override
    void errorotherinfo(String value) throws ParseException {
        if (this.debug) {
            this.report("errorotherinfo");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String other = value;
        other = Escape.entityUnescape(other);
        this.errorresponse.setOtherInfo(other);
    }

    @Override
    String textstring(String prefix, SaxEvent text) throws ParseException {
        if (this.debug) {
            this.report("text");
        }
        if (prefix == null) {
            return text.text;
        }
        return prefix + text.text;
    }

    void addField(DapVariable instance, DapVariable field) throws DapException {
        DapType t = instance.getBaseType();
        switch (t.getTypeSort()) {
            case Structure: 
            case Sequence: {
                ((DapStructure)t).addField(field);
                field.setParent(instance);
                break;
            }
            default: {
                assert (false) : "Container cannot be atomic variable";
                break;
            }
        }
    }

    void report(String action) {
        this.getDebugStream().println("ACTION: " + action);
        this.getDebugStream().flush();
    }

    static boolean isReserved(String name) {
        for (String tag : RESERVEDTAGS) {
            if (!name.startsWith(tag)) continue;
            return true;
        }
        return false;
    }
}

