/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.data.DSP;
import dap4.core.data.DSPRegistry;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.servlet.DSPFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DapCache {
    static final int MAXFILES = 100;
    public static final String MATCHMETHOD = "dspMatch";
    public static DSPRegistry dspregistry = new DSPRegistry();
    protected static List<DSP> lru = new ArrayList<DSP>();
    protected static DSPFactory factory = null;

    public static void setFactory(DSPFactory f) {
        factory = f;
    }

    public static DSPFactory getFactory() {
        return factory;
    }

    public static synchronized DSP open(String path, DapContext cxt) throws IOException {
        DSP dsp;
        assert (cxt != null);
        int lrusize = lru.size();
        for (int i = lrusize - 1; i >= 0; --i) {
            DSP dsp2 = lru.get(i);
            String dsppath = dsp2.getLocation();
            if (!dsppath.equals(path)) continue;
            lru.remove(i);
            lru.add(dsp2);
            CEConstraint.release(lru.get(0).getDMR());
            return dsp2;
        }
        if (lrusize == 100) {
            lru.remove(0);
            CEConstraint.release(lru.get(0).getDMR());
        }
        if ((dsp = dspregistry.findMatchingDSP(path, cxt)) == null) {
            throw new DapException("Resource has no matching DSP: " + path).setCode(403);
        }
        dsp.setContext(cxt);
        dsp.open(path);
        lru.add(dsp);
        return dsp;
    }

    public static synchronized void flush() throws Exception {
        while (lru.size() > 0) {
            DSP dsp = lru.get(0);
            CEConstraint.release(dsp.getDMR());
            dsp.close();
            lru.remove(0);
        }
    }
}

