/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapNode;
import dap4.core.util.DapSort;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DapIterator
implements Iterator<DapNode> {
    int index;
    boolean valid;
    List<DapNode> source;
    EnumSet<DapSort> sortset;

    public DapIterator(List<DapNode> source, EnumSet<DapSort> sortset) {
        this.source = source;
        if (sortset == null) {
            sortset = EnumSet.allOf(DapSort.class);
        }
        this.sortset = sortset;
        this.index = -1;
        this.valid = false;
    }

    @Override
    public boolean hasNext() {
        if (!this.valid) {
            this.findNext();
        }
        return this.valid;
    }

    @Override
    public DapNode next() {
        if (!this.valid) {
            this.findNext();
        }
        if (!this.valid) {
            throw new NoSuchElementException();
        }
        this.valid = false;
        return this.source.get(this.index);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected boolean findNext() {
        if (this.valid) {
            return true;
        }
        ++this.index;
        while (this.index < this.source.size()) {
            DapNode node = this.source.get(this.index);
            if (this.sortset.contains((Object)node.getSort())) {
                this.valid = true;
                break;
            }
            ++this.index;
        }
        return this.valid;
    }
}

