/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class HttpHeadFilter
implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        if (this.isHttpHead(httpServletRequest)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            NoBodyResponseWrapper noBodyResponseWrapper = new NoBodyResponseWrapper(httpServletResponse);
            chain.doFilter(new ForceGetRequestWrapper(httpServletRequest), noBodyResponseWrapper);
            noBodyResponseWrapper.setContentLength();
        } else {
            chain.doFilter(request, response);
        }
    }

    @Override
    public void destroy() {
    }

    private boolean isHttpHead(HttpServletRequest request) {
        return "HEAD".equals(request.getMethod());
    }

    private class NoBodyOutputStream
    extends ServletOutputStream {
        private int contentLength = 0;

        private NoBodyOutputStream() {
        }

        int getContentLength() {
            return this.contentLength;
        }

        @Override
        public void write(int b) {
            ++this.contentLength;
        }

        @Override
        public void write(byte[] buf, int offset, int len) throws IOException {
            this.contentLength += len;
        }

        @Override
        public boolean isReady() {
            return true;
        }

        @Override
        public void setWriteListener(WriteListener writeListener) {
            throw new UnsupportedOperationException("NoBodyOutputStream does not support setWriteListener");
        }
    }

    private class NoBodyResponseWrapper
    extends HttpServletResponseWrapper {
        private final NoBodyOutputStream noBodyOutputStream;
        private PrintWriter writer;

        public NoBodyResponseWrapper(HttpServletResponse response) {
            super(response);
            this.noBodyOutputStream = new NoBodyOutputStream();
        }

        @Override
        public ServletOutputStream getOutputStream() throws IOException {
            return this.noBodyOutputStream;
        }

        @Override
        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.writer == null) {
                this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.noBodyOutputStream, this.getCharacterEncoding()));
            }
            return this.writer;
        }

        void setContentLength() {
            super.setContentLength(this.noBodyOutputStream.getContentLength());
        }
    }

    private class ForceGetRequestWrapper
    extends HttpServletRequestWrapper {
        public ForceGetRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        @Override
        public String getMethod() {
            return "GET";
        }
    }
}

