/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.parser.ParseException;
import java.util.ArrayList;
import java.util.List;

public class ParseUtil {
    public static final int MAXTEXT = 12;
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ESCAPE = 1;
    public static final int FLAG_NOCR = 2;
    public static final int FLAG_ELIDETEXT = 4;
    public static final int FLAG_TRIMTEXT = 8;
    public static final int FLAG_TRACE = 16;
    public static final int DEFAULTFLAGS = 15;

    public static boolean namechar1(char c) {
        return ":_?".indexOf(c) >= 0 || "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c) >= 0 || c > '\u007f';
    }

    public static boolean namecharn(char c) {
        return ParseUtil.namechar1(c) || "-.".indexOf(c) >= 0 || "0123456789".indexOf(c) >= 0;
    }

    public static List<String> collectValues(String text) throws ParseException {
        char c;
        ArrayList<String> values = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        text = text.trim() + '\u0000';
        int i = 0;
        while ((c = text.charAt(i++)) != '\u0000') {
            if (c <= ' ' || c == '\u007f') continue;
            if (c == '\'') {
                if ((c = text.charAt(i++)) == '\u0000') {
                    throw new ParseException("Malformed char constant: no final '''");
                }
                if (i >= 128) {
                    throw new ParseException("Illegal char constant: " + c);
                }
                buf.append(c);
                values.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            if (c == '\"') {
                while (true) {
                    if ((c = text.charAt(i++)) == '\u0000') {
                        --i;
                        break;
                    }
                    if (c == '\\') {
                        c = text.charAt(i++);
                    } else if (c == '\"') break;
                    buf.append(c);
                }
                if (c == '\u0000') {
                    throw new ParseException("Malformed string: no final '\"'");
                }
                values.add(buf.toString());
                buf.setLength(0);
                continue;
            }
            do {
                if (c == '\\') {
                    c = text.charAt(i++);
                }
                buf.append(c);
            } while ((c = text.charAt(i++)) > ' ' && c != '\u007f');
            values.add(buf.toString());
            buf.setLength(0);
            if (c != '\u0000') continue;
            --i;
        }
        return values;
    }

    public static boolean isLegalEnumConstName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c > ' ' && c != '\u007f') continue;
            return false;
        }
        return true;
    }
}

