/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.d4ts.FrontPage;
import dap4.dap4lib.DapLog;
import dap4.dap4lib.FileDSP;
import dap4.dap4lib.netcdf.Nc4DSP;
import dap4.servlet.DSPFactory;
import dap4.servlet.DapCache;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import dap4.servlet.SynDSP;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class D4TSServlet
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    protected static final String RESOURCEPATH = "WEB-INF/resources";
    protected List<FrontPage.Root> defaultroots = null;

    @Override
    public void initialize() {
        super.initialize();
        DapLog.info("Initializing d4ts servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.handleRequest(req, resp);
    }

    @Override
    protected void doFavicon(String icopath, DapContext cxt) throws IOException {
        DapRequest drq = (DapRequest)cxt.get(DapRequest.class);
        String favfile = this.getResourcePath(drq, icopath);
        if (favfile != null) {
            try (FileInputStream fav = new FileInputStream(favfile);){
                byte[] content = DapUtil.readbinaryfile(fav);
                OutputStream out = drq.getOutputStream();
                out.write(content);
            }
        }
    }

    @Override
    protected void doCapabilities(DapRequest drq, DapContext cxt) throws IOException {
        this.addCommonHeaders(drq);
        FrontPage front = this.getFrontPage(drq, cxt);
        String frontpage = front.buildPage();
        if (frontpage == null) {
            throw new DapException("Cannot create front page").setCode(500);
        }
        byte[] frontpage8 = DapUtil.extract(DapUtil.UTF8.encode(frontpage));
        OutputStream out = drq.getOutputStream();
        out.write(frontpage8);
    }

    @Override
    public String getResourcePath(DapRequest drq, String location) throws DapException {
        String prefix = drq.getResourceRoot();
        if (prefix == null) {
            throw new DapException("Cannot find location resource: " + location).setCode(404);
        }
        String datasetfilepath = DapUtil.canonjoin(prefix, location = DapUtil.canonicalpath(location));
        File dataset = new File(datasetfilepath);
        if (!dataset.exists()) {
            String msg = String.format("Requested file does not exist: prefix=%s location=%s datasetfilepath=%s", prefix, location, datasetfilepath);
            throw new DapException(msg).setCode(404);
        }
        if (!dataset.canRead()) {
            throw new DapException("Requested file not readable: " + datasetfilepath).setCode(403);
        }
        return datasetfilepath;
    }

    @Override
    public long getBinaryWriteLimit() {
        return 100000000L;
    }

    @Override
    public String getServletID() {
        return "d4ts";
    }

    protected FrontPage getFrontPage(DapRequest drq, DapContext cxt) throws DapException {
        if (this.defaultroots == null) {
            String pageroot = this.getResourcePath(drq, "");
            if (pageroot == null) {
                throw new DapException("Cannot locate resources directory");
            }
            this.defaultroots = new ArrayList<FrontPage.Root>();
            this.defaultroots.add(new FrontPage.Root("testfiles", pageroot));
        }
        return new FrontPage(this.defaultroots, drq);
    }

    static {
        DapCache.setFactory(new D4TSFactory());
    }

    static class D4TSFactory
    extends DSPFactory {
        public D4TSFactory() {
            DapCache.dspregistry.register(Nc4DSP.class, true);
            DapCache.dspregistry.register(SynDSP.class, true);
            DapCache.dspregistry.register(FileDSP.class, true);
        }
    }
}

