/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.DMRFactory;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapAttributeSet;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.ErrorResponse;
import dap4.core.dmr.TypeSort;
import dap4.core.dmr.parser.Dap4Parser;
import dap4.core.dmr.parser.ParseException;
import dap4.core.dmr.parser.ParseUtil;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOM4Parser
implements Dap4Parser {
    static final float DAPVERSION = 4.0f;
    static final float DMRVERSION = 1.0f;
    static final String DEFAULTATTRTYPE = "Int32";
    static final int RULENULL = 0;
    static final int RULEDIMREF = 1;
    static final int RULEMAPREF = 2;
    static final int RULEVAR = 3;
    static final int RULEMETADATA = 4;
    static final String[] RESERVEDTAGS = new String[]{"_edu.ucar"};
    static final BigInteger BIG_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static final DapSort[] METADATASCOPES = new DapSort[]{DapSort.DATASET, DapSort.GROUP, DapSort.DIMENSION, DapSort.MAP, DapSort.VARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE, DapSort.ATTRIBUTESET};
    static final Map<String, DapSort> sortmap = new HashMap<String, DapSort>();
    static final Map<String, TypeSort> typemap;
    protected static int globaldebuglevel;
    protected static PrintStream debugstream;
    protected DMRFactory factory = null;
    protected ErrorResponse errorresponse = null;
    protected Deque<DapNode> scopestack = new ArrayDeque<DapNode>();
    protected DapDataset root = null;
    protected boolean trace = false;
    protected boolean debug = false;
    protected Map<Node, DapGroup> groupmap = new HashMap<Node, DapGroup>();

    public static void setGlobalDebugLevel(int level) {
        globaldebuglevel = level;
    }

    public void setDebugStream(PrintStream stream) {
        if (stream != null) {
            debugstream = stream;
        }
    }

    static DapSort nodesort(Node n) {
        String elem = n.getNodeName();
        DapSort sort = sortmap.get(elem.toLowerCase());
        return sort;
    }

    static TypeSort nodetypesort(Node n) {
        String elem = n.getNodeName();
        TypeSort sort = typemap.get(elem.toLowerCase());
        return sort;
    }

    public DOM4Parser(DMRFactory factory) {
        DMRFactory dMRFactory = this.factory = factory == null ? new DMRFactory() : factory;
        if (globaldebuglevel > 0) {
            this.setDebugLevel(globaldebuglevel);
        }
    }

    @Override
    public void setDebugLevel(int level) {
        DOM4Parser.setGlobalDebugLevel(level);
    }

    @Override
    public ErrorResponse getErrorResponse() {
        return this.errorresponse;
    }

    @Override
    public DapDataset getDMR() {
        return this.root;
    }

    @Override
    public boolean parse(String input) throws SAXException {
        try {
            DocumentBuilderFactory domfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dombuilder = domfactory.newDocumentBuilder();
            StringReader rdr = new StringReader(input);
            InputSource src = new InputSource(rdr);
            Document doc = dombuilder.parse(src);
            doc.getDocumentElement().normalize();
            rdr.close();
            this.parseresponse(doc.getDocumentElement());
            return true;
        }
        catch (IOException | ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    DapGroup getGroupScope() throws ParseException {
        DapGroup gscope = (DapGroup)this.searchScope(DapSort.GROUP, DapSort.DATASET);
        if (gscope == null) {
            throw new ParseException("Undefined Group Scope");
        }
        return gscope;
    }

    DapNode getMetadataScope() throws ParseException {
        DapNode match = this.searchScope(METADATASCOPES);
        if (match == null) {
            throw new ParseException("No enclosing metadata capable scope");
        }
        return match;
    }

    DapNode getParentScope() throws DapException {
        DapNode parent = this.searchScope(DapSort.STRUCTURE, DapSort.SEQUENCE, DapSort.GROUP, DapSort.DATASET, DapSort.ENUMERATION);
        if (parent == null) {
            throw new DapException("Undefined parent Scope");
        }
        return parent;
    }

    DapVariable getVariableScope() throws DapException {
        DapNode match = this.searchScope(DapSort.VARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE);
        if (match == null) {
            throw new ParseException("No enclosing variable scope");
        }
        return (DapVariable)match;
    }

    DapNode getScope(DapSort ... sort) throws DapException {
        DapNode node = this.searchScope(sort);
        if (node == null) {
            throw new ParseException("No enclosing scope of specified type");
        }
        return node;
    }

    DapNode searchScope(DapSort ... sort) {
        for (DapNode node : this.scopestack) {
            for (int j = 0; j < sort.length; ++j) {
                if (node.getSort() != sort[j]) continue;
                return node;
            }
        }
        return null;
    }

    DapVariable findVariable(DapNode parent, String name) {
        DapVariable var = null;
        switch (parent.getSort()) {
            case DATASET: 
            case GROUP: {
                var = ((DapGroup)parent).findVariable(name);
                break;
            }
            case STRUCTURE: {
                var = ((DapStructure)parent).findByName(name);
                break;
            }
            case SEQUENCE: {
                var = ((DapSequence)parent).findByName(name);
                break;
            }
        }
        return var;
    }

    protected String pull(Node n, String name) {
        NamedNodeMap map = n.getAttributes();
        Node attr = map.getNamedItem(name);
        if (attr == null) {
            return null;
        }
        return attr.getNodeValue();
    }

    DapAttribute makeAttribute(DapSort sort, String name, DapType basetype, List<String> nslist) throws ParseException {
        DapAttribute attr = this.factory.newAttribute(name, basetype);
        if (sort == DapSort.ATTRIBUTE) {
            attr.setBaseType(basetype);
        }
        attr.setNamespaceList(nslist);
        return attr;
    }

    boolean isempty(String text) {
        return text == null || text.length() == 0;
    }

    boolean islegalenumtype(DapType kind) {
        return kind.isIntegerType();
    }

    boolean islegalattributetype(DapType kind) {
        return kind.isLegalAttrType();
    }

    protected void trace(String action) {
        if (!this.trace) {
            return;
        }
        debugstream.println("ACTION: " + action);
        debugstream.flush();
    }

    List<Node> getSubnodes(Node parent) {
        ArrayList<Node> subs = new ArrayList<Node>();
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() != 1) continue;
            subs.add(n);
        }
        return subs;
    }

    String getNodeText(Node n) {
        return n.getTextContent();
    }

    protected String cleanup(String value) {
        value = value.trim();
        int first = -1;
        for (int i = 0; i < value.length(); ++i) {
            if (first >= 0 || value.charAt(i) <= ' ') continue;
            first = i;
            break;
        }
        int last = -1;
        for (int i = value.length() - 1; i >= 0; --i) {
            if (last >= 0 || value.charAt(i) <= ' ') continue;
            last = i;
            break;
        }
        if (last < 0) {
            last = value.length() - 1;
        }
        if (first < 0) {
            first = 0;
        }
        value = value.substring(first, last + 1);
        return value;
    }

    protected void addField(DapVariable instance, DapVariable field) throws DapException {
        DapType t = instance.getBaseType();
        this.addField(t, field);
    }

    protected void addField(DapType t, DapVariable field) throws DapException {
        switch (t.getTypeSort()) {
            case Structure: 
            case Sequence: {
                ((DapStructure)t).addField(field);
                field.setParent(t);
                break;
            }
            default: {
                assert (false) : "Container must be struct or seq";
                break;
            }
        }
    }

    protected void recorddecl(DapNode n, DapGroup parent) throws ParseException {
        try {
            parent.addDecl(n);
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void recordfield(DapVariable var, DapStructure parent) throws ParseException {
        try {
            this.addField(parent, var);
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void recordattr(DapAttribute attr, DapNode parent) throws ParseException {
        try {
            parent.addAttribute(attr);
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void parseresponse(Node root) throws ParseException {
        String elemname = root.getNodeName();
        if (elemname.equalsIgnoreCase("Error")) {
            this.parseerror(root);
        } else if (elemname.equalsIgnoreCase("Dataset")) {
            this.parsedataset(root);
        } else {
            throw new ParseException("Unexpected response root: " + elemname);
        }
    }

    protected void parsedataset(Node rootnode) throws ParseException {
        String dmrversion;
        if (this.trace) {
            this.trace("dataset.enter");
        }
        String name = this.pull(rootnode, "name");
        String dapversion = this.pull(rootnode, "dapVersion");
        if (dapversion == null) {
            dapversion = this.pull(rootnode, "dapversion");
        }
        if ((dmrversion = this.pull(rootnode, "dmrVersion")) == null) {
            dmrversion = this.pull(rootnode, "dmrversion");
        }
        if (this.isempty(name)) {
            throw new ParseException("Empty dataset name attribute");
        }
        float ndapversion = 4.0f;
        if (dapversion != null) {
            try {
                ndapversion = Float.parseFloat(dapversion);
            }
            catch (NumberFormatException nfe) {
                ndapversion = 4.0f;
            }
        }
        if (ndapversion != 4.0f) {
            throw new ParseException("Dataset dapVersion mismatch: " + dapversion);
        }
        float ndmrversion = 4.0f;
        if (dmrversion != null) {
            try {
                ndmrversion = Float.parseFloat(dmrversion);
            }
            catch (NumberFormatException nfe) {
                ndmrversion = 1.0f;
            }
        }
        if (ndmrversion != 1.0f) {
            throw new ParseException("Dataset dmrVersion mismatch: " + dmrversion);
        }
        this.root = this.factory.newDataset(name);
        this.root.setDapVersion(Float.toString(ndapversion));
        this.root.setDMRVersion(Float.toString(ndmrversion));
        this.root.setDataset(this.root);
        this.passReserved(rootnode, this.root);
        this.scopestack.push(this.root);
        this.fillgroupdefs(rootnode, this.root);
        this.fillgroupvars(rootnode, this.root);
        if (this.trace) {
            this.trace("dataset.exit");
        }
        assert (this.scopestack.peek() != null && this.scopestack.peek().getSort() == DapSort.DATASET);
        this.root.sort();
        this.scopestack.pop();
        if (!this.scopestack.isEmpty()) {
            throw new ParseException("Dataset: nested dataset");
        }
        this.root.finish();
    }

    protected void fillgroupdefs(Node domgroup, DapGroup group) throws ParseException {
        try {
            if (this.trace) {
                this.trace("fillgroupdefs.enter");
            }
            List<Node> nodes = this.getSubnodes(domgroup);
            block7: for (int i = 0; i < nodes.size(); ++i) {
                Node n = nodes.get(i);
                String name = this.pull(n, "name");
                if (this.isempty(name)) {
                    throw new ParseException("Fillgroup: Empty node name");
                }
                DapSort sort = DOM4Parser.nodesort(n);
                switch (sort) {
                    case ENUMERATION: {
                        this.recorddecl(this.parseenumdef(n), group);
                        continue block7;
                    }
                    case DIMENSION: {
                        this.recorddecl(this.parsedimdef(n), group);
                        continue block7;
                    }
                    case GROUP: {
                        DapGroup g2 = this.parsegroupdefs(n);
                        this.recorddecl(g2, group);
                        this.groupmap.put(n, g2);
                        continue block7;
                    }
                }
            }
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void fillgroupvars(Node domgroup, DapGroup group) throws ParseException {
        try {
            if (this.trace) {
                this.trace("fillgroupvars.enter");
            }
            List<Node> nodes = this.getSubnodes(domgroup);
            block12: for (int i = 0; i < nodes.size(); ++i) {
                Node n = nodes.get(i);
                String name = this.pull(n, "name");
                if (this.isempty(name)) {
                    throw new ParseException("Fillgroup: Empty node name");
                }
                DapSort sort = DOM4Parser.nodesort(n);
                switch (sort) {
                    case GROUP: {
                        DapGroup ngroup = this.groupmap.get(n);
                        assert (ngroup != null);
                        this.parsegroupvars(n, ngroup);
                        continue block12;
                    }
                    case VARIABLE: {
                        TypeSort type = DOM4Parser.nodetypesort(n);
                        if (type.isEnumType()) {
                            this.recorddecl(this.parseenumvar(n), group);
                            continue block12;
                        }
                        if (type.isAtomic()) {
                            this.recorddecl(this.parseatomicvar(n), group);
                            continue block12;
                        }
                        throw new ParseException("Illegal variable type: " + name);
                    }
                    case STRUCTURE: {
                        DapVariable v = this.parsestructvar(n);
                        this.recorddecl(v.getBaseType(), group);
                        this.recorddecl(v, group);
                        continue block12;
                    }
                    case SEQUENCE: {
                        DapVariable v = this.parseseqvar(n);
                        this.recorddecl(v.getBaseType(), group);
                        this.recorddecl(v, group);
                        continue block12;
                    }
                    case ATTRIBUTESET: {
                        this.recordattr(this.parseattrset(n), group);
                        continue block12;
                    }
                    case ATTRIBUTE: {
                        this.recordattr(this.parseattr(n), group);
                        continue block12;
                    }
                    case OTHERXML: {
                        this.recordattr(this.parseotherxml(n), group);
                        continue block12;
                    }
                    case ENUMERATION: 
                    case DIMENSION: {
                        continue block12;
                    }
                    default: {
                        throw new ParseException("Unexpected element: " + n);
                    }
                }
            }
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapGroup parsegroupdefs(Node node) throws DapException {
        String name;
        if (this.trace) {
            this.trace("groupdefs.enter");
        }
        if (this.isempty(name = this.pull(node, "name"))) {
            throw new ParseException("Empty group name");
        }
        try {
            DapGroup g2 = this.factory.newGroup(name);
            this.passReserved(node, g2);
            this.scopestack.push(g2);
            this.fillgroupdefs(node, g2);
            if (this.trace) {
                this.trace("group.exit");
            }
            this.scopestack.pop();
            return g2;
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    protected DapEnumeration parseenumdef(Node node) throws ParseException {
        try {
            String name;
            if (this.trace) {
                this.trace("enumdef.enter");
            }
            if (this.isempty(name = this.pull(node, "name"))) {
                throw new ParseException("Enumdef: Empty Enum Declaration name");
            }
            String typename = this.pull(node, "basetype");
            DapType basedaptype = null;
            if (typename == null) {
                basedaptype = DapEnumeration.DEFAULTBASETYPE;
            } else {
                if ("Byte".equalsIgnoreCase(typename)) {
                    typename = "UInt8";
                }
                if ((basedaptype = (DapType)this.root.lookup(typename, DapSort.ATOMICTYPE)) == null || !this.islegalenumtype(basedaptype)) {
                    throw new ParseException("Enumdef: Invalid Enum Declaration Type name: " + typename);
                }
            }
            DapEnumeration dapenum = this.factory.newEnumeration(name, basedaptype);
            this.scopestack.push(dapenum);
            List<DapEnumConst> econsts = this.parseenumconsts(node);
            if (econsts.size() == 0) {
                throw new ParseException("Enumdef: no enum constants specified");
            }
            DapEnumeration eparent = (DapEnumeration)this.scopestack.pop();
            eparent.setEnumConsts(econsts);
            if (this.trace) {
                this.trace("enumdef.exit");
            }
            return dapenum;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected List<DapEnumConst> parseenumconsts(Node enumdef) throws ParseException {
        if (this.trace) {
            this.trace("enumconsts.enter");
        }
        ArrayList<DapEnumConst> econsts = new ArrayList<DapEnumConst>();
        List<Node> nodes = this.getSubnodes(enumdef);
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            DapEnumConst dec = this.parseenumconst(n);
            econsts.add(dec);
        }
        if (this.trace) {
            this.trace("enumconsts.exit");
        }
        return econsts;
    }

    protected DapEnumConst parseenumconst(Node node) throws ParseException {
        try {
            if (this.trace) {
                this.trace("enumconst.enter");
            }
            String name = this.pull(node, "name");
            String value = this.pull(node, "value");
            if (this.isempty(name)) {
                throw new ParseException("Enumconst: Empty enum constant name");
            }
            if (this.isempty(value)) {
                throw new ParseException("Enumdef: Invalid enum constant value: " + value);
            }
            long lvalue = 0L;
            try {
                BigInteger bivalue = new BigInteger(value);
                bivalue = DapUtil.BIG_UMASK64.and(bivalue);
                lvalue = bivalue.longValue();
            }
            catch (NumberFormatException nfe) {
                throw new ParseException("Enumconst: illegal value: " + value);
            }
            DapEnumeration parent = (DapEnumeration)this.getScope(DapSort.ENUMERATION);
            if (!ParseUtil.isLegalEnumConstName(name)) {
                throw new ParseException("Enumconst: illegal enumeration constant name: " + name);
            }
            DapEnumConst dec = new DapEnumConst(name, lvalue);
            return dec;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapGroup parsegroupvars(Node node, DapGroup group) throws DapException {
        if (this.trace) {
            this.trace("groupvars.enter");
        }
        String name = this.pull(node, "name");
        try {
            this.scopestack.push(group);
            this.fillgroupvars(node, group);
            if (this.trace) {
                this.trace("groupvars.exit");
            }
            this.scopestack.pop();
            return group;
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    protected DapDimension parsedimdef(Node node) throws ParseException {
        if (this.trace) {
            this.trace("dimdef.enter");
        }
        String name = this.pull(node, "name");
        String size = this.pull(node, "size");
        long lvalue = 0L;
        if (this.isempty(name)) {
            throw new ParseException("Dimdef: Empty dimension declaration name");
        }
        if (this.isempty(size)) {
            throw new ParseException("Dimdef: Empty dimension declaration size");
        }
        try {
            lvalue = Long.parseLong(size);
            if (lvalue <= 0L) {
                throw new ParseException("Dimdef: value <= 0: " + lvalue);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Dimdef: non-integer value: " + size);
        }
        DapDimension dim = this.factory.newDimension(name, lvalue);
        dim.setShared(true);
        if (this.trace) {
            this.trace("dimdef.exit");
        }
        return dim;
    }

    protected DapVariable parseenumvar(Node node) throws ParseException {
        if (this.trace) {
            this.trace("enumvar.enter");
        }
        String typename = node.getNodeName();
        assert ("enum".equalsIgnoreCase(typename));
        try {
            String enumfqn = this.pull(node, "enum");
            if (this.isempty(enumfqn)) {
                throw new ParseException("Enumvariable: Empty enum type name");
            }
            DapEnumeration basetype = (DapEnumeration)this.root.findByFQN(enumfqn, DapSort.ENUMERATION);
            if (basetype == null) {
                throw new ParseException("EnumVariable: no such enum: " + enumfqn);
            }
            String name = this.pull(node, "name");
            if (this.isempty(name)) {
                throw new ParseException("Enumvar: Empty variable name");
            }
            DapVariable var = this.factory.newVariable(name, basetype);
            this.passReserved(node, var);
            this.scopestack.push(var);
            this.fillmetadata(node, var);
            this.scopestack.pop();
            return var;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapVariable parseatomicvar(Node node) throws ParseException {
        String name;
        if (this.trace) {
            this.trace("atomicvariable.enter");
        }
        if (this.isempty(name = this.pull(node, "name"))) {
            throw new ParseException("Atomicvariable: Empty variable name");
        }
        String typename = node.getNodeName();
        if ("Byte".equals(typename)) {
            typename = "UInt8";
        }
        try {
            DapType basetype = (DapType)this.root.lookup(typename, DapSort.ATOMICTYPE);
            if (basetype == null) {
                throw new ParseException("AtomicVariable: Illegal type: " + typename);
            }
            DapVariable var = this.factory.newVariable(name, basetype);
            this.passReserved(node, var);
            this.scopestack.push(var);
            this.fillmetadata(node, var);
            this.scopestack.pop();
            return var;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapVariable parsestructvar(Node node) throws ParseException {
        String name;
        if (this.trace) {
            this.trace("structvariable.enter");
        }
        if (this.isempty(name = this.pull(node, "name"))) {
            throw new ParseException("Structvar: Empty variable name");
        }
        String typename = node.getNodeName();
        try {
            DapStructure type = this.factory.newStructure(name);
            DapVariable var = this.factory.newVariable(name, type);
            this.passReserved(node, var);
            this.scopestack.push(type);
            this.fillcontainer(node, type);
            this.scopestack.pop();
            this.scopestack.push(var);
            this.fillmetadata(node, var);
            this.scopestack.pop();
            return var;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapVariable parseseqvar(Node node) throws ParseException {
        String name;
        if (this.trace) {
            this.trace("seqvariable.enter");
        }
        if (this.isempty(name = this.pull(node, "name"))) {
            throw new ParseException("Seqvar: Empty variable name");
        }
        String typename = node.getNodeName();
        try {
            DapSequence type = this.factory.newSequence(name);
            DapVariable var = this.factory.newVariable(name, type);
            this.passReserved(node, var);
            this.scopestack.push(type);
            this.fillcontainer(node, type);
            this.scopestack.pop();
            this.scopestack.push(var);
            this.fillmetadata(node, var);
            this.scopestack.pop();
            return var;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void fillcontainer(Node node, DapStructure parent) throws ParseException {
        try {
            if (this.trace) {
                this.trace("fillcontainer.enter");
            }
            List<Node> nodes = this.getSubnodes(node);
            block7: for (int i = 0; i < nodes.size(); ++i) {
                Node n = nodes.get(i);
                DapSort sort = DOM4Parser.nodesort(n);
                switch (sort) {
                    case VARIABLE: {
                        this.recordfield(this.parseatomicvar(n), parent);
                        continue block7;
                    }
                    case STRUCTURE: {
                        DapVariable dv = this.parsestructvar(n);
                        this.recorddecl(dv.getBaseType(), this.getGroupScope());
                        dv.getBaseType().overrideParent(parent);
                        this.recordfield(dv, parent);
                        continue block7;
                    }
                    case SEQUENCE: {
                        DapVariable dv = this.parseseqvar(n);
                        this.recorddecl(dv.getBaseType(), this.getGroupScope());
                        this.recordfield(dv, parent);
                        continue block7;
                    }
                }
            }
            if (this.trace) {
                this.trace("fillcontainer.exit");
            }
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected void fillmetadata(Node node, DapVariable var) throws ParseException {
        try {
            if (this.trace) {
                this.trace("fillmetadata.enter");
            }
            List<Node> nodes = this.getSubnodes(node);
            block9: for (int i = 0; i < nodes.size(); ++i) {
                Node n = nodes.get(i);
                DapSort sort = DOM4Parser.nodesort(n);
                switch (sort) {
                    case DIMENSION: {
                        var.addDimension(this.parsedimref(n));
                        continue block9;
                    }
                    case MAP: {
                        var.addMap(this.parsemap(n));
                        continue block9;
                    }
                    case ATTRIBUTE: {
                        this.recordattr(this.parseattr(n), var);
                        continue block9;
                    }
                    case ATTRIBUTESET: {
                        this.recordattr(this.parseattrset(n), var);
                        continue block9;
                    }
                    case OTHERXML: {
                        this.recordattr(this.parseotherxml(n), var);
                        continue block9;
                    }
                }
            }
            if (this.trace) {
                this.trace("fillmetadata.exit");
            }
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapDimension parsedimref(Node node) throws ParseException {
        try {
            DapDimension dim;
            if (this.trace) {
                this.trace("dimref.enter");
            }
            String dimname = this.pull(node, "name");
            String size = this.pull(node, "size");
            if (dimname != null && size != null) {
                throw new ParseException("Dimref: both name and size specified");
            }
            if (dimname == null && size == null) {
                throw new ParseException("Dimref: no name or size specified");
            }
            if (dimname != null && this.isempty(dimname)) {
                throw new ParseException("Dimref: Empty dimension reference name");
            }
            if (size != null && this.isempty(size)) {
                throw new ParseException("Dimref: Empty dimension size");
            }
            if (dimname != null) {
                dim = (DapDimension)this.root.findByFQN(dimname, DapSort.DIMENSION);
            } else {
                long anonsize;
                size = size.trim();
                try {
                    anonsize = Long.parseLong(size.trim());
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException("Dimref: Illegal dimension size");
                }
                dim = this.root.createAnonymous(anonsize);
            }
            if (dim == null) {
                throw new ParseException("Unknown dimension: " + dimname);
            }
            return dim;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapMap parsemap(Node node) throws ParseException {
        DapNode scope;
        DapVariable target;
        String name;
        if (this.trace) {
            this.trace("map.enter");
        }
        if (this.isempty(name = this.pull(node, "name"))) {
            throw new ParseException("Mapref: Empty map name");
        }
        try {
            target = (DapVariable)this.root.findByFQN(name, DapSort.VARIABLE, DapSort.SEQUENCE, DapSort.STRUCTURE);
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if (target == null) {
            throw new ParseException("Mapref: undefined target variable: " + name);
        }
        DapNode container = target.getContainer();
        try {
            scope = this.getParentScope();
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
        if ((container.getSort() == DapSort.STRUCTURE || container.getSort() == DapSort.SEQUENCE) && container == scope) {
            throw new ParseException("Mapref: map target variable not in outer scope: " + name);
        }
        DapMap map = this.factory.newMap(target);
        if (this.trace) {
            this.trace("map.exit");
        }
        return map;
    }

    protected DapAttribute parseattr(Node node) throws ParseException {
        try {
            String name;
            if (this.trace) {
                this.trace("attribute.enter");
            }
            if (this.isempty(name = this.pull(node, "name"))) {
                throw new ParseException("Attribute: Empty attribute name");
            }
            String type = this.pull(node, "type");
            if (this.isempty(type)) {
                type = DEFAULTATTRTYPE;
            } else if ("Byte".equalsIgnoreCase(type)) {
                type = "UInt8";
            }
            DapType basetype = (DapType)this.root.lookup(type, DapSort.ENUMERATION, DapSort.ATOMICTYPE);
            if (basetype == null) {
                throw new ParseException("parseattr: Illegal type: " + type);
            }
            List<String> nslist = this.parsenamespaces(node);
            DapAttribute attr = this.makeAttribute(DapSort.ATTRIBUTE, name, basetype, nslist);
            this.scopestack.push(attr);
            ArrayList<String> values = new ArrayList<String>();
            String val = this.pull(node, "value");
            if (val != null) {
                values.add(val);
            } else if (node.hasChildNodes()) {
                List<Node> nodes = this.getSubnodes(node);
                for (int i = 0; i < nodes.size(); ++i) {
                    Node n = nodes.get(i);
                    String kind = n.getNodeName();
                    if (kind.equalsIgnoreCase("Value")) {
                        val = this.pull(n, "value");
                        if (val != null) {
                            values.add(val);
                            continue;
                        }
                        values.add(this.getNodeText(n));
                        continue;
                    }
                    throw new ParseException("Unexpected non-value element in attribute");
                }
            } else {
                values.add(this.cleanup(node.getTextContent()));
            }
            if (values.size() == 0) {
                throw new ParseException("Attribute: attribute has no values");
            }
            for (int i = 0; i < values.size(); ++i) {
                String s2 = (String)values.get(i);
                if (s2 == null) {
                    s2 = "";
                }
                String ds = Escape.backslashUnescape(s2);
                values.set(i, ds);
            }
            attr.setValues(values.toArray(new String[values.size()]));
            this.scopestack.pop();
            if (this.trace) {
                this.trace("attribute.exit");
            }
            return attr;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected DapAttributeSet parseattrset(Node node) throws ParseException {
        try {
            String name;
            if (this.trace) {
                this.trace("attrset.enter");
            }
            if (this.isempty(name = this.pull(node, "name"))) {
                throw new ParseException("AttributeSet: Empty attribute name");
            }
            List<String> nslist = this.parsenamespaces(node);
            DapAttributeSet attrset = (DapAttributeSet)this.makeAttribute(DapSort.ATTRIBUTESET, name, null, nslist);
            this.scopestack.push(attrset);
            List<Node> nodes = this.getSubnodes(node);
            block6: for (int i = 0; i < nodes.size(); ++i) {
                Node n = nodes.get(i);
                DapSort sort = DOM4Parser.nodesort(n);
                switch (sort) {
                    case ATTRIBUTE: {
                        this.recordattr(this.parseattr(n), attrset);
                        continue block6;
                    }
                    case ATTRIBUTESET: {
                        this.recordattr(this.parseattrset(n), attrset);
                        continue block6;
                    }
                    default: {
                        throw new ParseException("Unexpected attribute set element: " + n);
                    }
                }
            }
            this.scopestack.pop();
            if (this.trace) {
                this.trace("attributeset.exit");
            }
            return attrset;
        }
        catch (DapException e) {
            throw new ParseException(e);
        }
    }

    protected List<String> parsenamespaces(Node node) throws ParseException {
        ArrayList<String> nslist = new ArrayList<String>();
        List<Node> nodes = this.getSubnodes(node);
        for (int i = 0; i < nodes.size(); ++i) {
            Node n = nodes.get(i);
            if (!"namespace".equalsIgnoreCase(n.getNodeName())) continue;
            String ns = this.pull(n, "href");
            if (this.isempty(ns)) {
                throw new ParseException("Illegal null namespace href: " + node);
            }
            if (nslist.contains(ns)) continue;
            nslist.add(ns);
        }
        return nslist;
    }

    protected DapAttribute parseotherxml(Node node) throws ParseException {
        if (this.trace) {
            this.trace("otherxml.enter");
        }
        String name = this.pull(node, "name");
        DapOtherXML other = this.factory.newOtherXML(name);
        List<Node> nodes = this.getSubnodes(node);
        switch (nodes.size()) {
            case 0: {
                break;
            }
            case 1: {
                other.setRoot(nodes.get(0));
                break;
            }
            default: {
                throw new ParseException("OtherXML: multiple top level nodes not supported");
            }
        }
        if (this.trace) {
            this.trace("otherxml.exit");
        }
        return other;
    }

    protected void parseerror(Node node) throws ParseException {
        String xhttpcode;
        if (this.trace) {
            this.trace("error.enter");
        }
        String shttpcode = (xhttpcode = this.pull(node, "httpcode")) == null ? "400" : xhttpcode;
        int httpcode = 0;
        try {
            httpcode = Integer.parseInt(shttpcode);
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Error Response; illegal http code: " + shttpcode);
        }
        this.errorresponse = new ErrorResponse();
        this.errorresponse.setCode(httpcode);
        if (this.trace) {
            this.trace("error.exit");
        }
    }

    protected void errormessage(String value) throws ParseException {
        if (this.trace) {
            this.trace("errormessage.enter");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String message = value;
        message = Escape.entityUnescape(message);
        this.errorresponse.setMessage(message);
        if (this.trace) {
            this.trace("errormessage.exit");
        }
    }

    protected void errorcontext(String value) throws ParseException {
        if (this.trace) {
            this.trace("errorcontext.enter");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String context = value;
        context = Escape.entityUnescape(context);
        this.errorresponse.setContext(context);
        if (this.trace) {
            this.trace("errorcontext.exit");
        }
    }

    protected void errorotherinfo(String value) throws ParseException {
        if (this.trace) {
            this.trace("errorotherinfo.enter");
        }
        assert (this.errorresponse != null) : "Internal Error";
        String other = value;
        other = Escape.entityUnescape(other);
        this.errorresponse.setOtherInfo(other);
        if (this.trace) {
            this.trace("errorotherinfo.exit");
        }
    }

    protected void passReserved(Node node, DapNode dap) throws ParseException {
        try {
            NamedNodeMap attrs = node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node n = attrs.item(i);
                String key = n.getNodeName();
                String value = n.getNodeValue();
                if (!DOM4Parser.isReserved(key)) continue;
                dap.addXMLAttribute(key, value);
            }
        }
        catch (DapException de) {
            throw new ParseException(de);
        }
    }

    static boolean isReserved(String name) {
        for (String tag : RESERVEDTAGS) {
            if (!name.startsWith(tag)) continue;
            return true;
        }
        return false;
    }

    static {
        sortmap.put("attribute", DapSort.ATTRIBUTE);
        sortmap.put("dataset", DapSort.DATASET);
        sortmap.put("dim", DapSort.DIMENSION);
        sortmap.put("dimension", DapSort.DIMENSION);
        sortmap.put("enumeration", DapSort.ENUMERATION);
        sortmap.put("enumconst", DapSort.ENUMCONST);
        sortmap.put("group", DapSort.GROUP);
        sortmap.put("map", DapSort.MAP);
        sortmap.put("otherxml", DapSort.OTHERXML);
        sortmap.put("sequence", DapSort.SEQUENCE);
        sortmap.put("structure", DapSort.STRUCTURE);
        sortmap.put("char", DapSort.VARIABLE);
        sortmap.put("int8", DapSort.VARIABLE);
        sortmap.put("uint8", DapSort.VARIABLE);
        sortmap.put("int16", DapSort.VARIABLE);
        sortmap.put("uint16", DapSort.VARIABLE);
        sortmap.put("int32", DapSort.VARIABLE);
        sortmap.put("uint32", DapSort.VARIABLE);
        sortmap.put("int64", DapSort.VARIABLE);
        sortmap.put("uint64", DapSort.VARIABLE);
        sortmap.put("float32", DapSort.VARIABLE);
        sortmap.put("float64", DapSort.VARIABLE);
        sortmap.put("string", DapSort.VARIABLE);
        sortmap.put("url", DapSort.VARIABLE);
        sortmap.put("opaque", DapSort.VARIABLE);
        sortmap.put("enum", DapSort.VARIABLE);
        typemap = new HashMap<String, TypeSort>();
        typemap.put("char", TypeSort.Char);
        typemap.put("int8", TypeSort.Int8);
        typemap.put("uint8", TypeSort.UInt8);
        typemap.put("int16", TypeSort.Int16);
        typemap.put("uint16", TypeSort.UInt16);
        typemap.put("int32", TypeSort.Int32);
        typemap.put("uint32", TypeSort.UInt32);
        typemap.put("int64", TypeSort.Int64);
        typemap.put("uint64", TypeSort.UInt64);
        typemap.put("float32", TypeSort.Float32);
        typemap.put("float64", TypeSort.Float64);
        typemap.put("string", TypeSort.String);
        typemap.put("url", TypeSort.URL);
        typemap.put("opaque", TypeSort.Opaque);
        typemap.put("enum", TypeSort.Enum);
        typemap.put("structure", TypeSort.Structure);
        typemap.put("sequence", TypeSort.Sequence);
        globaldebuglevel = 0;
        debugstream = System.err;
    }
}

