/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser.bison;

import dap4.core.dmr.parser.bison.SaxEvent;
import dap4.core.dmr.parser.bison.SaxEventType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SaxEventHandler
extends DefaultHandler {
    static boolean TRACE = false;
    static Charset UTF8 = Charset.forName("UTF-8");
    static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected String document = null;
    protected Locator locator = null;
    protected SAXParserFactory spf = null;
    protected SAXParser saxparser = null;
    protected ByteArrayInputStream input = null;

    public abstract void yyevent(SaxEvent var1) throws SAXException;

    public Locator getLocator() {
        return this.locator;
    }

    public boolean parse(String document) throws SAXException {
        StringBuilder doc = new StringBuilder(document.trim());
        int index = doc.indexOf("<?xml");
        if (index == 0) {
            index = doc.indexOf("?>");
            if (index < 0) {
                throw new SAXException("Document has malformed <?xml...?> prefix");
            }
            doc.delete(0, index + 2);
            while (doc.length() > 0 && "\r\n".indexOf(doc.charAt(0)) >= 0) {
                doc.deleteCharAt(0);
            }
            document = doc.toString();
        }
        this.document = document;
        try {
            this.spf = SAXParserFactory.newInstance();
            this.spf.setValidating(false);
            this.spf.setNamespaceAware(true);
            this.spf.setFeature(LOAD_EXTERNAL_DTD, false);
            this.saxparser = this.spf.newSAXParser();
            this.input = new ByteArrayInputStream(document.getBytes(UTF8));
            this.saxparser.parse((InputStream)this.input, (DefaultHandler)this);
            return true;
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.STARTDOCUMENT, this.locator);
        if (TRACE) {
            this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
        }
        this.locatedEvent(token);
    }

    @Override
    public void endDocument() throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.ENDDOCUMENT, this.locator);
        if (TRACE) {
            this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
        }
        this.locatedEvent(token);
    }

    @Override
    public void startElement(String nsuri, String name, String qualname, Attributes attributes) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.STARTELEMENT, this.locator, name, qualname, nsuri);
        if (TRACE) {
            this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
        }
        this.locatedEvent(token);
        int nattr = attributes.getLength();
        for (int i = 0; i < nattr; ++i) {
            String aname = attributes.getLocalName(i);
            if ("".equals(aname)) {
                aname = attributes.getQName(i);
            }
            String value = attributes.getValue(i);
            token = new SaxEvent(SaxEventType.ATTRIBUTE, this.locator, aname);
            token.value = value;
            if (TRACE) {
                this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
            }
            this.locatedEvent(token);
        }
    }

    @Override
    public void endElement(String nsuri, String name, String qualname) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.ENDELEMENT, this.locator, name, qualname, nsuri);
        if (TRACE) {
            this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
        }
        this.locatedEvent(token);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        SaxEvent token = new SaxEvent(SaxEventType.CHARACTERS, this.locator);
        token.text = new String(ch, start, length);
        if (TRACE) {
            this.trace("eventtype.%s: %s%n", token.eventtype.name(), token.toString());
        }
        this.locatedEvent(token);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (TRACE) {
            this.trace("eventtype.RESOLVEENTITY: %s.%s%n", publicId, systemId);
        }
        return null;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXParseException(String.format("Sax fatal error: %s; %s%n", e, this.report(this.locator)), this.locator);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        System.err.printf("Sax error: %s; %s%n", e, this.report(this.locator));
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        System.err.printf("Sax warning: %s; %s%n", e, this.report(this.locator));
    }

    protected String report(Locator locator) {
        String msg;
        int lineno = locator.getLineNumber();
        int colno = locator.getColumnNumber();
        String text = this.document;
        String[] lines = text.split("[\n]");
        for (int i = lines.length; i <= lineno + 1; ++i) {
            text = text + " \n";
        }
        lines = text.split("[\n]");
        try {
            msg = lines[lineno];
            while (msg.length() <= colno) {
                msg = msg + ' ';
            }
            msg = msg.substring(0, colno) + '^' + msg.substring(colno, msg.length());
            msg = locator.toString() + '|' + msg + '|';
        }
        catch (ArrayIndexOutOfBoundsException t) {
            msg = locator.toString();
        }
        return msg;
    }

    protected void locatedEvent(SaxEvent token) throws SAXException {
        try {
            this.yyevent(token);
        }
        catch (SAXException se) {
            throw new SAXException(this.locatedError(se.getMessage()));
        }
    }

    protected String locatedError(String msg) {
        String locmsg = msg + String.format("; near %d::%d%n", this.locator.getLineNumber(), this.locator.getColumnNumber());
        return locmsg;
    }

    protected void trace(String msg, Object ... args) {
        if (TRACE) {
            System.err.printf(this.locatedError(String.format(msg, args)), new Object[0]);
        }
    }
}

