/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import com.sun.jna.Native;
import dap4.dap4lib.DapLog;
import dap4.dap4lib.DapStartLog;
import dap4.dap4lib.netcdf.DapNc4Wrapper;
import dap4.dap4lib.netcdf.DapNetcdf;
import java.io.IOException;

public abstract class NetcdfLoader {
    public static final boolean DEBUG = false;
    public static final String DFLAG_JNAPATH = "jna.library.path";
    public static final String DFLAG_LOG_LEVEL = "jna.library.loglevel";
    public static final String ENV_JNAPATH = "JNA_PATH";
    static String DFALT_NETCDF4LIBNAME = "netcdf";
    public static final int DEFAULT_LOG_LEVEL = 0;
    protected static DapNetcdf nc4 = null;
    protected static String jnaPath = null;
    protected static String libName = DFALT_NETCDF4LIBNAME;
    static int log_level = 0;

    public static synchronized void setLibraryAndPath(String jna_path, String lib_name) {
        if ((lib_name = NetcdfLoader.nullify(lib_name)) == null) {
            lib_name = DFALT_NETCDF4LIBNAME;
        }
        if ((jna_path = NetcdfLoader.nullify(jna_path)) == null) {
            jna_path = NetcdfLoader.nullify(System.getProperty(DFLAG_JNAPATH));
        }
        if (jna_path == null && (jna_path = NetcdfLoader.nullify(System.getenv(ENV_JNAPATH))) != null) {
            System.setProperty(DFLAG_JNAPATH, jna_path);
        }
        if (jna_path == null) {
            DapLog.warn(String.format("Neither -D%s nor getenv(%s) is defined", DFLAG_JNAPATH, ENV_JNAPATH));
        }
        libName = lib_name;
        jnaPath = jna_path;
    }

    public static synchronized DapNetcdf load() throws IOException {
        if (nc4 == null) {
            if (jnaPath == null) {
                NetcdfLoader.setLibraryAndPath(null, null);
            }
            try {
                nc4 = (DapNetcdf)Native.loadLibrary(libName, DapNetcdf.class);
                nc4 = new DapNc4Wrapper(nc4);
                String message = String.format("NetCDF-4 C library loaded (jna_path='%s', libname='%s').", jnaPath, libName);
                String vermsg = String.format("Netcdf nc_inq_libvers='%s' isProtected=%s%n", nc4.nc_inq_libvers(), Native.isProtected());
                DapStartLog.info(message);
                DapStartLog.info(vermsg);
                DapStartLog.info(String.format("Nc4Iosp: NetCDF-4 C library loaded (jna_path='%s', libname='%s').", jnaPath, libName));
                DapStartLog.debug(String.format("Netcdf nc_inq_libvers='%s' isProtected=%s", nc4.nc_inq_libvers(), Native.isProtected()));
            }
            catch (Throwable t) {
                String message = String.format("NetCDF-4 C library not present (jna_path='%s', libname='%s'); %s.", jnaPath, libName, t.getMessage());
                DapLog.info(message);
                DapLog.info(t.getMessage());
                nc4 = null;
                throw new IOException(message);
            }
            assert (nc4 != null);
            String slevel = NetcdfLoader.nullify(System.getProperty(DFLAG_LOG_LEVEL));
            if (slevel != null) {
                try {
                    int newlevel;
                    log_level = newlevel = Integer.parseInt(slevel);
                }
                catch (NumberFormatException newlevel) {
                    // empty catch block
                }
            }
            try {
                NetcdfLoader.setLogLevel(log_level);
            }
            catch (Throwable t) {
                String message = String.format("NetcdfLoader: could not set log level (level=%d jna_path='%s', libname='%s').", log_level, jnaPath, libName);
                DapLog.warn("NetcdfLoader: " + t.getMessage());
                DapLog.warn(message);
            }
        }
        return nc4;
    }

    public static synchronized boolean isClibraryPresent() {
        return nc4 != null;
    }

    public static synchronized int setLogLevel(int level) {
        int oldlevel = -1;
        log_level = level;
        if (nc4 != null) {
            try {
                oldlevel = nc4.nc_set_log_level(log_level);
                DapLog.info(String.format("NetcdfLoader: set log level: old=%d new=%d", oldlevel, log_level));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return oldlevel;
    }

    protected static String nullify(String s2) {
        if (s2 != null && s2.length() == 0) {
            s2 = null;
        }
        return s2;
    }
}

