/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.ChunkInputStream;
import dap4.dap4lib.RequestMode;
import dap4.dap4lib.XURI;
import dap4.dap4lib.serial.D4DSP;
import dap4.servlet.ChunkWriter;
import dap4.servlet.Generator;
import dap4.servlet.Value;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteOrder;

public class SynDSP
extends D4DSP {
    protected static final boolean DEBUG = false;
    protected static final String[] SYNEXTENSIONS = new String[]{".dmr", ".syn"};
    protected byte[] raw = null;

    @Override
    public boolean dspMatch(String path, DapContext context) {
        for (String ext : SYNEXTENSIONS) {
            if (!path.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
    }

    @Override
    public SynDSP open(String filepath) throws DapException {
        String document;
        assert (this.context != null);
        if (filepath.startsWith("file:")) {
            try {
                XURI xuri = new XURI(filepath);
                filepath = xuri.getPath();
            }
            catch (URISyntaxException use) {
                throw new DapException("Malformed filepath: " + filepath).setCode(404);
            }
        }
        this.setLocation(filepath);
        try (FileInputStream stream = new FileInputStream(filepath);){
            document = DapUtil.readtextfile(stream);
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
        this.dmr = this.parseDMR(document);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ChunkWriter cw = new ChunkWriter(bos, RequestMode.DAP, ByteOrder.nativeOrder());
            Generator generator = new Generator(this.dmr, Value.ValueSource.RANDOM);
            generator.generate(null, cw, true, this.getChecksumMode());
            cw.close();
            bos.close();
            byte[] raw = bos.toByteArray();
            ByteArrayInputStream bis = new ByteArrayInputStream(raw);
            ChunkInputStream crdr = new ChunkInputStream(bis, RequestMode.DAP, this.getOrder());
            crdr.readDMR();
            this.raw = DapUtil.readbinaryfile(crdr);
            super.build(this.dmr, this.raw, this.getOrder());
            return this;
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }
}

