/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapType;
import dap4.core.dmr.TypeSort;
import dap4.core.util.ConversionException;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.List;

public class DapEnumeration
extends DapType {
    public static final DapType DEFAULTBASETYPE = DapType.INT32;
    protected DapType basetype = DEFAULTBASETYPE;
    protected List<DapEnumConst> constants = new ArrayList<DapEnumConst>();

    public DapEnumeration(String name) {
        super(name, TypeSort.Enum);
    }

    public DapEnumeration(String name, DapType basetype) {
        this(name);
        this.setBaseType(basetype);
    }

    public DapNode findByName(String name) {
        DapEnumConst dec = this.lookup(name);
        return dec;
    }

    public DapType getBaseType() {
        return this.basetype;
    }

    public void setBaseType(DapType basetype) {
        if (!basetype.isIntegerType()) {
            throw new IllegalArgumentException("DapEnumeration: illegal base type: " + basetype);
        }
        this.basetype = basetype;
    }

    public void setEnumConsts(List<DapEnumConst> econsts) throws DapException {
        for (DapEnumConst dec : econsts) {
            this.addEnumConst(dec);
        }
    }

    public void addEnumConst(DapEnumConst dec) throws DapException {
        DapEnumConst nold = this.lookup(dec.getShortName());
        DapEnumConst vold = this.lookup(dec.getValue());
        if (nold != null) {
            throw new DapException("DapEnumeration: Duplicate enum constant name: " + dec.getShortName());
        }
        if (vold != null) {
            throw new DapException("DapEnumeration: Duplicate enum constant value: " + dec.getValue());
        }
        dec.setParent(this);
        this.constants.add(dec);
    }

    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (DapEnumConst dec : this.constants) {
            names.add(dec.getShortName());
        }
        return names;
    }

    public DapEnumConst lookup(String name) {
        for (DapEnumConst dec : this.constants) {
            if (!dec.getShortName().equals(name)) continue;
            return dec;
        }
        return null;
    }

    public DapEnumConst lookup(long value) {
        for (DapEnumConst dec : this.constants) {
            if (dec.getValue() != value) continue;
            return dec;
        }
        return null;
    }

    public String[] convert(String[] vec) throws ConversionException {
        int count = vec.length;
        long[] lvalues = new long[count];
        for (int i = 0; i < count; ++i) {
            try {
                lvalues[i] = Long.parseLong(vec[i]);
                if (this.lookup(lvalues[i]) != null) continue;
                throw new ConversionException("Illegal Enum constant: " + vec[i]);
            }
            catch (NumberFormatException nfe) {
                DapEnumConst dec = this.lookup(vec[i]);
                if (dec == null) {
                    throw new ConversionException("Illegal Enum constant: " + vec[i]);
                }
                lvalues[i] = dec.getValue();
            }
        }
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = this.lookup(lvalues[i]).getShortName();
        }
        return names;
    }

    public String[] convert(long[] lvalues) throws ConversionException {
        int count = lvalues.length;
        String[] svalues = new String[count];
        for (int i = 0; i < count; ++i) {
            DapEnumConst dec = this.lookup(lvalues[i]);
            if (dec == null) {
                throw new ConversionException("Illegal Enum constant: " + lvalues[i]);
            }
            svalues[i] = dec.getShortName();
        }
        return svalues;
    }
}

