/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web;

import javax.servlet.ServletContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.AbstractLookup;
import org.apache.logging.log4j.util.Strings;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

@Plugin(name="web", category="Lookup")
public class WebLookup
extends AbstractLookup {
    private static final String ATTR_PREFIX = "attr.";
    private static final String INIT_PARAM_PREFIX = "initParam.";

    @Override
    public String lookup(LogEvent event, String key) {
        ServletContext ctx = WebLoggerContextUtils.getServletContext();
        if (ctx == null) {
            return null;
        }
        if (key.startsWith(ATTR_PREFIX)) {
            String attrName = key.substring(ATTR_PREFIX.length());
            Object attrValue = ctx.getAttribute(attrName);
            return attrValue == null ? null : attrValue.toString();
        }
        if (key.startsWith(INIT_PARAM_PREFIX)) {
            String paramName = key.substring(INIT_PARAM_PREFIX.length());
            return ctx.getInitParameter(paramName);
        }
        if ("rootDir".equals(key)) {
            String root = ctx.getRealPath("/");
            if (root == null) {
                String msg = "Failed to resolve web:rootDir -- servlet container unable to translate virtual path  to real path (probably not deployed as exploded";
                throw new IllegalStateException("Failed to resolve web:rootDir -- servlet container unable to translate virtual path  to real path (probably not deployed as exploded");
            }
            return root;
        }
        if ("contextPath".equals(key)) {
            return ctx.getContextPath();
        }
        if ("servletContextName".equals(key)) {
            return ctx.getServletContextName();
        }
        if ("serverInfo".equals(key)) {
            return ctx.getServerInfo();
        }
        if ("effectiveMajorVersion".equals(key)) {
            return String.valueOf(ctx.getEffectiveMajorVersion());
        }
        if ("effectiveMinorVersion".equals(key)) {
            return String.valueOf(ctx.getEffectiveMinorVersion());
        }
        if ("majorVersion".equals(key)) {
            return String.valueOf(ctx.getMajorVersion());
        }
        if ("minorVersion".equals(key)) {
            return String.valueOf(ctx.getMinorVersion());
        }
        if (ctx.getAttribute(key) != null) {
            return ctx.getAttribute(key).toString();
        }
        if (ctx.getInitParameter(key) != null) {
            return ctx.getInitParameter(key);
        }
        ctx.log(this.getClass().getName() + " unable to resolve key " + Strings.quote(key));
        return null;
    }
}

