/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.time.CalendarDateUnit;

public class StandardStationCollectionImpl
extends StationTimeSeriesCollectionImpl {
    private NestedTable ft;

    StandardStationCollectionImpl(NestedTable ft, CalendarDateUnit timeUnit, String altUnits) throws IOException {
        super(ft.getName(), timeUnit, altUnits);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    public StationTimeSeriesFeature makeStation(StructureData stationData, int recnum) {
        StationFeature s2 = this.ft.makeStation(stationData);
        if (s2 == null) {
            return null;
        }
        return new StandardStationFeatureImpl(s2, this.timeUnit, stationData, recnum);
    }

    @Override
    protected StationHelper createStationHelper() throws IOException {
        StationHelper stationHelper = new StationHelper();
        try (StructureDataIterator siter = this.ft.getStationDataIterator();){
            while (siter.hasNext()) {
                StructureData stationData = siter.next();
                StationTimeSeriesFeature stfs = this.makeStation(stationData, siter.getCurrentRecno());
                if (stfs == null) continue;
                stationHelper.addStation(stfs);
            }
        }
        return stationHelper;
    }

    private class StandardStationFeatureImpl
    extends StationTimeSeriesFeatureImpl {
        int recnum;
        StructureData stationData;

        StandardStationFeatureImpl(StationFeature s2, CalendarDateUnit dateUnit, StructureData stationData, int recnum) {
            super(s2, dateUnit, StandardStationCollectionImpl.this.getAltUnits(), -1);
            this.recnum = recnum;
            this.stationData = stationData;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            Cursor cursor = new Cursor(StandardStationCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[1] = this.recnum;
            cursor.tableData[1] = this.stationData;
            cursor.currentIndex = 1;
            StandardStationCollectionImpl.this.ft.addParentJoin(cursor);
            StructureDataIterator obsIter = StandardStationCollectionImpl.this.ft.getLeafFeatureDataIterator(cursor);
            return new StandardPointFeatureIterator(this, StandardStationCollectionImpl.this.ft, this.timeUnit, obsIter, cursor);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.stationData;
        }
    }
}

