/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Iterator;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.NestedCollectionIteratorAdapter;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.SectionCollectionImpl;
import ucar.nc2.ft.point.SectionFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;

public class StandardSectionCollectionImpl
extends SectionCollectionImpl {
    private NestedTable ft;

    StandardSectionCollectionImpl(NestedTable ft, CalendarDateUnit timeUnit, String altUnits) throws IOException {
        super(ft.getName(), timeUnit, altUnits);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public Iterator<TrajectoryProfileFeature> iterator() {
        try {
            PointFeatureCCIterator pfIterator = this.getNestedPointFeatureCollectionIterator();
            return new NestedCollectionIteratorAdapter<TrajectoryProfileFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IOIterator<PointFeatureCC> getCollectionIterator() throws IOException {
        return new SectionIterator();
    }

    @Override
    public PointFeatureCCIterator getNestedPointFeatureCollectionIterator() throws IOException {
        return new SectionIterator();
    }

    private class StandardSectionProfileFeature
    extends ProfileFeatureImpl {
        Cursor cursor;
        StructureData profileData;

        StandardSectionProfileFeature(Cursor cursor, double time, StructureData profileData) {
            super(StandardSectionCollectionImpl.this.ft.getFeatureName(cursor), StandardSectionCollectionImpl.this.getTimeUnit(), StandardSectionCollectionImpl.this.getAltUnits(), StandardSectionCollectionImpl.this.ft.getLatitude(cursor), StandardSectionCollectionImpl.this.ft.getLongitude(cursor), time, -1);
            this.cursor = cursor;
            this.profileData = profileData;
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator();
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        this.name = this.timeUnit.makeCalendarDate(this.time).toString();
                    } else {
                        this.name = "empty";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardSectionCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter);
            return new PointIterator(StandardSectionCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
        }

        @Override
        @Nonnull
        public CalendarDate getTime() {
            return this.timeUnit.makeCalendarDate(this.time);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.profileData;
        }

        private class PointIterator
        extends StandardPointFeatureIterator {
            PointIterator(NestedTable ft, CalendarDateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) throws IOException {
                super(StandardSectionProfileFeature.this, ft, timeUnit, structIter, cursor);
            }

            @Override
            protected boolean isMissing() throws IOException {
                if (super.isMissing()) {
                    return true;
                }
                return this.ft.isAltMissing(this.cursor);
            }
        }
    }

    private class ProfileIterator
    implements PointFeatureCollectionIterator,
    IOIterator<PointFeatureCollection> {
        Cursor cursor;
        private StructureDataIterator sdataIter;
        StructureData profileData;
        DsgCollectionImpl prev;
        CollectionInfo calcInfo;

        ProfileIterator(Cursor cursor) throws IOException {
            this.cursor = cursor;
            this.sdataIter = StandardSectionCollectionImpl.this.ft.getMiddleFeatureDataIterator(cursor);
            CollectionInfo info = StandardSectionCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            boolean more;
            if (this.prev != null && this.calcInfo != null) {
                this.calcInfo.extend(this.prev.getInfo());
            }
            if (!(more = this.sdataIter.hasNext())) {
                this.sdataIter.close();
                if (this.calcInfo != null) {
                    this.calcInfo.setComplete();
                }
            }
            return more;
        }

        @Override
        public PointFeatureCollection next() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            cursorIter.tableData[1] = this.profileData = this.sdataIter.next();
            cursorIter.recnum[1] = this.sdataIter.getCurrentRecno();
            cursorIter.currentIndex = 1;
            StandardSectionCollectionImpl.this.ft.addParentJoin(cursorIter);
            StandardSectionProfileFeature result = new StandardSectionProfileFeature(cursorIter, StandardSectionCollectionImpl.this.ft.getObsTime(this.cursor), this.profileData);
            this.prev = result;
            return result;
        }

        @Override
        public void close() {
            this.sdataIter.close();
        }
    }

    private class StandardSectionFeature
    extends SectionFeatureImpl {
        Cursor cursor;
        StructureData sectionData;

        StandardSectionFeature(Cursor cursor, StructureData sectionData) {
            super(StandardSectionCollectionImpl.this.ft.getFeatureName(cursor), StandardSectionCollectionImpl.this.getTimeUnit(), StandardSectionCollectionImpl.this.getAltUnits());
            this.cursor = cursor;
            this.sectionData = sectionData;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new ProfileIterator(this.cursor.copy());
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.sectionData;
        }

        @Override
        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return new ProfileIterator(this.cursor.copy());
        }
    }

    private class SectionIterator
    implements PointFeatureCCIterator,
    IOIterator<PointFeatureCC> {
        private StructureDataIterator sdataIter;
        private StructureData sectionData;
        DsgCollectionImpl prev;
        CollectionInfo calcInfo;

        SectionIterator() throws IOException {
            this.sdataIter = StandardSectionCollectionImpl.this.ft.getRootFeatureDataIterator();
            this.sdataIter = StandardSectionCollectionImpl.this.ft.getRootFeatureDataIterator();
            CollectionInfo info = StandardSectionCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            do {
                if (this.prev != null && this.calcInfo != null) {
                    this.calcInfo.extend(this.prev.getInfo());
                }
                if (!this.sdataIter.hasNext()) {
                    this.close();
                    if (this.calcInfo != null) {
                        this.calcInfo.setComplete();
                    }
                    return false;
                }
                this.sectionData = this.sdataIter.next();
            } while (StandardSectionCollectionImpl.this.ft.isFeatureMissing(this.sectionData));
            return true;
        }

        @Override
        public TrajectoryProfileFeature next() throws IOException {
            Cursor cursor = new Cursor(StandardSectionCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[2] = this.sdataIter.getCurrentRecno();
            cursor.tableData[2] = this.sectionData;
            cursor.currentIndex = 2;
            StandardSectionCollectionImpl.this.ft.addParentJoin(cursor);
            StandardSectionFeature result = new StandardSectionFeature(cursor, this.sectionData);
            this.prev = result;
            return result;
        }

        @Override
        public void close() {
            this.sdataIter.close();
        }
    }
}

