/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.List;

public class DapStructure
extends DapType {
    List<DapVariable> fields = new ArrayList<DapVariable>();

    public DapStructure(String name) {
        super(name, TypeSort.Structure);
    }

    public DapVariable findByName(String shortname) {
        for (DapVariable field : this.fields) {
            if (!shortname.equals(field.getShortName())) continue;
            return field;
        }
        return null;
    }

    public int indexByName(String shortname) {
        for (int i = 0; i < this.fields.size(); ++i) {
            DapVariable field = this.fields.get(i);
            if (!shortname.equals(field.getShortName())) continue;
            return i;
        }
        return -1;
    }

    public int indexByField(DapVariable target) {
        for (int i = 0; i < this.fields.size(); ++i) {
            DapVariable field = this.fields.get(i);
            if (field != target) continue;
            return i;
        }
        return -1;
    }

    public DapVariable getField(int i) {
        return this.fields.get(i);
    }

    public List<DapVariable> getFields() {
        return this.fields;
    }

    public boolean isLeaf() {
        return false;
    }

    public void addField(DapVariable newfield) throws DapException {
        DapStructure ds = this;
        for (DapVariable v : ds.fields) {
            if (!v.getShortName().equals(newfield.getShortName())) continue;
            throw new DapException("DapStructure: attempt to add duplicate field: " + newfield.getShortName());
        }
        ds.fields.add(newfield);
    }
}

