/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.util.DapException;
import dap4.core.util.Escape;

public class ErrorResponse {
    int code = 0;
    String message = null;
    String context = null;
    String otherinfo = null;

    public ErrorResponse() {
    }

    public ErrorResponse(int httpcode, String message, String context, String other) {
        this.setCode(this.code);
        this.setMessage(message);
        this.setContext(context);
        this.setOtherInfo(other);
    }

    public int getCode() {
        return this.code;
    }

    public String getRawMessage() {
        return this.message;
    }

    public String getMessage() {
        return this.message == null ? null : Escape.entityEscape(this.message, null);
    }

    public String getRawContext() {
        return this.context;
    }

    public String getContext() {
        return this.context == null ? null : Escape.entityEscape(this.context, null);
    }

    public String getRawOtherInfo() {
        return this.otherinfo;
    }

    public String getOtherInfo() {
        return this.otherinfo == null ? null : Escape.entityEscape(this.otherinfo, null);
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setOtherInfo(String other) {
        this.otherinfo = other;
    }

    public String buildXML() {
        StringBuilder response = new StringBuilder();
        response.append("<Error");
        if (this.code > 0) {
            response.append(String.format(" httpcode=\"%d\"", this.code));
        }
        response.append(">\n");
        if (this.message != null) {
            response.append("<Message>" + this.getMessage() + "</Message>\n");
        }
        if (this.context != null) {
            response.append("<Context>" + this.getContext() + "</Context>\n");
        }
        if (this.otherinfo != null) {
            response.append("<OtherInformation>" + this.getOtherInfo() + "</OtherInformation>\n");
        }
        return response.toString();
    }

    public DapException buildException() {
        String XML2 = this.buildXML();
        DapException dapex = new DapException(XML2).setCode(this.code);
        return dapex;
    }
}

