/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;

public abstract class DapDump {
    static int MAXLIMIT = 20000;

    public static void dumpbytes(ByteBuffer buf0, boolean skipdmr) {
        int savepos = buf0.position();
        int limit0 = buf0.limit();
        int skipcount = 0;
        if (limit0 > MAXLIMIT) {
            limit0 = MAXLIMIT;
        }
        if (limit0 >= buf0.limit()) {
            limit0 = buf0.limit();
        }
        if (skipdmr) {
            ByteOrder saveorder = buf0.order();
            buf0.order(ByteOrder.BIG_ENDIAN);
            skipcount = buf0.getInt();
            buf0.order(saveorder);
            skipcount &= 0xFFFFFF;
            skipcount += 4;
        }
        byte[] bytes = new byte[limit0 + 8 - skipcount];
        Arrays.fill(bytes, (byte)0);
        buf0.position(savepos + skipcount);
        buf0.get(bytes, 0, limit0 - skipcount);
        buf0.position(savepos);
        System.err.println("order=" + buf0.order());
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(buf0.order());
        DapDump.dumpbytes(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpbytes(ByteBuffer buf0) {
        int stop = buf0.limit();
        int size = stop + 8;
        int savepos = buf0.position();
        assert (savepos == 0);
        byte[] bytes = new byte[size];
        Arrays.fill(bytes, (byte)0);
        buf0.get(bytes, 0, stop);
        buf0.position(savepos);
        ByteBuffer buf = ByteBuffer.wrap(bytes).order(buf0.order());
        buf.position(0);
        buf.limit(size);
        int i = 0;
        try {
            i = 0;
            while (buf.position() < stop) {
                savepos = buf.position();
                int iv = buf.getInt();
                buf.position(savepos);
                long lv = buf.getLong();
                buf.position(savepos);
                short sv = buf.getShort();
                buf.position(savepos);
                byte b = buf.get();
                int ub = b & 0xFF;
                long uiv = (long)iv & 0xFFFFFFFFL;
                int usv = sv & 0xFFFF;
                byte ib = b;
                char c = (char)ub;
                String s2 = Character.toString(c);
                if (c == '\r') {
                    s2 = "\\r";
                } else if (c == '\n') {
                    s2 = "\\n";
                } else if (c < ' ' || c >= '\u007f') {
                    s2 = "?";
                }
                System.err.printf("[%03d] %02x %03d %4d '%s'", i, ub, ub, (int)ib, s2);
                System.err.printf("\t%12d 0x%08x", iv, uiv);
                System.err.printf("\t%5d\t0x%04x", sv, usv);
                System.err.println();
                System.err.flush();
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println("failure:" + e);
        }
        finally {
            System.err.flush();
            System.err.flush();
        }
    }

    public static void dumpbytestream(OutputStream stream, ByteOrder order, String tag) {
        if (stream instanceof ByteArrayOutputStream) {
            byte[] content = ((ByteArrayOutputStream)stream).toByteArray();
            DapDump.dumpbytestream(content, order, tag);
        }
    }

    public static void dumpbytestream(ByteBuffer buf, ByteOrder order, String tag) {
        DapDump.dumpbytestream(buf.array(), 0, buf.position(), order, tag);
    }

    public static void dumpbytestream(byte[] content, ByteOrder order, String tag) {
        DapDump.dumpbytestream(content, 0, content.length, order, tag);
    }

    public static void dumpbytestream(byte[] content, int start, int len, ByteOrder order, String tag) {
        System.err.println("++++++++++ " + tag + " ++++++++++ ");
        ByteBuffer tmp = ByteBuffer.wrap(content).order(order);
        tmp.position(start);
        tmp.limit(len);
        DapDump.dumpbytes(tmp);
        System.err.println("++++++++++ " + tag + " ++++++++++ ");
        System.err.flush();
    }
}

