/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.serial;

import dap4.core.data.ChecksumMode;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.dap4lib.LibTypeFcns;
import dap4.dap4lib.serial.D4Cursor;
import dap4.dap4lib.serial.D4DSP;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class D4DataCompiler {
    public static boolean DEBUG = false;
    public static final int COUNTSIZE = 8;
    static String LBRACE = "{";
    static String RBRACE = "}";
    protected DapDataset dataset = null;
    protected ByteBuffer databuffer;
    protected ChecksumMode checksummode = null;
    protected ByteOrder order = null;
    protected D4DSP dsp;

    public D4DataCompiler(D4DSP dsp, ChecksumMode checksummode, ByteOrder order, ByteBuffer databuffer) throws DapException {
        this.dsp = dsp;
        this.dataset = this.dsp.getDMR();
        this.databuffer = databuffer;
        this.checksummode = checksummode;
        this.order = order;
    }

    public void compile() throws DapException {
        assert (this.dataset != null && this.databuffer != null);
        for (DapVariable vv : this.dataset.getTopVariables()) {
            D4Cursor data = this.compileVar(vv, null);
            this.dsp.addVariableData(vv, data);
        }
    }

    protected D4Cursor compileVar(DapVariable dapvar, D4Cursor container) throws DapException {
        boolean isscalar = dapvar.getRank() == 0;
        D4Cursor array = null;
        DapType type = dapvar.getBaseType();
        if (type.isAtomic()) {
            array = this.compileAtomicVar(dapvar, container);
        } else if (type.isStructType()) {
            array = this.compileStructureArray(dapvar, container);
        } else if (type.isSeqType()) {
            array = this.compileSequenceArray(dapvar, container);
        }
        if (dapvar.isTopLevel() && this.checksummode.enabled(ChecksumMode.DAP)) {
            int checksum = this.extractChecksum(this.databuffer);
            dapvar.setChecksum(checksum);
        }
        return array;
    }

    protected D4Cursor compileAtomicVar(DapVariable var, D4Cursor container) throws DapException {
        DapType daptype = var.getBaseType();
        D4Cursor data = new D4Cursor(DataCursor.Scheme.ATOMIC, this.dsp, (DapNode)var, container);
        data.setOffset(D4DataCompiler.getPos(this.databuffer));
        long total = 0L;
        long dimproduct = var.getCount();
        if (!daptype.isEnumType() && !daptype.isFixedSize()) {
            long[] positions = new long[(int)dimproduct];
            int savepos = this.databuffer.position();
            total = D4DataCompiler.walkByteStrings(positions, this.databuffer);
            this.databuffer.position(savepos);
            data.setByteStringOffsets(total, positions);
        } else {
            total = dimproduct * (long)daptype.getSize();
        }
        D4DataCompiler.skip(this.databuffer, (int)total);
        return data;
    }

    protected D4Cursor compileStructureArray(DapVariable var, D4Cursor container) throws DapException {
        DapStructure dapstruct = (DapStructure)var.getBaseType();
        D4Cursor structarray = new D4Cursor(DataCursor.Scheme.STRUCTARRAY, this.dsp, (DapNode)var, container).setOffset(D4DataCompiler.getPos(this.databuffer));
        List<DapDimension> dimset = var.getDimensions();
        long dimproduct = DapUtil.dimProduct(dimset);
        D4Cursor[] instances = new D4Cursor[(int)dimproduct];
        Odometer odom = Odometer.factory(DapUtil.dimsetToSlices(dimset), dimset);
        while (odom.hasNext()) {
            Index index = odom.next();
            D4Cursor instance = this.compileStructure(var, dapstruct, structarray);
            instance.setIndex(index);
            instances[(int)index.index()] = instance;
        }
        structarray.setElements(instances);
        return structarray;
    }

    protected D4Cursor compileStructure(DapVariable var, DapStructure dapstruct, D4Cursor container) throws DapException {
        int pos = D4DataCompiler.getPos(this.databuffer);
        D4Cursor d4ds = new D4Cursor(DataCursor.Scheme.STRUCTURE, this.dsp, (DapNode)var, container).setOffset(pos);
        List<DapVariable> dfields = dapstruct.getFields();
        for (int m3 = 0; m3 < dfields.size(); ++m3) {
            DapVariable dfield = dfields.get(m3);
            D4Cursor dvfield = this.compileVar(dfield, d4ds);
            d4ds.addField(m3, dvfield);
            assert (dfield.getParent() != null);
        }
        return d4ds;
    }

    protected D4Cursor compileSequenceArray(DapVariable var, D4Cursor container) throws DapException {
        DapSequence dapseq = (DapSequence)var.getBaseType();
        D4Cursor seqarray = new D4Cursor(DataCursor.Scheme.SEQARRAY, this.dsp, (DapNode)var, container).setOffset(D4DataCompiler.getPos(this.databuffer));
        List<DapDimension> dimset = var.getDimensions();
        long dimproduct = DapUtil.dimProduct(dimset);
        D4Cursor[] instances = new D4Cursor[(int)dimproduct];
        Odometer odom = Odometer.factory(DapUtil.dimsetToSlices(dimset), dimset);
        while (odom.hasNext()) {
            Index index = odom.next();
            D4Cursor instance = this.compileSequence(var, dapseq, seqarray);
            instance.setIndex(index);
            instances[(int)index.index()] = instance;
        }
        seqarray.setElements(instances);
        return seqarray;
    }

    public D4Cursor compileSequence(DapVariable var, DapSequence dapseq, D4Cursor container) throws DapException {
        int pos = D4DataCompiler.getPos(this.databuffer);
        D4Cursor seq = new D4Cursor(DataCursor.Scheme.SEQUENCE, this.dsp, (DapNode)var, container).setOffset(pos);
        List<DapVariable> dfields = dapseq.getFields();
        long nrecs = D4DataCompiler.getCount(this.databuffer);
        int r = 0;
        while ((long)r < nrecs) {
            pos = D4DataCompiler.getPos(this.databuffer);
            D4Cursor rec = (D4Cursor)new D4Cursor(DataCursor.Scheme.RECORD, this.dsp, (DapNode)var, container).setOffset(pos).setRecordIndex(r);
            for (int m3 = 0; m3 < dfields.size(); ++m3) {
                DapVariable dfield = dfields.get(m3);
                D4Cursor dvfield = this.compileVar(dfield, rec);
                rec.addField(m3, dvfield);
                assert (dfield.getParent() != null);
            }
            seq.addRecord(rec);
            ++r;
        }
        return seq;
    }

    protected int extractChecksum(ByteBuffer data) throws DapException {
        assert (ChecksumMode.DAP.enabled(this.checksummode));
        if (data.remaining() < 4) {
            throw new DapException("Short serialization: missing checksum");
        }
        return data.getInt();
    }

    protected static void skip(ByteBuffer data, int count) {
        data.position(data.position() + count);
    }

    protected static int getCount(ByteBuffer data) {
        long count = data.getLong();
        return (int)(count &= 0xFFFFFFFFFFFFFFFFL);
    }

    protected static int getPos(ByteBuffer data) {
        return data.position();
    }

    protected static int computeTypeSize(DapType daptype) {
        return LibTypeFcns.size(daptype);
    }

    protected static long walkByteStrings(long[] positions, ByteBuffer databuffer) {
        int count = positions.length;
        long total = 0L;
        int savepos = databuffer.position();
        for (int i = 0; i < count; ++i) {
            int pos = databuffer.position();
            positions[i] = pos;
            int size = D4DataCompiler.getCount(databuffer);
            total += 8L;
            total += (long)size;
            D4DataCompiler.skip(databuffer, size);
        }
        databuffer.position(savepos);
        return total;
    }
}

