/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.web.appender;

import java.io.Serializable;
import javax.servlet.ServletContext;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.web.WebLoggerContextUtils;

@Plugin(name="Servlet", category="Core", elementType="appender", printObject=true)
public class ServletAppender
extends AbstractAppender {
    private final ServletContext servletContext;
    private final boolean logThrowables;

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private ServletAppender(String name, Layout<? extends Serializable> layout, Filter filter, ServletContext servletContext, boolean ignoreExceptions, boolean logThrowables) {
        super(name, filter, layout, ignoreExceptions);
        this.servletContext = servletContext;
        this.logThrowables = logThrowables;
    }

    @Override
    public void append(LogEvent event) {
        String serialized = (String)((AbstractStringLayout)this.getLayout()).toSerializable(event);
        if (this.logThrowables) {
            this.servletContext.log(serialized, event.getThrown());
        } else {
            this.servletContext.log(serialized);
        }
    }

    @Deprecated
    public static ServletAppender createAppender(Layout<? extends Serializable> layout, Filter filter, String name, boolean ignoreExceptions) {
        return ((Builder)((Builder)((Builder)((Builder)((AbstractFilterable.Builder)ServletAppender.newBuilder()).withFilter(filter)).withIgnoreExceptions(ignoreExceptions)).withLayout(layout)).withName(name)).build();
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractAppender.Builder<B>
    implements org.apache.logging.log4j.core.util.Builder<ServletAppender> {
        @PluginBuilderAttribute
        private boolean logThrowables;

        @Override
        public ServletAppender build() {
            ServletContext servletContext;
            String name = this.getName();
            if (name == null) {
                LOGGER.error("No name provided for ServletAppender");
            }
            if ((servletContext = WebLoggerContextUtils.getServletContext()) == null) {
                LOGGER.error("No servlet context is available");
                return null;
            }
            PatternLayout layout = this.getLayout();
            if (layout == null) {
                layout = PatternLayout.createDefaultLayout();
            } else if (!(layout instanceof AbstractStringLayout)) {
                LOGGER.error("Layout must be a StringLayout to log to ServletContext");
                return null;
            }
            return new ServletAppender(name, layout, this.getFilter(), servletContext, this.isIgnoreExceptions(), this.logThrowables);
        }

        public boolean isLogThrowables() {
            return this.logThrowables;
        }

        public void setLogThrowables(boolean logThrowables) {
            this.logThrowables = logThrowables;
        }
    }
}

