/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.adapter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageCS;
import ucar.nc2.ft2.coverage.adapter.DtCoverageDataset;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;

public class DtCoverage
implements IsMissingEvaluator {
    private static final Logger log = LoggerFactory.getLogger(DtCoverage.class);
    private static final boolean debugArrayShape = false;
    private final DtCoverageDataset dataset;
    private final DtCoverageCS gcs;
    private final VariableDS vs;
    private int xDimOrgIndex = -1;
    private int yDimOrgIndex = -1;
    private int zDimOrgIndex = -1;
    private int tDimOrgIndex = -1;
    private int eDimOrgIndex = -1;
    private int rtDimOrgIndex = -1;
    private int xDimNewIndex = -1;
    private int yDimNewIndex = -1;
    private int zDimNewIndex = -1;
    private int tDimNewIndex = -1;
    private int eDimNewIndex = -1;
    private int rtDimNewIndex = -1;
    private final List<Dimension> mydims;
    private int hashCode = 0;

    public DtCoverage(DtCoverageDataset dataset, DtCoverageCS gcs, VariableDS dsvar) {
        this.dataset = dataset;
        this.vs = dsvar;
        this.gcs = gcs;
        CoordinateAxis xaxis = gcs.getXHorizAxis();
        if (xaxis instanceof CoordinateAxis1D) {
            this.xDimOrgIndex = this.findDimension(xaxis.getDimension(0));
            this.yDimOrgIndex = this.findDimension(gcs.getYHorizAxis().getDimension(0));
        } else {
            this.yDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(0));
            this.xDimOrgIndex = this.findDimension(gcs.getXHorizAxis().getDimension(1));
        }
        if (gcs.getVerticalAxis() != null) {
            this.zDimOrgIndex = this.findDimension(gcs.getVerticalAxis().getDimension(0));
        }
        if (gcs.getTimeAxis() != null) {
            this.tDimOrgIndex = gcs.getTimeAxis().getRank() == 1 ? this.findDimension(gcs.getTimeAxis().getDimension(0)) : this.findDimension(gcs.getTimeAxis().getDimension(1));
            if (this.tDimOrgIndex == this.yDimOrgIndex || this.tDimOrgIndex == this.xDimOrgIndex) {
                this.tDimOrgIndex = -1;
            }
        }
        if (gcs.getEnsembleAxis() != null) {
            this.eDimOrgIndex = this.findDimension(gcs.getEnsembleAxis().getDimension(0));
        }
        if (gcs.getRunTimeAxis() != null) {
            this.rtDimOrgIndex = this.findDimension(gcs.getRunTimeAxis().getDimension(0));
        }
        int count = 0;
        this.mydims = new ArrayList<Dimension>();
        if (this.rtDimOrgIndex >= 0 && this.rtDimOrgIndex != this.tDimOrgIndex) {
            this.mydims.add(dsvar.getDimension(this.rtDimOrgIndex));
            this.rtDimNewIndex = count++;
        }
        if (this.eDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.eDimOrgIndex));
            this.eDimNewIndex = count++;
        }
        if (this.tDimOrgIndex >= 0) {
            Dimension tdim = dsvar.getDimension(this.tDimOrgIndex);
            this.mydims.add(tdim);
            this.tDimNewIndex = count++;
        }
        if (this.zDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.zDimOrgIndex));
            this.zDimNewIndex = count++;
        }
        if (this.yDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.yDimOrgIndex));
            this.yDimNewIndex = count++;
        }
        if (this.xDimOrgIndex >= 0) {
            this.mydims.add(dsvar.getDimension(this.xDimOrgIndex));
            this.xDimNewIndex = count;
        }
    }

    private int findDimension(Dimension want) {
        List<Dimension> dims = this.vs.getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension d = dims.get(i);
            if (!d.equals(want)) continue;
            return i;
        }
        return -1;
    }

    public List<Dimension> getDimensions() {
        return new ArrayList<Dimension>(this.mydims);
    }

    public Dimension getDimension(int i) {
        if (i < 0 || i >= this.mydims.size()) {
            return null;
        }
        return this.mydims.get(i);
    }

    public Dimension getTimeDimension() {
        return this.tDimNewIndex < 0 ? null : this.getDimension(this.tDimNewIndex);
    }

    public Dimension getZDimension() {
        return this.zDimNewIndex < 0 ? null : this.getDimension(this.zDimNewIndex);
    }

    public Dimension getYDimension() {
        return this.yDimNewIndex < 0 ? null : this.getDimension(this.yDimNewIndex);
    }

    public Dimension getXDimension() {
        return this.xDimNewIndex < 0 ? null : this.getDimension(this.xDimNewIndex);
    }

    public Dimension getEnsembleDimension() {
        return this.eDimNewIndex < 0 ? null : this.getDimension(this.eDimNewIndex);
    }

    public Dimension getRunTimeDimension() {
        return this.rtDimNewIndex < 0 ? null : this.getDimension(this.rtDimNewIndex);
    }

    public int getTimeDimensionIndex() {
        return this.tDimNewIndex;
    }

    public int getZDimensionIndex() {
        return this.zDimNewIndex;
    }

    public int getYDimensionIndex() {
        return this.yDimNewIndex;
    }

    public int getXDimensionIndex() {
        return this.xDimNewIndex;
    }

    public int getEnsembleDimensionIndex() {
        return this.eDimNewIndex;
    }

    public int getRunTimeDimensionIndex() {
        return this.rtDimNewIndex;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        return this.vs.findAttributeIgnoreCase(name);
    }

    public String findAttValueIgnoreCase(String attName, String defaultValue) {
        return this.dataset.getNetcdfDataset().findAttValueIgnoreCase(this.vs, attName, defaultValue);
    }

    public int getRank() {
        return this.mydims.size();
    }

    public int[] getShape() {
        int[] shape = new int[this.mydims.size()];
        for (int i = 0; i < this.mydims.size(); ++i) {
            Dimension d = this.mydims.get(i);
            shape[i] = d.getLength();
        }
        return shape;
    }

    public DataType getDataType() {
        return this.vs.getDataType();
    }

    public List<Attribute> getAttributes() {
        return this.vs.getAttributes();
    }

    public VariableDS getVariable() {
        return this.vs;
    }

    public String getFullName() {
        return this.vs.getFullName();
    }

    public String getName() {
        return this.vs.getFullName();
    }

    public String getShortName() {
        return this.vs.getShortName();
    }

    public DtCoverageCS getCoordinateSystem() {
        return this.gcs;
    }

    public ProjectionImpl getProjection() {
        return this.gcs.getProjection();
    }

    public String getDescription() {
        return this.vs.getDescription();
    }

    public String getUnitsString() {
        String units = this.vs.getUnitsString();
        return units == null ? "" : units;
    }

    public boolean hasMissingData() {
        return this.vs.hasMissing();
    }

    public boolean isMissingData(double val) {
        return this.vs.isMissing(val);
    }

    @Override
    public boolean hasMissing() {
        return this.vs.hasMissing();
    }

    @Override
    public boolean isMissing(double val) {
        return this.vs.isMissing(val);
    }

    public float[] setMissingToNaN(float[] values) {
        if (!this.vs.hasMissing()) {
            return values;
        }
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            double value = values[i];
            if (!this.vs.isMissing(value)) continue;
            values[i] = Float.NaN;
        }
        return values;
    }

    public MAMath.MinMax getMinMaxSkipMissingData(Array a) {
        return MAMath.getMinMaxSkipMissingData(a, this);
    }

    public Array readDataSlice(int t, int z, int y, int x) throws IOException {
        return this.readDataSlice(0, 0, t, z, y, x);
    }

    public Array readDataSlice(int rt, int e, int t, int z, int y, int x) throws IOException {
        Array dataVolume;
        int rank = this.vs.getRank();
        int[] start = new int[rank];
        int[] shape = new int[rank];
        for (int i = 0; i < rank; ++i) {
            start[i] = 0;
            shape[i] = 1;
        }
        Dimension xdim = this.getXDimension();
        Dimension ydim = this.getYDimension();
        Dimension zdim = this.getZDimension();
        Dimension tdim = this.getTimeDimension();
        Dimension edim = this.getEnsembleDimension();
        Dimension rtdim = this.getRunTimeDimension();
        if (rtdim != null) {
            if (rt >= 0 && rt < rtdim.getLength()) {
                start[this.rtDimOrgIndex] = rt;
            } else {
                shape[this.rtDimOrgIndex] = rtdim.getLength();
            }
        }
        if (edim != null) {
            if (e >= 0 && e < edim.getLength()) {
                start[this.eDimOrgIndex] = e;
            } else {
                shape[this.eDimOrgIndex] = edim.getLength();
            }
        }
        if (tdim != null) {
            if (t >= 0 && t < tdim.getLength()) {
                start[this.tDimOrgIndex] = t;
            } else {
                shape[this.tDimOrgIndex] = tdim.getLength();
            }
        }
        if (zdim != null) {
            if (z >= 0 && z < zdim.getLength()) {
                start[this.zDimOrgIndex] = z;
            } else {
                shape[this.zDimOrgIndex] = zdim.getLength();
            }
        }
        if (ydim != null) {
            if (y >= 0 && y < ydim.getLength()) {
                start[this.yDimOrgIndex] = y;
            } else {
                shape[this.yDimOrgIndex] = ydim.getLength();
            }
        }
        if (xdim != null) {
            if (x >= 0 && x < xdim.getLength()) {
                start[this.xDimOrgIndex] = x;
            } else {
                shape[this.xDimOrgIndex] = xdim.getLength();
            }
        }
        try {
            dataVolume = this.vs.read(start, shape);
        }
        catch (Exception ex) {
            log.error("GeoGrid.getdataSlice() on variable " + this.vs.getFullName() + " dataset " + this.dataset.getLocation(), ex);
            throw new IOException(ex);
        }
        int[] permuteIndex = this.calcPermuteIndex();
        if (permuteIndex != null) {
            dataVolume = dataVolume.permute(permuteIndex);
        }
        int count = 0;
        if (rtdim != null) {
            if (rt >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (edim != null) {
            if (e >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (tdim != null) {
            if (t >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (zdim != null) {
            if (z >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (ydim != null) {
            if (y >= 0) {
                dataVolume = dataVolume.reduce(count);
            } else {
                ++count;
            }
        }
        if (xdim != null && x >= 0) {
            dataVolume = dataVolume.reduce(count);
        }
        return dataVolume;
    }

    public Array readDataSection(Section subset, boolean canonicalOrder) throws InvalidRangeException, IOException {
        int[] permuteIndex;
        Range[] varRange = new Range[this.getRank()];
        for (Range r : subset.getRanges()) {
            AxisType type = AxisType.valueOf(r.getName());
            switch (type) {
                case Lon: 
                case GeoX: {
                    varRange[this.xDimOrgIndex] = r;
                    break;
                }
                case Lat: 
                case GeoY: {
                    varRange[this.yDimOrgIndex] = r;
                    break;
                }
                case Height: 
                case Pressure: 
                case GeoZ: {
                    varRange[this.zDimOrgIndex] = r;
                    break;
                }
                case Time: {
                    varRange[this.tDimOrgIndex] = r;
                    break;
                }
                case RunTime: {
                    varRange[this.rtDimOrgIndex] = r;
                    break;
                }
                case Ensemble: {
                    varRange[this.eDimOrgIndex] = r;
                }
            }
        }
        Array dataVolume = this.vs.read(Arrays.asList(varRange));
        if (canonicalOrder && (permuteIndex = this.calcPermuteIndex()) != null) {
            dataVolume = dataVolume.permute(permuteIndex);
        }
        return dataVolume;
    }

    private int[] calcPermuteIndex() throws IOException {
        Dimension xdim = this.getXDimension();
        Dimension ydim = this.getYDimension();
        Dimension zdim = this.getZDimension();
        Dimension tdim = this.getTimeDimension();
        Dimension edim = this.getEnsembleDimension();
        Dimension rtdim = this.getRunTimeDimension();
        List<Dimension> oldDims = this.vs.getDimensions();
        int[] permuteIndex = new int[this.vs.getRank()];
        int count = 0;
        if (oldDims.contains(rtdim)) {
            permuteIndex[count++] = oldDims.indexOf(rtdim);
        }
        if (oldDims.contains(edim)) {
            permuteIndex[count++] = oldDims.indexOf(edim);
        }
        if (oldDims.contains(tdim)) {
            permuteIndex[count++] = oldDims.indexOf(tdim);
        }
        if (oldDims.contains(zdim)) {
            permuteIndex[count++] = oldDims.indexOf(zdim);
        }
        if (oldDims.contains(ydim)) {
            permuteIndex[count++] = oldDims.indexOf(ydim);
        }
        if (oldDims.contains(xdim)) {
            permuteIndex[count] = oldDims.indexOf(xdim);
        }
        boolean needPermute = false;
        for (int i = 0; i < permuteIndex.length; ++i) {
            if (i == permuteIndex[i]) continue;
            needPermute = true;
        }
        return (int[])(needPermute ? permuteIndex : null);
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof DtCoverage)) {
            return false;
        }
        DtCoverage d = (DtCoverage)oo;
        if (!this.getFullName().equals(d.getFullName())) {
            return false;
        }
        return this.getCoordinateSystem().equals(d.getCoordinateSystem());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getFullName().hashCode();
            this.hashCode = result = 37 * result + this.getCoordinateSystem().hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getFullName();
    }

    public String getInfo() {
        StringBuilder buf = new StringBuilder(200);
        buf.setLength(0);
        buf.append(this.getFullName());
        Format.tab(buf, 30, true);
        buf.append(this.getUnitsString());
        Format.tab(buf, 60, true);
        buf.append(this.hasMissingData());
        Format.tab(buf, 66, true);
        buf.append(this.getDescription());
        return buf.toString();
    }

    public int compareTo(DtCoverage g2) {
        return this.getFullName().compareTo(g2.getFullName());
    }
}

