/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.Iterator;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.RangeIterator;

@Immutable
public class Range
implements RangeIterator {
    public static final Range EMPTY = new Range();
    public static final Range ONE = new Range(1);
    public static final Range VLEN = new Range(-1);
    private final int length;
    private final int first;
    private final int last;
    private final int stride;
    private final String name;

    public static Range make(String name, int len) {
        try {
            return new Range(name, 0, len - 1, 1);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public static Range make(int first, int last) {
        try {
            return new Range(first, last);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    private Range() {
        this.length = 0;
        this.first = 0;
        this.last = 0;
        this.stride = 1;
        this.name = null;
    }

    public Range(int first, int last) throws InvalidRangeException {
        this(null, first, last, 1);
    }

    public Range(int length) {
        assert (length != 0);
        this.name = null;
        this.first = 0;
        this.last = length - 1;
        this.stride = 1;
        this.length = length;
    }

    public Range(String name, int first, int last) throws InvalidRangeException {
        this(name, first, last, 1);
    }

    public Range(int first, int last, int stride) throws InvalidRangeException {
        this(null, first, last, stride);
    }

    public Range(String name, int first, int last, int stride) throws InvalidRangeException {
        if (first < 0) {
            throw new InvalidRangeException("first (" + first + ") must be >= 0");
        }
        if (last < first) {
            throw new InvalidRangeException("last (" + last + ") must be >= first (" + first + ")");
        }
        if (stride < 1) {
            throw new InvalidRangeException("stride (" + stride + ") must be > 0");
        }
        this.name = name;
        this.first = first;
        this.stride = stride;
        this.length = 1 + (last - first) / stride;
        this.last = first + (this.length - 1) * stride;
        assert (stride != 1 || this.last == last);
    }

    protected Range(String name, int first, int last, int stride, int length) throws InvalidRangeException {
        if (first < 0) {
            throw new InvalidRangeException("first (" + first + ") must be >= 0");
        }
        if (last < first) {
            throw new InvalidRangeException("last (" + last + ") must be >= first (" + first + ")");
        }
        if (stride < 1) {
            throw new InvalidRangeException("stride (" + stride + ") must be > 0");
        }
        if (length < (1 + last - first) / stride) {
            throw new InvalidRangeException("length (" + length + ") must be > (1 + last - first) / stride");
        }
        this.name = name;
        this.first = first;
        this.last = last;
        this.stride = stride;
        this.length = length;
    }

    @Deprecated
    public Range setStride(int stride) throws InvalidRangeException {
        return new Range(this.first(), this.last(), stride);
    }

    public Range copyWithStride(int stride) throws InvalidRangeException {
        if (stride == this.stride) {
            return this;
        }
        return new Range(this.first(), this.last(), stride);
    }

    @Override
    @Deprecated
    public Range setName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        try {
            return new Range(name, this.first, this.last, this.stride, this.length);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Range copyWithName(String name) {
        if (name.equals(this.getName())) {
            return this;
        }
        try {
            return new Range(name, this.first, this.last, this.stride, this.length);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int first() {
        return this.first;
    }

    public int last() {
        return this.last;
    }

    @Override
    public int length() {
        return this.length;
    }

    public int stride() {
        return this.stride;
    }

    public boolean contains(int want) {
        if (want < this.first()) {
            return false;
        }
        if (want > this.last()) {
            return false;
        }
        if (this.stride == 1) {
            return true;
        }
        return (want - this.first) % this.stride == 0;
    }

    public Range compose(Range r) throws InvalidRangeException {
        if (this.length() == 0 || r.length() == 0) {
            return EMPTY;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        int sr_stride = this.stride * r.stride;
        int sr_first = this.element(r.first());
        int lastx = this.element(r.last());
        int sr_last = Math.min(this.last(), lastx);
        return new Range(this.name, sr_first, sr_last, sr_stride);
    }

    public Range compact() throws InvalidRangeException {
        if (this.stride == 1) {
            return this;
        }
        int first = this.first() / this.stride;
        int last = first + this.length() - 1;
        return new Range(this.name, first, last, 1);
    }

    public int element(int i) throws InvalidRangeException {
        if (i < 0) {
            throw new InvalidRangeException("i must be >= 0");
        }
        if (i >= this.length) {
            throw new InvalidRangeException("i must be < length");
        }
        return this.first + i * this.stride;
    }

    public int index(int want) throws InvalidRangeException {
        if (want < this.first) {
            throw new InvalidRangeException("elem must be >= first");
        }
        int result = (want - this.first) / this.stride;
        if (result > this.length) {
            throw new InvalidRangeException("elem must be <= first = n * stride");
        }
        return result;
    }

    public Range intersect(Range r) throws InvalidRangeException {
        int useFirst;
        if (this.length() == 0 || r.length() == 0) {
            return EMPTY;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        int last = Math.min(this.last(), r.last());
        int resultStride = this.stride * r.stride();
        if (resultStride == 1) {
            useFirst = Math.max(this.first(), r.first());
        } else if (this.stride == 1) {
            if (r.first() >= this.first()) {
                useFirst = r.first();
            } else {
                int incr = (this.first() - r.first()) / resultStride;
                useFirst = r.first() + incr * resultStride;
                if (useFirst < this.first()) {
                    useFirst += resultStride;
                }
            }
        } else if (r.stride == 1) {
            if (this.first() >= r.first()) {
                useFirst = this.first();
            } else {
                int incr = (r.first() - this.first()) / resultStride;
                useFirst = this.first() + incr * resultStride;
                if (useFirst < r.first()) {
                    useFirst += resultStride;
                }
            }
        } else {
            throw new UnsupportedOperationException("Intersection when both ranges have a stride");
        }
        if (useFirst > last) {
            return EMPTY;
        }
        return new Range(this.name, useFirst, last, resultStride);
    }

    public boolean intersects(Range r) {
        int useFirst;
        if (this.length() == 0 || r.length() == 0) {
            return false;
        }
        if (this == VLEN || r == VLEN) {
            return true;
        }
        int last = Math.min(this.last(), r.last());
        int resultStride = this.stride * r.stride();
        if (resultStride == 1) {
            useFirst = Math.max(this.first(), r.first());
        } else if (this.stride == 1) {
            if (r.first() >= this.first()) {
                useFirst = r.first();
            } else {
                int incr = (this.first() - r.first()) / resultStride;
                useFirst = r.first() + incr * resultStride;
                if (useFirst < this.first()) {
                    useFirst += resultStride;
                }
            }
        } else if (r.stride() == 1) {
            if (this.first() >= r.first()) {
                useFirst = this.first();
            } else {
                int incr = (r.first() - this.first()) / resultStride;
                useFirst = this.first() + incr * resultStride;
                if (useFirst < r.first()) {
                    useFirst += resultStride;
                }
            }
        } else {
            throw new UnsupportedOperationException("Intersection when both ranges have a stride");
        }
        return useFirst <= last;
    }

    public boolean past(Range want) {
        return this.first() > want.last();
    }

    public Range shiftOrigin(int origin) throws InvalidRangeException {
        if (this == VLEN) {
            return VLEN;
        }
        int first = this.first() - origin;
        int last = this.last() - origin;
        return new Range(this.name, first, last, this.stride);
    }

    public Range union(Range r) throws InvalidRangeException {
        if (this.length() == 0) {
            return r;
        }
        if (this == VLEN || r == VLEN) {
            return VLEN;
        }
        if (r.length() == 0) {
            return this;
        }
        int first = Math.min(this.first(), r.first());
        int last = Math.max(this.last(), r.last());
        return new Range(this.name, first, last);
    }

    public int getFirstInInterval(int start) {
        if (start > this.last()) {
            return -1;
        }
        if (start <= this.first) {
            return this.first;
        }
        if (this.stride == 1) {
            return start;
        }
        int offset = start - this.first;
        int i = offset / this.stride;
        i = offset % this.stride == 0 ? i : i + 1;
        return this.first + i * this.stride;
    }

    public String toString() {
        if (this.length == 0) {
            return ":";
        }
        if (this.length < 0) {
            return ":";
        }
        return this.first + ":" + this.last() + (this.stride > 1 ? ":" + this.stride : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Range)) {
            return false;
        }
        Range or = (Range)o;
        if (this.length == 0 && or.length == 0) {
            return true;
        }
        return or.first == this.first && or.length == this.length && or.stride == this.stride && or.last == this.last;
    }

    public int hashCode() {
        int result = this.first;
        result = 37 * result + this.last;
        result = 37 * result + this.stride;
        result = 37 * result + this.length;
        return result;
    }

    public Iterator<Integer> getIterator() {
        return new MyIterator();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new MyIterator();
    }

    private int elementNC(int i) {
        return this.first + i * this.stride;
    }

    private class MyIterator
    implements Iterator<Integer> {
        private int current;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.current < Range.this.length;
        }

        @Override
        public Integer next() {
            return Range.this.elementNC(this.current++);
        }
    }
}

