/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.TimedCollection;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.collection.CompositeDatasetFactory;
import ucar.nc2.ft.point.collection.CompositeStationCollectionFlattened;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;

public class CompositeStationCollection
extends StationTimeSeriesCollectionImpl
implements UpdateableCollection {
    private static Logger log = LoggerFactory.getLogger(CompositeStationCollection.class);
    private TimedCollection dataCollection;
    protected List<VariableSimpleIF> dataVariables;
    protected List<Attribute> globalAttributes;

    protected CompositeStationCollection(String name, CalendarDateUnit timeUnit, String altUnits, TimedCollection dataCollection) {
        super(name, timeUnit, altUnits);
        this.dataCollection = dataCollection;
        TimedCollection.Dataset td = dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
    }

    @Override
    protected StationHelper createStationHelper() throws IOException {
        TimedCollection.Dataset td = this.dataCollection.getPrototype();
        if (td == null) {
            throw new RuntimeException("No datasets in the collection");
        }
        Formatter errlog = new Formatter();
        try (FeatureDatasetPoint openDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);){
            if (openDataset == null) {
                throw new IllegalStateException("Cant open FeatureDatasetPoint " + td.getLocation());
            }
            StationHelper stationHelper = new StationHelper();
            List<DsgFeatureCollection> fcList = openDataset.getPointFeatureCollectionList();
            StationTimeSeriesCollectionImpl openCollection = (StationTimeSeriesCollectionImpl)fcList.get(0);
            List<StationFeature> stns = openCollection.getStationFeatures();
            for (StationFeature stnFeature : stns) {
                stationHelper.addStation(new CompositeStationFeature(stnFeature, this.timeUnit, this.altUnits, stnFeature.getFeatureData(), this.dataCollection));
            }
            this.dataVariables = openDataset.getDataVariables();
            this.globalAttributes = openDataset.getGlobalAttributes();
            StationHelper stationHelper2 = stationHelper;
            return stationHelper2;
        }
    }

    public List<VariableSimpleIF> getDataVariables() {
        this.getStationHelper();
        return this.dataVariables;
    }

    public List<Attribute> getGlobalAttributes() {
        this.getStationHelper();
        return this.globalAttributes;
    }

    @Override
    public CalendarDateRange update() throws IOException {
        return this.dataCollection.update();
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<StationFeature> stations) {
        if (stations == null) {
            return this;
        }
        return new CompositeStationCollectionSubset(this, stations);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this;
        }
        List<StationFeature> subset = this.getStationHelper().getStationFeatures(boundingBox);
        return new CompositeStationCollectionSubset(this, subset);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), this.getTimeUnit(), this.getAltUnits(), boundingBox, dateRange, subsetCollection);
    }

    @Override
    public PointFeatureCollection flatten(List<String> stations, CalendarDateRange dateRange, List<VariableSimpleIF> varList) {
        TimedCollection subsetCollection = dateRange != null ? this.dataCollection.subset(dateRange) : this.dataCollection;
        return new CompositeStationCollectionFlattened(this.getName(), this.getTimeUnit(), this.getAltUnits(), stations, dateRange, varList, subsetCollection);
    }

    @Override
    public PointFeatureCollectionIterator getPointFeatureCollectionIterator() {
        return new PointFeatureCollectionIterator(){
            Iterator<Station> stationIter;
            {
                this.stationIter = CompositeStationCollection.this.getStationHelper().getStations().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.stationIter.hasNext();
            }

            @Override
            public PointFeatureCollection next() {
                return (PointFeatureCollection)((Object)this.stationIter.next());
            }

            @Override
            public void close() {
            }
        };
    }

    private static class CompositeStationFeature
    extends StationTimeSeriesFeatureImpl {
        private TimedCollection collForFeature;
        private StructureData sdata;

        CompositeStationFeature(StationFeature s2, CalendarDateUnit timeUnit, String altUnits, StructureData sdata, TimedCollection collForFeature) {
            super(s2, timeUnit, altUnits, -1);
            this.sdata = sdata;
            this.collForFeature = collForFeature;
            CalendarDateRange cdr = collForFeature.getDateRange();
            if (cdr != null) {
                this.getInfo();
                this.info.setCalendarDateRange(cdr);
            }
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() {
            return new CompositeStationFeatureIterator();
        }

        @Override
        public StationTimeSeriesFeature subset(CalendarDateRange dateRange) {
            if (dateRange == null) {
                return this;
            }
            TimedCollection collectionSubset = this.collForFeature.subset(dateRange);
            CompositeStationFeature compStnFeatSubset = new CompositeStationFeature(this.s, this.getTimeUnit(), this.getAltUnits(), this.sdata, collectionSubset);
            return new StationTimeSeriesFeatureImpl.StationFeatureSubset(compStnFeatSubset, dateRange);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.sdata;
        }

        @Override
        @Nullable
        public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        private class CompositeStationFeatureIterator
        extends PointIteratorAbstract {
            private Iterator<TimedCollection.Dataset> iter;
            private FeatureDatasetPoint currentDataset;
            private PointFeatureIterator pfIter;
            private boolean finished;

            CompositeStationFeatureIterator() {
                this.iter = CompositeStationFeature.this.collForFeature.getDatasets().iterator();
            }

            private PointFeatureIterator getNextIterator() throws IOException {
                if (!this.iter.hasNext()) {
                    return null;
                }
                TimedCollection.Dataset td = this.iter.next();
                Formatter errlog = new Formatter();
                this.currentDataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION, td.getLocation(), null, errlog);
                if (this.currentDataset == null) {
                    throw new IllegalStateException("Cant open FeatureDatasetPoint " + td.getLocation());
                }
                List<DsgFeatureCollection> fcList = this.currentDataset.getPointFeatureCollectionList();
                StationTimeSeriesFeatureCollection stnCollection = (StationTimeSeriesFeatureCollection)fcList.get(0);
                StationFeature s2 = stnCollection.findStationFeature(CompositeStationFeature.this.getName());
                if (s2 == null) {
                    log.debug("CompositeStationFeatureIterator dataset: {} missing station {}", (Object)td.getLocation(), (Object)CompositeStationFeature.this.getName());
                    this.currentDataset.close();
                    return this.getNextIterator();
                }
                StationTimeSeriesFeature stnFeature = stnCollection.getStationTimeSeriesFeature(s2);
                if (CompositeDatasetFactory.debug) {
                    System.out.printf("CompositeStationFeatureIterator open dataset: %s for %s%n", td.getLocation(), s2.getName());
                }
                return stnFeature.getPointFeatureIterator();
            }

            @Override
            public boolean hasNext() {
                try {
                    if (this.pfIter == null) {
                        this.pfIter = this.getNextIterator();
                        if (this.pfIter == null) {
                            this.close();
                            return false;
                        }
                    }
                    if (!this.pfIter.hasNext()) {
                        this.pfIter.close();
                        this.currentDataset.close();
                        if (CompositeDatasetFactory.debug) {
                            System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                        }
                        this.pfIter = this.getNextIterator();
                        return this.hasNext();
                    }
                    return true;
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }

            @Override
            public PointFeature next() {
                PointFeature pf = this.pfIter.next();
                this.calcBounds(pf);
                return pf;
            }

            @Override
            public void close() {
                if (this.finished) {
                    return;
                }
                if (this.pfIter != null) {
                    this.pfIter.close();
                }
                if (this.currentDataset != null) {
                    try {
                        this.currentDataset.close();
                        if (CompositeDatasetFactory.debug) {
                            System.out.printf("CompositeStationFeatureIterator close dataset: %s%n", this.currentDataset.getLocation());
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.finishCalcBounds();
                this.finished = true;
            }
        }
    }

    private static class CompositeStationCollectionSubset
    extends CompositeStationCollection {
        private final CompositeStationCollection from;
        private final List<StationFeature> stationFeats;

        private CompositeStationCollectionSubset(CompositeStationCollection from, List<StationFeature> stationFeats) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits(), from.dataCollection);
            this.from = Preconditions.checkNotNull(from, "from == null");
            Preconditions.checkArgument(stationFeats != null && !stationFeats.isEmpty(), "stationFeats == null || stationFeats.isEmpty(): %s", stationFeats);
            this.stationFeats = stationFeats;
        }

        @Override
        protected StationHelper createStationHelper() throws IOException {
            StationHelper stationHelper = new StationHelper();
            for (StationFeature stationFeat : this.stationFeats) {
                stationHelper.addStation(new CompositeStationFeature(stationFeat, this.timeUnit, this.altUnits, stationFeat.getFeatureData(), this.from.dataCollection));
            }
            return stationHelper;
        }
    }
}

