/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.util.Indent;
import ucar.unidata.geoloc.ProjectionImpl;

@Immutable
public class CoverageTransform
implements AttributeContainer {
    private final String name;
    private final AttributeContainer attributes;
    private final boolean isHoriz;
    private ProjectionImpl projection;

    public CoverageTransform(String name, AttributeContainer attributes, boolean isHoriz) {
        this.name = name;
        this.attributes = attributes;
        this.isHoriz = isHoriz;
    }

    public boolean isHoriz() {
        return this.isHoriz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectionImpl getProjection() {
        CoverageTransform coverageTransform = this;
        synchronized (coverageTransform) {
            if (this.projection == null && this.isHoriz) {
                this.projection = CoordTransBuilder.makeProjection(this, new Formatter());
            }
            return this.projection;
        }
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public void toString(Formatter f, Indent indent) {
        indent.incr();
        f.format("%s CoordTransform '%s'", indent, this.name);
        f.format(" isHoriz: %s%n", this.isHoriz());
        if (this.projection != null) {
            f.format(" projection: %s%n", this.projection);
        }
        for (Attribute att : this.attributes) {
            f.format("%s     %s%n", indent, att);
        }
        f.format("%n", new Object[0]);
        indent.decr();
    }

    public AttributeContainer attributes() {
        return this.attributes;
    }

    @Override
    @Deprecated
    public List<Attribute> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    @Deprecated
    public Attribute findAttribute(String name) {
        return this.attributes.findAttribute(name);
    }

    @Override
    @Deprecated
    public Attribute findAttributeIgnoreCase(String name) {
        return this.attributes.findAttributeIgnoreCase(name);
    }

    @Override
    @Deprecated
    public String findAttributeString(String attName, String defaultValue) {
        return this.attributes.findAttributeString(attName, defaultValue);
    }

    @Override
    @Deprecated
    public double findAttributeDouble(String attName, double defaultValue) {
        return this.attributes.findAttributeDouble(attName, defaultValue);
    }

    @Override
    @Deprecated
    public int findAttributeInteger(String attName, int defaultValue) {
        return this.attributes.findAttributeInteger(attName, defaultValue);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean remove(Attribute a) {
        return false;
    }

    @Override
    public boolean removeAttribute(String attName) {
        return false;
    }

    @Override
    public boolean removeAttributeIgnoreCase(String attName) {
        return false;
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        return null;
    }
}

