/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis2D;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Optional;

public class LatLonAxis2D
extends CoverageCoordAxis {
    private int[] shape;
    private Object userObject;

    public LatLonAxis2D(CoverageCoordAxisBuilder builder) {
        super(builder);
        this.shape = builder.shape;
        this.userObject = builder.userObject;
    }

    @Override
    protected void setDataset(CoordSysContainer dataset) {
        if (this.shape != null) {
            return;
        }
        ArrayList<CoverageCoordAxis> dependentAxes = new ArrayList<CoverageCoordAxis>();
        int[] shape = new int[2];
        int count = 0;
        for (String axisName : this.dependsOn) {
            CoverageCoordAxis axis = dataset.findCoordAxis(axisName);
            if (axis == null) {
                if (this.shape != null) continue;
                throw new IllegalStateException("LatLonAxis2D cant find axis " + axisName);
            }
            shape[count] = axis.getNcoords();
            dependentAxes.add(axis);
        }
        this.shape = shape;
    }

    @Override
    public CoverageCoordAxis copy() {
        return new LatLonAxis2D(new CoverageCoordAxisBuilder(this));
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public List<RangeIterator> getRanges() {
        ArrayList<RangeIterator> result = new ArrayList<RangeIterator>();
        result.add(Range.make(AxisType.Lat.toString(), this.shape[0]));
        result.add(Range.make(AxisType.Lon.toString(), this.shape[1]));
        return result;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s  shape=[%s]%n", indent, Arrays.toString(this.shape));
    }

    public double getCoord(int yindex, int xindex) {
        this.loadValuesIfNeeded();
        int idx = yindex * this.shape[1] + xindex;
        return this.values[idx];
    }

    @Override
    public Optional<CoverageCoordAxis> subset(SubsetParams params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<CoverageCoordAxis> subset(double minValue, double maxValue, int stride) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Optional<CoverageCoordAxis> subsetDependent(CoverageCoordAxis1D from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getCoordsAsArray() {
        double[] values = this.getValues();
        return Array.factory(DataType.DOUBLE, this.shape, (Object)values);
    }

    @Override
    public Array getCoordBoundsAsArray() {
        return CoordinateAxis2D.makeEdges((ArrayDouble.D2)this.getCoordsAsArray());
    }

    public LatLonAxis2D subset(RangeIterator rangex, RangeIterator rangey) {
        CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this);
        double[] values = this.getValues();
        int nx = rangex.length();
        int ny = rangey.length();
        double[] svalues = new double[nx * ny];
        int count = 0;
        for (int y : rangey) {
            for (int x : rangex) {
                svalues[count++] = values[y * nx + x];
            }
        }
        builder.values = svalues;
        builder.isSubset = true;
        builder.ncoords = nx * ny;
        builder.shape = new int[]{ny, nx};
        return new LatLonAxis2D(builder);
    }
}

