/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.util.Arrays;
import java.util.Formatter;
import javax.annotation.Nonnull;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Optional;
import ucar.nc2.write.Ncdump;

public class TimeAxis2DFmrc
extends CoverageCoordAxis {
    private int[] shape;
    private CoverageCoordAxis1D runCoord;

    public TimeAxis2DFmrc(CoverageCoordAxisBuilder builder) {
        super(builder);
    }

    @Override
    protected void setDataset(CoordSysContainer dataset) {
        if (this.shape != null) {
            throw new RuntimeException("Cant change axis once set");
        }
        this.shape = new int[2];
        String runtimeName = (String)this.dependsOn.get(0);
        CoverageCoordAxis runtime = dataset.findCoordAxis(runtimeName);
        if (runtime == null) {
            throw new IllegalStateException("FmrcTimeAxis2D cant find runtime axis with name " + runtimeName);
        }
        assert (runtime instanceof CoverageCoordAxis1D);
        assert (runtime.getAxisType() == AxisType.RunTime);
        this.runCoord = (CoverageCoordAxis1D)runtime;
        this.shape[0] = runtime.getNcoords();
        this.shape[1] = this.ncoords / this.shape[0];
    }

    @Override
    public CoverageCoordAxis copy() {
        return new TimeAxis2DFmrc(new CoverageCoordAxisBuilder(this));
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public void toString(Formatter f, Indent indent) {
        super.toString(f, indent);
        f.format("%s  %s%n", indent, Arrays.toString(this.shape));
        Array data = this.getCoordsAsArray();
        f.format("%s%n", Ncdump.printArray(data, this.getName() + " values", null));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(SubsetParams params) {
        if (params == null) {
            return Optional.of(new TimeAxis2DFmrc(new CoverageCoordAxisBuilder(this)));
        }
        CalendarDate rundate = (CalendarDate)params.get("runtime");
        boolean runtimeAll = (Boolean)params.get("runtimeAll");
        boolean latest = rundate == null && !runtimeAll;
        int run_index = -1;
        if (latest) {
            run_index = this.runCoord.getNcoords() - 1;
        } else if (rundate != null) {
            double rundateTarget = this.runCoord.convert(rundate);
            CoordAxisHelper helper = new CoordAxisHelper(this.runCoord);
            run_index = helper.findCoordElement(rundateTarget, true);
        }
        if (run_index >= 0) {
            CoverageCoordAxis1D time1D = this.getTimeAxisForRun(run_index);
            return time1D.subset(params);
        }
        return Optional.of(new TimeAxis2DFmrc(new CoverageCoordAxisBuilder(this)));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(double minValue, double maxValue, int stride) {
        return Optional.of(new TimeAxis2DFmrc(new CoverageCoordAxisBuilder(this)));
    }

    @Override
    @Nonnull
    public Optional<CoverageCoordAxis> subsetDependent(CoverageCoordAxis1D from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getCoordsAsArray() {
        double[] values = this.getValues();
        return Array.factory(DataType.DOUBLE, this.shape, (Object)values);
    }

    @Override
    public Array getCoordBoundsAsArray() {
        double[] values = this.getValues();
        int[] shapeB = new int[3];
        System.arraycopy(this.shape, 0, shapeB, 0, 2);
        shapeB[2] = 2;
        return Array.factory(DataType.DOUBLE, shapeB, (Object)values);
    }

    public CoverageCoordAxis1D getTimeAxisForRun(CalendarDate rundate) {
        double rundateTarget = this.runCoord.convert(rundate);
        int run_index = new CoordAxisHelper(this.runCoord).findCoordElement(rundateTarget, false);
        return run_index < 0 || run_index >= this.runCoord.getNcoords() ? null : this.getTimeAxisForRun(run_index);
    }

    public CoverageCoordAxis1D getTimeAxisForRun(int run_index) {
        if (this.spacing == CoverageCoordAxis.Spacing.irregularPoint) {
            Array data = this.getCoordsAsArray();
            Array subset = data.slice(0, run_index);
            int count = 0;
            int n = (int)subset.getSize();
            double[] values = new double[n];
            while (subset.hasNext()) {
                values[count++] = subset.nextDouble();
            }
            CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.name, this.units, this.description, this.dataType, this.axisType, AttributeContainerHelper.filter(this.attributes, "_Coordinate"), this.dependenceType, this.getDependsOn(), this.spacing, n, values[0], values[n - 1], 0.0, values, this.reader);
            builder.setIsSubset(true);
            return new CoverageCoordAxis1D(builder);
        }
        if (this.spacing == CoverageCoordAxis.Spacing.discontiguousInterval) {
            Array data = this.getCoordBoundsAsArray();
            Array subset = data.slice(0, run_index);
            int count = 0;
            int n = (int)subset.getSize();
            double[] values = new double[n];
            while (subset.hasNext()) {
                values[count++] = subset.nextDouble();
            }
            CoverageCoordAxisBuilder builder = new CoverageCoordAxisBuilder(this.name, this.units, this.description, this.dataType, this.axisType, AttributeContainerHelper.filter(this.attributes, "_Coordinate"), this.dependenceType, this.getDependsOn(), this.spacing, n / 2, values[0], values[n - 1], 0.0, values, this.reader);
            builder.setIsSubset(true);
            return new CoverageCoordAxis1D(builder);
        }
        return null;
    }
}

