/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.ncml.NcMLReaderNew;
import ucar.nc2.util.CancelTask;

public class ATDRadarConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "ATDRadar";

    ATDRadarConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        NcMLReaderNew.wrapNcMLresource(this.datasetBuilder, "resources/nj22/coords/ATDRadar.ncml", cancelTask);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return ATDRadarConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            String s2 = ncfile.getRootGroup().findAttributeString("sensor_name", "none");
            return s2.equalsIgnoreCase("CRAFT/NEXRAD");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new ATDRadarConvention(datasetBuilder);
        }
    }
}

