/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.hdf5;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerMutable;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.hdf4.HdfEos;
import ucar.nc2.internal.iosp.hdf4.HdfHeaderIF;
import ucar.nc2.internal.iosp.hdf5.H5iospNew;
import ucar.nc2.internal.iosp.hdf5.H5objects;
import ucar.nc2.internal.iosp.hdf5.H5tiledLayout;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.hdf5.DataBTree;
import ucar.nc2.iosp.hdf5.H5headerIF;
import ucar.nc2.iosp.hdf5.MemTracker;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.unidata.io.RandomAccessFile;

public class H5headerNew
implements H5headerIF,
HdfHeaderIF {
    private static Logger log = LoggerFactory.getLogger(H5headerNew.class);
    public static final String HDF5_CLASS = "CLASS";
    public static final String HDF5_DIMENSION_LIST = "DIMENSION_LIST";
    public static final String HDF5_DIMENSION_SCALE = "DIMENSION_SCALE";
    public static final String HDF5_DIMENSION_LABELS = "DIMENSION_LABELS";
    public static final String HDF5_DIMENSION_NAME = "NAME";
    public static final String HDF5_REFERENCE_LIST = "REFERENCE_LIST";
    private static boolean debugEnum;
    private static boolean debugVlen;
    private static boolean debug1;
    private static boolean debugDetail;
    private static boolean debugPos;
    private static boolean debugHeap;
    private static boolean debugV;
    private static boolean debugGroupBtree;
    private static boolean debugDataBtree;
    private static boolean debugBtree2;
    private static boolean debugContinueMessage;
    private static boolean debugTracker;
    private static boolean debugSoftLink;
    private static boolean debugHardLink;
    private static boolean debugSymbolTable;
    private static boolean warnings;
    private static boolean debugReference;
    private static boolean debugRegionReference;
    private static boolean debugCreationOrder;
    private static boolean debugStructure;
    private static boolean debugDimensionScales;
    private static final byte[] magic;
    private static final String magicString;
    private static final long maxHeaderPos = 50000L;
    private static final boolean transformReference = true;
    private static final int KNOWN_FILTERS = 3;
    private final RandomAccessFile raf;
    private final Group.Builder root;
    private final H5iospNew h5iosp;
    private long baseAddress;
    byte sizeOffsets;
    byte sizeLengths;
    boolean isOffsetLong;
    boolean isLengthLong;
    private boolean isNetcdf4;
    private H5objects.H5Group h5rootGroup;
    private Map<String, H5objects.DataObjectFacade> symlinkMap = new HashMap<String, H5objects.DataObjectFacade>(200);
    private Map<Long, H5objects.DataObject> addressMap = new HashMap<Long, H5objects.DataObject>(200);
    private SimpleDateFormat hdfDateParser;
    private H5objects h5objects;
    private PrintWriter debugOut;
    private MemTracker memTracker;
    private final Charset valueCharset;

    public static void setWarnings(boolean warn) {
        warnings = warn;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debug1 = debugFlag.isSet("H5header/header");
        debugBtree2 = debugFlag.isSet("H5header/btree2");
        debugContinueMessage = debugFlag.isSet("H5header/continueMessage");
        debugDetail = debugFlag.isSet("H5header/headerDetails");
        debugDataBtree = debugFlag.isSet("H5header/dataBtree");
        debugGroupBtree = debugFlag.isSet("H5header/groupBtree");
        debugHeap = debugFlag.isSet("H5header/Heap");
        debugPos = debugFlag.isSet("H5header/filePos");
        debugReference = debugFlag.isSet("H5header/reference");
        debugSoftLink = debugFlag.isSet("H5header/softLink");
        debugHardLink = debugFlag.isSet("H5header/hardLink");
        debugSymbolTable = debugFlag.isSet("H5header/symbolTable");
        debugTracker = debugFlag.isSet("H5header/memTracker");
        debugV = debugFlag.isSet("H5header/Variable");
        debugStructure = debugFlag.isSet("H5header/structure");
    }

    public static boolean isValidFile(RandomAccessFile raf) throws IOException {
        long filePos = 0L;
        long size = raf.length();
        while (filePos < size - 8L && filePos < 50000L) {
            byte[] buff = new byte[magic.length];
            raf.seek(filePos);
            if (raf.read(buff) < magic.length) {
                return false;
            }
            if (NetcdfFileFormat.memequal(buff, magic, magic.length)) {
                return true;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        return false;
    }

    H5headerNew(RandomAccessFile myRaf, Group.Builder root, H5iospNew h5iosp) {
        this.raf = myRaf;
        this.root = root;
        this.h5iosp = h5iosp;
        this.valueCharset = h5iosp.getValueCharset().orElse(StandardCharsets.UTF_8);
    }

    protected Charset getValueCharset() {
        return this.valueCharset;
    }

    public void read(PrintWriter debugPS) throws IOException {
        byte versionSB;
        if (debugPS != null) {
            this.debugOut = debugPS;
        } else if (debug1 || debugContinueMessage || debugCreationOrder || debugDetail || debugDimensionScales || debugGroupBtree || debugHardLink || debugHeap || debugPos || debugReference || debugTracker || debugV || debugSoftLink || warnings) {
            this.debugOut = new PrintWriter(new OutputStreamWriter(System.out));
        }
        this.h5objects = new H5objects(this, this.debugOut, this.memTracker);
        long actualSize = this.raf.length();
        if (debugTracker) {
            this.memTracker = new MemTracker(actualSize);
        }
        boolean ok = false;
        long filePos = 0L;
        while (filePos < actualSize - 8L) {
            this.raf.seek(filePos);
            String magic = this.raf.readString(8);
            if (magic.equals(magicString)) {
                ok = true;
                break;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        if (!ok) {
            throw new IOException("Not a netCDF4/HDF5 file ");
        }
        if (debug1) {
            log.debug("H5header opened file to read:'{}' size= {}", (Object)this.raf.getLocation(), (Object)actualSize);
        }
        this.raf.order(1);
        long superblockStart = this.raf.getFilePointer() - 8L;
        if (debugTracker) {
            this.memTracker.add("header", 0L, superblockStart);
        }
        if ((versionSB = this.raf.readByte()) < 2) {
            this.readSuperBlock1(superblockStart, versionSB);
        } else if (versionSB == 2) {
            this.readSuperBlock2(superblockStart);
        } else {
            throw new IOException("Unknown superblock version= " + versionSB);
        }
        this.replaceSymbolicLinks(this.h5rootGroup);
        boolean allSharedDimensions = this.makeNetcdfGroup(this.root, this.h5rootGroup);
        if (allSharedDimensions) {
            this.isNetcdf4 = true;
        }
        if (debugTracker) {
            Formatter f = new Formatter();
            this.memTracker.report(f);
            log.debug(f.toString());
        }
        this.debugOut = null;
    }

    private void readSuperBlock1(long superblockStart, byte versionSB) throws IOException {
        long fileSize;
        byte versionFSS = this.raf.readByte();
        byte versionGroup = this.raf.readByte();
        this.raf.readByte();
        byte versionSHMF = this.raf.readByte();
        if (debugDetail) {
            log.debug(" versionSB= " + versionSB + " versionFSS= " + versionFSS + " versionGroup= " + versionGroup + " versionSHMF= " + versionSHMF);
        }
        this.sizeOffsets = this.raf.readByte();
        this.isOffsetLong = this.sizeOffsets == 8;
        this.sizeLengths = this.raf.readByte();
        boolean bl = this.isLengthLong = this.sizeLengths == 8;
        if (debugDetail) {
            log.debug(" sizeOffsets= {} sizeLengths= {}", (Object)this.sizeOffsets, (Object)this.sizeLengths);
            log.debug(" isLengthLong= {} isOffsetLong= {}", (Object)this.isLengthLong, (Object)this.isOffsetLong);
        }
        this.raf.read();
        short btreeLeafNodeSize = this.raf.readShort();
        short btreeInternalNodeSize = this.raf.readShort();
        if (debugDetail) {
            log.debug(" btreeLeafNodeSize= {} btreeInternalNodeSize= {}", (Object)btreeLeafNodeSize, (Object)btreeInternalNodeSize);
        }
        int fileFlags = this.raf.readInt();
        if (debugDetail) {
            log.debug(" fileFlags= 0x{}", (Object)Integer.toHexString(fileFlags));
        }
        if (versionSB == 1) {
            short storageInternalNodeSize = this.raf.readShort();
            this.raf.skipBytes(2);
        }
        this.baseAddress = this.readOffset();
        long heapAddress = this.readOffset();
        long eofAddress = this.readOffset();
        long driverBlockAddress = this.readOffset();
        if (this.baseAddress != superblockStart) {
            this.baseAddress = superblockStart;
            eofAddress += superblockStart;
            if (debugDetail) {
                log.debug(" baseAddress set to superblockStart");
            }
        }
        if (debugDetail) {
            log.debug(" baseAddress= 0x{}", (Object)Long.toHexString(this.baseAddress));
            log.debug(" global free space heap Address= 0x{}", (Object)Long.toHexString(heapAddress));
            log.debug(" eof Address={}", (Object)eofAddress);
            log.debug(" raf length= {}", (Object)this.raf.length());
            log.debug(" driver BlockAddress= 0x{}", (Object)Long.toHexString(driverBlockAddress));
            log.debug("");
        }
        if (debugTracker) {
            this.memTracker.add("superblock", superblockStart, this.raf.getFilePointer());
        }
        if ((fileSize = this.raf.length()) < eofAddress) {
            throw new IOException("File is truncated should be= " + eofAddress + " actual = " + fileSize + "%nlocation= " + this.raf.getLocation());
        }
        this.h5rootGroup = this.h5objects.readRootSymbolTable(this.raf.getFilePointer());
    }

    private void readSuperBlock2(long superblockStart) throws IOException {
        long fileSize;
        this.sizeOffsets = this.raf.readByte();
        this.isOffsetLong = this.sizeOffsets == 8;
        this.sizeLengths = this.raf.readByte();
        boolean bl = this.isLengthLong = this.sizeLengths == 8;
        if (debugDetail) {
            log.debug(" sizeOffsets= {} sizeLengths= {}", (Object)this.sizeOffsets, (Object)this.sizeLengths);
            log.debug(" isLengthLong= {} isOffsetLong= {}", (Object)this.isLengthLong, (Object)this.isOffsetLong);
        }
        byte fileFlags = this.raf.readByte();
        if (debugDetail) {
            log.debug(" fileFlags= 0x{}", (Object)Integer.toHexString(fileFlags));
        }
        this.baseAddress = this.readOffset();
        long extensionAddress = this.readOffset();
        long eofAddress = this.readOffset();
        long rootObjectAddress = this.readOffset();
        int checksum = this.raf.readInt();
        if (debugDetail) {
            log.debug(" baseAddress= 0x{}", (Object)Long.toHexString(this.baseAddress));
            log.debug(" extensionAddress= 0x{}", (Object)Long.toHexString(extensionAddress));
            log.debug(" eof Address={}", (Object)eofAddress);
            log.debug(" rootObjectAddress= 0x{}", (Object)Long.toHexString(rootObjectAddress));
            log.debug("");
        }
        if (debugTracker) {
            this.memTracker.add("superblock", superblockStart, this.raf.getFilePointer());
        }
        if (this.baseAddress != superblockStart) {
            this.baseAddress = superblockStart;
            eofAddress += superblockStart;
            if (debugDetail) {
                log.debug(" baseAddress set to superblockStart");
            }
        }
        if ((fileSize = this.raf.length()) < eofAddress) {
            throw new IOException("File is truncated should be= " + eofAddress + " actual = " + fileSize);
        }
        this.h5rootGroup = this.h5objects.readRootObject(rootObjectAddress);
    }

    private void replaceSymbolicLinks(H5objects.H5Group group) {
        if (group == null) {
            return;
        }
        List<H5objects.DataObjectFacade> objList = group.nestedObjects;
        int count = 0;
        while (count < objList.size()) {
            H5objects.DataObjectFacade dof = objList.get(count);
            if (dof.group != null) {
                this.replaceSymbolicLinks(dof.group);
            } else if (dof.linkName != null) {
                H5objects.DataObjectFacade link = this.symlinkMap.get(dof.linkName);
                if (link == null) {
                    log.warn(" WARNING Didnt find symbolic link={} from {}", (Object)dof.linkName, (Object)dof.name);
                    objList.remove(count);
                    continue;
                }
                if (link.group != null && group.isChildOf(link.group)) {
                    log.warn(" ERROR Symbolic Link loop found ={}", (Object)dof.linkName);
                    objList.remove(count);
                    continue;
                }
                if (dof.parent == link.parent) {
                    objList.remove(dof);
                    --count;
                } else {
                    objList.set(count, link);
                }
                if (debugSoftLink) {
                    log.debug("  Found symbolic link={}", (Object)dof.linkName);
                }
            }
            ++count;
        }
    }

    void addSymlinkMap(String name, H5objects.DataObjectFacade facade) {
        this.symlinkMap.put(name, facade);
    }

    private boolean makeNetcdfGroup(Group.Builder parentGroup, H5objects.H5Group h5group) throws IOException {
        for (H5objects.DataObjectFacade dataObjectFacade : h5group.nestedObjects) {
            if (!dataObjectFacade.isVariable) continue;
            this.findDimensionScales(parentGroup, h5group, dataObjectFacade);
        }
        for (H5objects.DataObjectFacade dataObjectFacade : h5group.nestedObjects) {
            if (!dataObjectFacade.is2DCoordinate) continue;
            this.findDimensionScales2D(h5group, dataObjectFacade);
        }
        boolean allHaveSharedDimensions = true;
        for (H5objects.DataObjectFacade facade : h5group.nestedObjects) {
            if (!facade.isVariable) continue;
            allHaveSharedDimensions &= this.findSharedDimensions(parentGroup, h5group, facade);
        }
        this.createDimensions(parentGroup, h5group);
        for (H5objects.DataObjectFacade facadeNested : h5group.nestedObjects) {
            EnumTypedef enumTypedef;
            if (facadeNested.isGroup) {
                H5objects.H5Group h5groupNested = this.h5objects.readH5Group(facadeNested);
                if (facadeNested.group == null) continue;
                Group.Builder nestedGroup = Group.builder().setName(facadeNested.name);
                parentGroup.addGroup(nestedGroup);
                allHaveSharedDimensions &= this.makeNetcdfGroup(nestedGroup, h5groupNested);
                if (!debug1) continue;
                log.debug("--made Group " + nestedGroup.shortName + " add to " + parentGroup.shortName);
                continue;
            }
            if (facadeNested.isVariable) {
                Variable.Builder v;
                if (debugReference && facadeNested.dobj.mdt.type == 7) {
                    log.debug("{}", (Object)facadeNested);
                }
                if ((v = this.makeVariable(parentGroup, facadeNested)) == null || v.dataType == null) continue;
                parentGroup.addVariable(v);
                if (v.dataType.isEnum()) {
                    EnumTypedef enumTypedef2;
                    String enumTypeName = v.getEnumTypeName();
                    if (enumTypeName == null) {
                        log.warn("EnumTypedef is missing for variable: {}", (Object)v.shortName);
                        throw new IllegalStateException("EnumTypedef is missing for variable: " + v.shortName);
                    }
                    if (enumTypeName.isEmpty() && (enumTypedef2 = (EnumTypedef)parentGroup.findEnumTypedef(facadeNested.name).orElse(null)) == null) {
                        enumTypedef2 = new EnumTypedef(facadeNested.name, facadeNested.dobj.mdt.map);
                        parentGroup.addEnumTypedef(enumTypedef2);
                        v.setEnumTypeName(enumTypedef2.getShortName());
                    }
                }
                Vinfo vinfo = (Vinfo)v.spiObject;
                if (!debugV) continue;
                log.debug("  made Variable " + v.shortName + "  vinfo= " + vinfo + "\n" + v);
                continue;
            }
            if (!facadeNested.isTypedef) continue;
            if (debugReference && facadeNested.dobj.mdt.type == 7) {
                log.debug("{}", (Object)facadeNested);
            }
            if (facadeNested.dobj.mdt.map != null && (enumTypedef = (EnumTypedef)parentGroup.findEnumTypedef(facadeNested.name).orElse(null)) == null) {
                DataType basetype;
                switch (facadeNested.dobj.mdt.byteSize) {
                    case 1: {
                        basetype = DataType.ENUM1;
                        break;
                    }
                    case 2: {
                        basetype = DataType.ENUM2;
                        break;
                    }
                    default: {
                        basetype = DataType.ENUM4;
                    }
                }
                enumTypedef = new EnumTypedef(facadeNested.name, facadeNested.dobj.mdt.map, basetype);
                parentGroup.addEnumTypedef(enumTypedef);
            }
            if (!debugV) continue;
            log.debug("  made enumeration {}", (Object)facadeNested.name);
        }
        List<H5objects.MessageAttribute> list = this.filterAttributes(h5group.facade.dobj.attributes);
        for (H5objects.MessageAttribute matt : list) {
            try {
                this.makeAttributes(null, matt, parentGroup.getAttributeContainer());
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        this.processSystemAttributes(h5group.facade.dobj.messages, parentGroup.getAttributeContainer());
        return allHaveSharedDimensions;
    }

    private void findDimensionScales(Group.Builder g2, H5objects.H5Group h5group, H5objects.DataObjectFacade facade) throws IOException {
        Iterator<H5objects.MessageAttribute> iter = facade.dobj.attributes.iterator();
        while (iter.hasNext()) {
            H5objects.MessageAttribute matt = iter.next();
            if (!matt.name.equals(HDF5_CLASS)) continue;
            Attribute att = this.makeAttribute(matt);
            if (att == null) {
                throw new IllegalStateException();
            }
            String val = att.getStringValue();
            if (!val.equals(HDF5_DIMENSION_SCALE) || facade.dobj.mds.ndims <= 0) continue;
            facade.dimList = this.addDimension(g2, h5group, facade.name, facade.dobj.mds.dimLength[0], facade.dobj.mds.maxLength[0] == -1);
            facade.hasNetcdfDimensions = true;
            if (!this.h5iosp.includeOriginalAttributes) {
                iter.remove();
            }
            if (facade.dobj.mds.ndims <= 1) continue;
            facade.is2DCoordinate = true;
        }
    }

    private void findDimensionScales2D(H5objects.H5Group h5group, H5objects.DataObjectFacade facade) {
        int[] lens = facade.dobj.mds.dimLength;
        if (lens.length > 2) {
            log.warn("DIMENSION_LIST: dimension scale > 2 = {}", (Object)facade.getName());
            return;
        }
        String name = facade.getName();
        int pos = name.lastIndexOf(47);
        String dimName = pos >= 0 ? name.substring(pos + 1) : name;
        StringBuilder sbuff = new StringBuilder();
        sbuff.append(dimName);
        sbuff.append(" ");
        int want_len = lens[1];
        Dimension match = null;
        boolean unique = true;
        for (Dimension d : h5group.dimList) {
            if (d.getLength() != want_len) continue;
            if (match == null) {
                match = d;
                continue;
            }
            unique = false;
        }
        if (match != null && unique) {
            sbuff.append(match.getShortName());
        } else if (match == null) {
            log.warn("DIMENSION_LIST: dimension scale {} has second dimension {} but no match", (Object)facade.getName(), (Object)want_len);
            sbuff.append(want_len);
        } else {
            log.warn("DIMENSION_LIST: dimension scale {} has second dimension {} but multiple matches", (Object)facade.getName(), (Object)want_len);
            sbuff.append(want_len);
        }
        facade.dimList = sbuff.toString();
    }

    private boolean findSharedDimensions(Group.Builder g2, H5objects.H5Group h5group, H5objects.DataObjectFacade facade) throws IOException {
        Iterator<H5objects.MessageAttribute> iter = facade.dobj.attributes.iterator();
        block10: while (iter.hasNext()) {
            H5objects.MessageAttribute matt = iter.next();
            switch (matt.name) {
                case "DIMENSION_LIST": {
                    Attribute att = this.makeAttribute(matt);
                    if (att == null) {
                        log.warn("DIMENSION_LIST: failed to read on variable {}", (Object)facade.getName());
                        break;
                    }
                    if (att.getLength() != facade.dobj.mds.dimLength.length) {
                        log.warn("DIMENSION_LIST: must have same number of dimension scales as dimensions att={} on variable {}", (Object)att, (Object)facade.getName());
                        break;
                    }
                    StringBuilder sbuff = new StringBuilder();
                    for (int i = 0; i < att.getLength(); ++i) {
                        String name = att.getStringValue(i);
                        String dimName = this.extendDimension(g2, h5group, name, facade.dobj.mds.dimLength[i]);
                        sbuff.append(dimName).append(" ");
                    }
                    facade.dimList = sbuff.toString();
                    facade.hasNetcdfDimensions = true;
                    if (debugDimensionScales) {
                        log.debug("Found dimList '{}' for group '{}' matt={}", facade.dimList, g2.shortName, matt);
                    }
                    if (this.h5iosp.includeOriginalAttributes) continue block10;
                    iter.remove();
                    break;
                }
                case "NAME": {
                    Attribute att = this.makeAttribute(matt);
                    if (att == null) {
                        throw new IllegalStateException();
                    }
                    String val = att.getStringValue();
                    if (val.startsWith("This is a netCDF dimension but not a netCDF variable")) {
                        facade.isVariable = false;
                        this.isNetcdf4 = true;
                    }
                    if (!this.h5iosp.includeOriginalAttributes) {
                        iter.remove();
                    }
                    if (!debugDimensionScales) break;
                    log.debug("Found {}", (Object)val);
                    break;
                }
                case "REFERENCE_LIST": {
                    if (this.h5iosp.includeOriginalAttributes) break;
                    iter.remove();
                }
            }
        }
        return facade.hasNetcdfDimensions || facade.dobj.mds.dimLength.length == 0;
    }

    private String addDimension(Group.Builder parent, H5objects.H5Group h5group, String name, int length, boolean isUnlimited) {
        int pos = name.lastIndexOf(47);
        String dimName = pos >= 0 ? name.substring(pos + 1) : name;
        Dimension d = h5group.dimMap.get(dimName);
        if (d == null) {
            d = Dimension.builder().setName(name).setIsUnlimited(isUnlimited).setLength(length).build();
            h5group.dimMap.put(dimName, d);
            h5group.dimList.add(d);
            parent.addDimension(d);
            if (debugDimensionScales) {
                log.debug("addDimension name=" + name + " dim= " + d + " to group " + parent.shortName);
            }
        } else if (d.getLength() != length) {
            throw new IllegalStateException("addDimension: DimScale has different length than dimension it references dimScale=" + dimName);
        }
        return d.getShortName();
    }

    private String extendDimension(Group.Builder parent, H5objects.H5Group h5group, String name, int length) {
        int pos = name.lastIndexOf(47);
        String dimName = pos >= 0 ? name.substring(pos + 1) : name;
        Dimension d = h5group.dimMap.get(dimName);
        if (d == null) {
            d = parent.findDimension(dimName).orElse(null);
        }
        if (d != null) {
            if (d.isUnlimited() && length > d.getLength()) {
                parent.replaceDimension(d.toBuilder().setLength(length).build());
            }
            if (!d.isUnlimited() && length != d.getLength()) {
                throw new IllegalStateException("extendDimension: DimScale has different length than dimension it references dimScale=" + dimName);
            }
            return d.getShortName();
        }
        return dimName;
    }

    private void createDimensions(Group.Builder g2, H5objects.H5Group h5group) {
        for (Dimension d : h5group.dimList) {
            g2.addDimensionIfNotExists(d);
        }
    }

    private List<H5objects.MessageAttribute> filterAttributes(List<H5objects.MessageAttribute> attList) {
        ArrayList<H5objects.MessageAttribute> result = new ArrayList<H5objects.MessageAttribute>(attList.size());
        for (H5objects.MessageAttribute matt : attList) {
            if (matt.name.equals("_Netcdf4Coordinates") || matt.name.equals("_Netcdf4Dimid") || matt.name.equals("_nc3_strict")) {
                this.isNetcdf4 = true;
                continue;
            }
            result.add(matt);
        }
        return result;
    }

    private void makeAttributes(Structure.Builder<?> sb, H5objects.MessageAttribute matt, AttributeContainerMutable attContainer) throws IOException, InvalidRangeException {
        H5objects.MessageDatatype mdt = matt.mdt;
        if (mdt.type == 6) {
            Vinfo vinfo = new Vinfo(matt.mdt, matt.mds, matt.dataPos);
            ArrayStructure attData = (ArrayStructure)this.readAttributeData(matt, vinfo, DataType.STRUCTURE);
            if (null == sb) {
                for (StructureMembers.Member sm : attData.getStructureMembers().getMembers()) {
                    Array memberData = attData.extractMemberArray(sm);
                    attContainer.addAttribute(new Attribute(matt.name + "." + sm.getName(), memberData));
                }
            } else if (matt.name.equals("_field_atts")) {
                for (StructureMembers.Member sm : attData.getStructureMembers().getMembers()) {
                    String memberName = sm.getName();
                    int pos = memberName.indexOf(":");
                    if (pos < 0) continue;
                    String fldName = memberName.substring(0, pos);
                    String attName = memberName.substring(pos + 1);
                    Array memberData = attData.extractMemberArray(sm);
                    sb.findMemberVariable(fldName).ifPresent(vb -> vb.getAttributeContainer().addAttribute(new Attribute(attName, memberData)));
                }
            } else {
                Array memberData;
                StructureMembers attMembers = attData.getStructureMembers();
                for (Variable.Builder<?> v : sb.vbuilders) {
                    StructureMembers.Member sm = attMembers.findMember(v.shortName);
                    if (null == sm) continue;
                    memberData = attData.extractMemberArray(sm);
                    v.addAttribute(new Attribute(matt.name, memberData));
                }
                for (StructureMembers.Member sm : attData.getStructureMembers().getMembers()) {
                    Variable.Builder vb2 = sb.findMemberVariable(sm.getName()).orElse(null);
                    if (vb2 != null) continue;
                    memberData = attData.extractMemberArray(sm);
                    attContainer.addAttribute(new Attribute(matt.name + "." + sm.getName(), memberData));
                }
            }
        } else {
            Attribute att = this.makeAttribute(matt);
            if (att != null) {
                attContainer.addAttribute(att);
            }
        }
        this.raf.order(1);
    }

    private Attribute makeAttribute(H5objects.MessageAttribute matt) throws IOException {
        Attribute result;
        Array attData;
        Vinfo vinfo = new Vinfo(matt.mdt, matt.mds, matt.dataPos);
        DataType dtype = vinfo.getNCDataType();
        if (matt.mds.type == 2) {
            if (dtype == DataType.CHAR) {
                return new Attribute(matt.name, DataType.STRING);
            }
            return new Attribute(matt.name, dtype);
        }
        try {
            attData = this.readAttributeData(matt, vinfo, dtype);
        }
        catch (InvalidRangeException e) {
            log.warn("failed to read Attribute " + matt.name + " HDF5 file=" + this.raf.getLocation());
            return null;
        }
        if (attData.isVlen()) {
            ArrayList<Object> dataList = new ArrayList<Object>();
            while (attData.hasNext()) {
                Array nested = (Array)attData.next();
                while (nested.hasNext()) {
                    dataList.add(nested.next());
                }
            }
            result = new Attribute(matt.name, dataList, matt.mdt.unsigned);
        } else {
            result = new Attribute(matt.name, attData);
        }
        this.raf.order(1);
        return result;
    }

    private Array readAttributeData(H5objects.MessageAttribute matt, Vinfo vinfo, DataType dataType) throws IOException, InvalidRangeException {
        Array dataArray;
        int[] shape = matt.mds.dimLength;
        if (dataType == DataType.STRUCTURE) {
            boolean hasStrings = false;
            StructureMembers.Builder builder = StructureMembers.builder().setName(matt.name);
            for (H5objects.StructureMember h5sm : matt.mdt.members) {
                int[] dim;
                DataType dt;
                switch (h5sm.mdt.type) {
                    case 9: {
                        dt = DataType.STRING;
                        dim = new int[]{1};
                        break;
                    }
                    case 10: {
                        dt = this.getNCtype(h5sm.mdt.base.type, h5sm.mdt.base.byteSize, h5sm.mdt.unsigned);
                        dim = h5sm.mdt.dim;
                        break;
                    }
                    default: {
                        dt = this.getNCtype(h5sm.mdt.type, h5sm.mdt.byteSize, h5sm.mdt.unsigned);
                        dim = new int[]{1};
                    }
                }
                StructureMembers.MemberBuilder mb = builder.addMember(h5sm.name, null, null, dt, dim);
                if (h5sm.mdt.endian >= 0) {
                    mb.setDataObject(h5sm.mdt.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                }
                mb.setDataParam(h5sm.offset);
                if (dt != DataType.STRING) continue;
                hasStrings = true;
            }
            int recsize = matt.mdt.byteSize;
            LayoutRegular layout = new LayoutRegular(matt.dataPos, recsize, shape, new Section(shape));
            builder.setStructureSize(recsize);
            StructureMembers sm = builder.build();
            ArrayStructureBB asbb = new ArrayStructureBB(sm, shape);
            byte[] byteArray = asbb.getByteBuffer().array();
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                if (debugStructure) {
                    log.debug(" readStructure " + matt.name + " chunk= " + chunk + " index.getElemSize= " + layout.getElemSize());
                }
                this.raf.seek(chunk.getSrcPos());
                this.raf.readFully(byteArray, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            if (hasStrings) {
                int destPos = 0;
                int i = 0;
                while ((long)i < layout.getTotalNelems()) {
                    this.h5iosp.convertHeap(asbb, destPos, sm);
                    destPos += layout.getElemSize();
                    ++i;
                }
            }
            return asbb;
        }
        if (vinfo.typeInfo.hdfType == 9 && vinfo.typeInfo.isVString) {
            LayoutRegular layout = new LayoutRegular(matt.dataPos, matt.mdt.byteSize, shape, new Section(shape));
            ArrayObject.D1 data = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{(int)layout.getTotalNelems()});
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    String sval = this.readHeapString(address);
                    data.set(count++, sval);
                }
            }
            return data;
        }
        if (vinfo.typeInfo.hdfType == 9) {
            LayoutRegular layout;
            int endian = vinfo.typeInfo.endian;
            DataType readType = dataType;
            if (vinfo.typeInfo.base.hdfType == 7) {
                readType = DataType.LONG;
                endian = 1;
            }
            boolean scalar = (layout = new LayoutRegular(matt.dataPos, matt.mdt.byteSize, shape, new Section(shape))).getTotalNelems() == 1L;
            Array[] data = new Array[(int)layout.getTotalNelems()];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    Array vlenArray = this.getHeapDataArray(address, readType, endian);
                    data[count++] = vinfo.typeInfo.base.hdfType == 7 ? this.h5iosp.convertReference(vlenArray) : vlenArray;
                }
            }
            return scalar ? data[0] : Array.makeVlenArray(shape, data);
        }
        DataType readDtype = dataType;
        int elemSize = dataType.getSize();
        int endian = vinfo.typeInfo.endian;
        if (vinfo.typeInfo.hdfType == 2) {
            readDtype = vinfo.mdt.timeType;
            elemSize = readDtype.getSize();
        } else if (vinfo.typeInfo.hdfType == 3) {
            if (vinfo.mdt.byteSize > 1) {
                int[] newShape = new int[shape.length + 1];
                System.arraycopy(shape, 0, newShape, 0, shape.length);
                newShape[shape.length] = vinfo.mdt.byteSize;
                shape = newShape;
            }
        } else if (vinfo.typeInfo.hdfType == 5) {
            elemSize = vinfo.mdt.byteSize;
        } else if (vinfo.typeInfo.hdfType == 8) {
            TypeInfo baseInfo = vinfo.typeInfo.base;
            readDtype = baseInfo.dataType;
            elemSize = readDtype.getSize();
            endian = baseInfo.endian;
        }
        LayoutRegular layout = new LayoutRegular(matt.dataPos, elemSize, shape, new Section(shape));
        Object data = this.h5iosp.readDataPrimitive(layout, dataType, shape, null, endian, false);
        if (dataType == DataType.CHAR) {
            if (vinfo.mdt.byteSize > 1) {
                byte[] bdata = (byte[])data;
                int strlen = vinfo.mdt.byteSize;
                int n = bdata.length / strlen;
                ArrayObject.D1 sarray = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{n});
                for (int i = 0; i < n; ++i) {
                    String sval = this.convertString(bdata, i * strlen, strlen);
                    sarray.set(i, sval);
                }
                dataArray = sarray;
            } else {
                String sval = this.convertString((byte[])data);
                ArrayObject.D1 sarray = (ArrayObject.D1)Array.factory(DataType.STRING, new int[]{1});
                sarray.set(0, sval);
                dataArray = sarray;
            }
        } else {
            Array array = dataArray = data instanceof Array ? (Array)data : Array.factory(readDtype, shape, data);
        }
        if (vinfo.typeInfo.hdfType == 8 && matt.mdt.map != null) {
            dataArray = this.convertEnums(matt.mdt.map, dataType, dataArray);
        }
        return dataArray;
    }

    private String convertString(byte[] b) {
        int count;
        for (count = 0; count < b.length && b[count] != 0; ++count) {
        }
        return new String(b, 0, count, this.valueCharset);
    }

    private String convertString(byte[] b, int start, int len) {
        int count;
        for (count = start; count < start + len && b[count] != 0; ++count) {
        }
        return new String(b, start, count - start, this.valueCharset);
    }

    protected Array convertEnums(Map<Integer, String> map, DataType dataType, Array values) {
        Array result = Array.factory(DataType.STRING, values.getShape());
        IndexIterator ii = result.getIndexIterator();
        values.resetLocalIterator();
        while (values.hasNext()) {
            int ival = dataType == DataType.ENUM1 ? DataType.unsignedByteToShort(values.nextByte()) : (dataType == DataType.ENUM2 ? DataType.unsignedShortToInt(values.nextShort()) : values.nextInt());
            String sval = map.get(ival);
            if (sval == null) {
                sval = "Unknown enum value=" + ival;
            }
            ii.setObjectNext(sval);
        }
        return result;
    }

    private Variable.Builder makeVariable(Group.Builder parentGroup, H5objects.DataObjectFacade facade) throws IOException {
        String desc;
        Structure.Builder<Object> vb;
        String vname;
        Vinfo vinfo = new Vinfo(facade);
        if (vinfo.getNCDataType() == null) {
            log.debug("SKIPPING DataType= " + vinfo.typeInfo.hdfType + " for variable " + facade.name);
            return null;
        }
        if (facade.dobj.mfp != null) {
            for (H5objects.Filter f : facade.dobj.mfp.filters) {
                if (f.id != 4) continue;
                log.debug("SKIPPING variable with SZIP Filter= " + facade.dobj.mfp + " for variable " + facade.name);
                return null;
            }
        }
        Attribute fillAttribute = null;
        for (H5objects.HeaderMessage mess : facade.dobj.messages) {
            Number defFillValue;
            Object fillValue;
            H5objects.Named fvm;
            if (mess.mtype == H5objects.MessageType.FillValue) {
                fvm = (H5objects.MessageFillValue)mess.messData;
                if (fvm.hasFillValue) {
                    vinfo.fillValue = fvm.value;
                }
            } else if (mess.mtype == H5objects.MessageType.FillValueOld) {
                fvm = (H5objects.MessageFillValueOld)mess.messData;
                if (((H5objects.MessageFillValueOld)fvm).size > 0) {
                    vinfo.fillValue = ((H5objects.MessageFillValueOld)fvm).value;
                }
            }
            if ((fillValue = vinfo.getFillValueNonDefault()) == null || fillValue.equals(defFillValue = N3iosp.getFillValueDefault(vinfo.typeInfo.dataType))) continue;
            fillAttribute = new Attribute("_FillValue", (Number)fillValue, vinfo.typeInfo.unsigned);
        }
        long dataAddress = facade.dobj.msl.dataAddress;
        if (dataAddress == -1L) {
            vinfo.useFillValue = true;
            if (vinfo.fillValue == null) {
                vinfo.fillValue = new byte[vinfo.typeInfo.dataType.getSize()];
            }
        }
        Structure.Builder sb = null;
        if (facade.dobj.mdt.type == 6) {
            vname = facade.name;
            sb = (Structure.Builder)Structure.builder().setName(vname);
            vb = sb;
            vb.setParentGroupBuilder(parentGroup);
            if (!this.makeVariableShapeAndType(parentGroup, sb, facade.dobj.mdt, facade.dobj.mds, vinfo, facade.dimList)) {
                return null;
            }
            this.addMembersToStructure(parentGroup, sb, facade.dobj.mdt);
            sb.setElementSize(facade.dobj.mdt.byteSize);
        } else {
            vname = facade.name;
            if (vname.startsWith("_nc4_non_coord_")) {
                vname = vname.substring("_nc4_non_coord_".length());
            }
            vb = Variable.builder().setName(vname);
            vb.setParentGroupBuilder(parentGroup);
            if (!this.makeVariableShapeAndType(parentGroup, vb, facade.dobj.mdt, facade.dobj.mds, vinfo, facade.dimList)) {
                return null;
            }
            if (vb.dataType == DataType.STRING) {
                vb.setElementSize(16);
            } else if (vb.dataType == DataType.OPAQUE) {
                vb.setElementSize(facade.dobj.mdt.getBaseSize());
            }
        }
        vb.setSPobject(vinfo);
        List<H5objects.MessageAttribute> fatts = this.filterAttributes(facade.dobj.attributes);
        for (H5objects.MessageAttribute matt : fatts) {
            try {
                this.makeAttributes(sb, matt, vb.getAttributeContainer());
            }
            catch (InvalidRangeException e) {
                throw new IOException(e.getMessage());
            }
        }
        AttributeContainerMutable atts = vb.getAttributeContainer();
        this.processSystemAttributes(facade.dobj.messages, atts);
        if (fillAttribute != null && atts.findAttribute("_FillValue") == null) {
            vb.addAttribute(fillAttribute);
        }
        if (facade.dobj.mdt.type == 5 && (desc = facade.dobj.mdt.opaque_desc) != null && !desc.isEmpty()) {
            vb.addAttribute(new Attribute("_opaqueDesc", desc));
        }
        int[] shape = this.makeVariableShape(facade.dobj.mdt, facade.dobj.mds, facade.dimList);
        if (vinfo.isChunked) {
            vinfo.btree = new DataBTree(this, dataAddress, shape, vinfo.storageSize, this.memTracker);
            if (vinfo.isChunked) {
                ArrayList<Object> chunksize = new ArrayList<Object>();
                for (int i = 0; i < vinfo.storageSize.length - 1; ++i) {
                    chunksize.add(vinfo.storageSize[i]);
                }
                vb.addAttribute(Attribute.builder("_ChunkSizes").setValues(chunksize, true).build());
            }
        }
        if (facade.dobj.mdt.type == 7 && facade.dobj.mdt.referenceType == 0) {
            vb.setDataType(DataType.STRING);
            Array rawData = vinfo.readArray();
            Array refData = this.findReferenceObjectNames(rawData);
            vb.setCachedData(refData, true);
            vb.addAttribute(new Attribute("_HDF5ReferenceType", "values are names of referenced Variables"));
        }
        if (facade.dobj.mdt.type == 7 && facade.dobj.mdt.referenceType == 1) {
            if (warnings) {
                log.warn("transform region Reference: facade=" + facade.name + " variable name=" + vb.shortName);
            }
            vb.setDataType(DataType.LONG);
            Array newData = Array.factory(DataType.LONG, shape);
            vb.setCachedData(newData, true);
            vb.addAttribute(new Attribute("_HDF5ReferenceType", "values are regions of referenced Variables"));
        }
        vinfo.setOwner(vb);
        if (vinfo.mfp != null && warnings) {
            for (H5objects.Filter f : vinfo.mfp.getFilters()) {
                if (f.id <= 3) continue;
                log.warn("  Variable " + facade.name + " has unknown Filter(s) = " + vinfo.mfp);
                break;
            }
        }
        if (debug1) {
            log.debug("makeVariable " + vb.shortName + "; vinfo= " + vinfo);
        }
        return vb;
    }

    private Array findReferenceObjectNames(Array data) throws IOException {
        IndexIterator ii = data.getIndexIterator();
        Array newData = Array.factory(DataType.STRING, data.getShape());
        IndexIterator ii2 = newData.getIndexIterator();
        while (ii.hasNext()) {
            long objId = ii.getLongNext();
            H5objects.DataObject dobj = this.getDataObject(objId, null);
            if (dobj == null) {
                log.warn("readReferenceObjectNames cant find obj= {}", (Object)objId);
                continue;
            }
            if (debugReference) {
                log.debug(" Referenced object= {}", (Object)dobj.who);
            }
            ii2.setObjectNext(dobj.who);
        }
        return newData;
    }

    private void addMembersToStructure(Group.Builder parent, Structure.Builder<?> s2, H5objects.MessageDatatype mdt) throws IOException {
        for (H5objects.StructureMember m3 : mdt.members) {
            Variable.Builder v = this.makeVariableMember(parent, m3.name, m3.offset, m3.mdt);
            if (v == null) continue;
            s2.addMemberVariable(v);
            if (!debug1) continue;
            log.debug("  made Member Variable " + v.shortName + "\n" + v);
        }
    }

    private Variable.Builder makeVariableMember(Group.Builder parentGroup, String name, long dataPos, H5objects.MessageDatatype mdt) throws IOException {
        Vinfo vinfo = new Vinfo(mdt, null, dataPos);
        if (vinfo.getNCDataType() == null) {
            log.debug("SKIPPING DataType= " + vinfo.typeInfo.hdfType + " for variable " + name);
            return null;
        }
        if (mdt.type == 6) {
            Structure.Builder sb = (Structure.Builder)((Structure.Builder)Structure.builder().setName(name)).setParentGroupBuilder(parentGroup);
            this.makeVariableShapeAndType(parentGroup, sb, mdt, null, vinfo, null);
            this.addMembersToStructure(parentGroup, sb, mdt);
            sb.setElementSize(mdt.byteSize);
            sb.setSPobject(vinfo);
            vinfo.setOwner(sb);
            return sb;
        }
        Object vb = ((Variable.Builder)Variable.builder().setName(name)).setParentGroupBuilder(parentGroup);
        this.makeVariableShapeAndType(parentGroup, (Variable.Builder)vb, mdt, null, vinfo, null);
        if (((Variable.Builder)vb).dataType == DataType.STRING) {
            ((Variable.Builder)vb).setElementSize(16);
        } else if (((Variable.Builder)vb).dataType == DataType.OPAQUE) {
            ((Variable.Builder)vb).setElementSize(mdt.getBaseSize());
        }
        ((Variable.Builder)vb).setSPobject(vinfo);
        vinfo.setOwner((Variable.Builder)vb);
        return vb;
    }

    private void processSystemAttributes(List<H5objects.HeaderMessage> messages, AttributeContainer attContainer) {
        for (H5objects.HeaderMessage mess : messages) {
            if (mess.mtype != H5objects.MessageType.Comment) continue;
            H5objects.MessageComment m3 = (H5objects.MessageComment)mess.messData;
            attContainer.addAttribute(new Attribute("_comment", m3.comment));
        }
    }

    private SimpleDateFormat getHdfDateFormatter() {
        if (this.hdfDateParser == null) {
            this.hdfDateParser = new SimpleDateFormat("yyyyMMddHHmmss");
            this.hdfDateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        return this.hdfDateParser;
    }

    private int[] makeVariableShape(H5objects.MessageDatatype mdt, H5objects.MessageDataspace msd, String dimNames) {
        int[] shape;
        int[] nArray = shape = msd != null ? msd.dimLength : new int[]{};
        if (shape == null) {
            shape = new int[]{};
        }
        if (mdt.type == 10) {
            int len = shape.length + mdt.dim.length;
            if (mdt.isVlen()) {
                ++len;
            }
            int[] combinedDim = new int[len];
            System.arraycopy(shape, 0, combinedDim, 0, shape.length);
            System.arraycopy(mdt.dim, 0, combinedDim, shape.length, mdt.dim.length);
            if (mdt.isVlen()) {
                combinedDim[len - 1] = -1;
            }
            shape = combinedDim;
        }
        if (dimNames == null) {
            if (mdt.type == 3) {
                if (mdt.byteSize != 1) {
                    int[] rshape = new int[shape.length + 1];
                    System.arraycopy(shape, 0, rshape, 0, shape.length);
                    rshape[shape.length] = mdt.byteSize;
                    return rshape;
                }
            } else if (mdt.isVlen()) {
                if (shape.length == 1 && shape[0] == 1) {
                    return new int[]{-1};
                }
                if (mdt.type != 10) {
                    int[] rshape = new int[shape.length + 1];
                    System.arraycopy(shape, 0, rshape, 0, shape.length);
                    rshape[shape.length] = -1;
                    return rshape;
                }
            }
        }
        return shape;
    }

    private boolean makeVariableShapeAndType(Group.Builder parent, Variable.Builder v, H5objects.MessageDatatype mdt, H5objects.MessageDataspace msd, Vinfo vinfo, String dimNames) {
        int[] shape = this.makeVariableShape(mdt, msd, dimNames);
        if (dimNames != null) {
            if (mdt.type == 9 && !mdt.isVString) {
                v.setDimensionsByName(dimNames + " *");
            } else {
                v.setDimensionsByName(dimNames);
            }
        } else {
            v.setDimensionsAnonymous(shape);
        }
        DataType dt = vinfo.getNCDataType();
        if (dt == null) {
            return false;
        }
        v.setDataType(dt);
        if (dt.isEnum()) {
            EnumTypedef enumTypedef = parent.findEnumTypedef(mdt.enumTypeName).orElse(null);
            if (enumTypedef == null) {
                enumTypedef = new EnumTypedef(mdt.enumTypeName, mdt.map);
                parent.addEnumTypedef(enumTypedef);
            }
            v.setEnumTypeName(enumTypedef.getShortName());
        }
        return true;
    }

    @Override
    public Group.Builder getRootGroup() {
        return this.root;
    }

    @Override
    public void makeVinfoForDimensionMapVariable(Group.Builder parent, Variable.Builder<?> v) {
        Vinfo vinfo = new Vinfo();
        vinfo.owner = v;
    }

    @Override
    public String readStructMetadata(Variable.Builder<?> structMetadataVar) throws IOException {
        Vinfo vinfo = (Vinfo)structMetadataVar.spiObject;
        return vinfo.readString();
    }

    DataType getNCtype(int hdfType, int size, boolean unsigned) {
        if (hdfType == 0 || hdfType == 4) {
            DataType.Signedness signedness;
            DataType.Signedness signedness2 = signedness = unsigned ? DataType.Signedness.UNSIGNED : DataType.Signedness.SIGNED;
            if (size == 1) {
                return DataType.BYTE.withSignedness(signedness);
            }
            if (size == 2) {
                return DataType.SHORT.withSignedness(signedness);
            }
            if (size == 4) {
                return DataType.INT.withSignedness(signedness);
            }
            if (size == 8) {
                return DataType.LONG.withSignedness(signedness);
            }
            if (warnings) {
                log.debug("WARNING HDF5 file " + this.raf.getLocation() + " not handling hdf integer type (" + hdfType + ") with size= " + size);
                log.warn("HDF5 file " + this.raf.getLocation() + " not handling hdf integer type (" + hdfType + ") with size= " + size);
                return null;
            }
        } else if (hdfType == 1) {
            if (size == 4) {
                return DataType.FLOAT;
            }
            if (size == 8) {
                return DataType.DOUBLE;
            }
            if (warnings) {
                log.debug("WARNING HDF5 file " + this.raf.getLocation() + " not handling hdf float type with size= " + size);
                log.warn("HDF5 file " + this.raf.getLocation() + " not handling hdf float type with size= " + size);
                return null;
            }
        } else {
            if (hdfType == 3) {
                return DataType.CHAR;
            }
            if (hdfType == 6) {
                return DataType.STRUCTURE;
            }
            if (hdfType == 7) {
                return DataType.ULONG;
            }
            if (hdfType == 9) {
                return null;
            }
            if (warnings) {
                log.debug("WARNING not handling hdf type = " + hdfType + " size= " + size);
                log.warn("HDF5 file " + this.raf.getLocation() + " not handling hdf type = " + hdfType + " size= " + size);
            }
        }
        return null;
    }

    Array getHeapDataArray(long globalHeapIdAddress, DataType dataType, int endian) throws IOException, InvalidRangeException {
        H5objects.HeapIdentifier heapId = this.h5objects.readHeapIdentifier(globalHeapIdAddress);
        if (debugHeap) {
            log.debug(" heapId= {}", (Object)heapId);
        }
        return this.getHeapDataArray(heapId, dataType, endian);
    }

    Array getHeapDataArray(H5objects.HeapIdentifier heapId, DataType dataType, int endian) throws IOException, InvalidRangeException {
        H5objects.GlobalHeap.HeapObject ho = heapId.getHeapObject();
        if (ho == null) {
            throw new InvalidRangeException("Illegal Heap address, HeapObject = " + heapId);
        }
        if (debugHeap) {
            log.debug(" HeapObject= {}", (Object)ho);
        }
        if (endian >= 0) {
            this.raf.order(endian);
        }
        if (DataType.FLOAT == dataType) {
            float[] pa = new float[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFloat(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (DataType.DOUBLE == dataType) {
            double[] pa = new double[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readDouble(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE) {
            byte[] pa = new byte[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readFully(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = new short[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readShort(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = new int[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readInt(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = new long[heapId.nelems];
            this.raf.seek(ho.dataPos);
            this.raf.readLong(pa, 0, pa.length);
            return Array.factory(dataType, new int[]{pa.length}, (Object)pa);
        }
        throw new UnsupportedOperationException("getHeapDataAsArray dataType=" + (Object)((Object)dataType));
    }

    String readHeapString(long heapIdAddress) throws IOException {
        H5objects.HeapIdentifier heapId = this.h5objects.readHeapIdentifier(heapIdAddress);
        H5objects.GlobalHeap.HeapObject ho = heapId.getHeapObject();
        if (ho == null) {
            throw new IllegalStateException("Cant find Heap Object,heapId=" + heapId);
        }
        if (ho.dataSize > 1000000L) {
            return String.format("Bad HeapObject.dataSize=%s", ho);
        }
        this.raf.seek(ho.dataPos);
        return this.raf.readString((int)ho.dataSize, this.valueCharset);
    }

    String readHeapString(ByteBuffer bb, int pos) throws IOException {
        H5objects.HeapIdentifier heapId = this.h5objects.readHeapIdentifier(bb, pos);
        H5objects.GlobalHeap.HeapObject ho = heapId.getHeapObject();
        if (ho == null) {
            throw new IllegalStateException("Cant find Heap Object,heapId=" + heapId);
        }
        this.raf.seek(ho.dataPos);
        return this.raf.readString((int)ho.dataSize, this.valueCharset);
    }

    Array readHeapVlen(ByteBuffer bb, int pos, DataType dataType, int endian) throws IOException, InvalidRangeException {
        H5objects.HeapIdentifier heapId = this.h5objects.readHeapIdentifier(bb, pos);
        return this.getHeapDataArray(heapId, dataType, endian);
    }

    String getDataObjectName(long objId) throws IOException {
        H5objects.DataObject dobj = this.getDataObject(objId, null);
        if (dobj == null) {
            log.error("H5iosp.readVlenData cant find dataObject id= {}", (Object)objId);
            return null;
        }
        if (debugVlen) {
            log.debug(" Referenced object= {}", (Object)dobj.who);
        }
        return dobj.who;
    }

    H5objects.DataObject getDataObject(long address, String name) throws IOException {
        H5objects.DataObject dobj = this.addressMap.get(address);
        if (dobj != null) {
            if (dobj.who == null && name != null) {
                dobj.who = name;
            }
            return dobj;
        }
        dobj = this.h5objects.readDataObject(address, name);
        this.addressMap.put(address, dobj);
        return dobj;
    }

    @Override
    public int makeIntFromBytes(byte[] bb, int start, int n) {
        int result = 0;
        for (int i = start + n - 1; i >= start; --i) {
            result <<= 8;
            int b = bb[i];
            result += b < 0 ? b + 256 : b;
        }
        return result;
    }

    @Override
    public boolean isOffsetLong() {
        return this.isOffsetLong;
    }

    @Override
    public long readLength() throws IOException {
        return this.isLengthLong ? this.raf.readLong() : (long)this.raf.readInt();
    }

    @Override
    public long readOffset() throws IOException {
        return this.isOffsetLong ? this.raf.readLong() : (long)this.raf.readInt();
    }

    @Override
    public long readAddress() throws IOException {
        return this.getFileOffset(this.readOffset());
    }

    @Override
    public byte getSizeLengths() {
        return this.sizeLengths;
    }

    @Override
    public int getNumBytesFromMax(long maxNumber) {
        int size = 0;
        while (maxNumber != 0L) {
            ++size;
            maxNumber >>>= 8;
        }
        return size;
    }

    @Override
    public long readVariableSizeUnsigned(int size) throws IOException {
        long vv;
        if (size == 1) {
            vv = DataType.unsignedByteToShort(this.raf.readByte());
        } else if (size == 2) {
            if (debugPos) {
                log.debug("position={}", (Object)this.raf.getFilePointer());
            }
            short s2 = this.raf.readShort();
            vv = DataType.unsignedShortToInt(s2);
        } else {
            vv = size == 4 ? DataType.unsignedIntToLong(this.raf.readInt()) : (size == 8 ? this.raf.readLong() : this.readVariableSizeN(size));
        }
        return vv;
    }

    private long readVariableSizeN(int nbytes) throws IOException {
        int[] ch = new int[nbytes];
        for (int i = 0; i < nbytes; ++i) {
            ch[i] = this.raf.read();
        }
        long result = ch[nbytes - 1];
        for (int i = nbytes - 2; i >= 0; --i) {
            result <<= 8;
            result += (long)ch[i];
        }
        return result;
    }

    @Override
    public RandomAccessFile getRandomAccessFile() {
        return this.raf;
    }

    @Override
    public long getFileOffset(long address) {
        return this.baseAddress + address;
    }

    @Override
    public byte getSizeOffsets() {
        return this.sizeOffsets;
    }

    boolean isNetcdf4() {
        return this.isNetcdf4;
    }

    public void close() {
        if (debugTracker) {
            Formatter f = new Formatter();
            this.memTracker.report(f);
            log.debug("{}", (Object)f);
        }
    }

    public void getEosInfo(Formatter f) throws IOException {
        HdfEos.getEosInfo(this.raf.getLocation(), this, this.root, f);
    }

    public List<H5objects.DataObject> getDataObjects() {
        ArrayList<H5objects.DataObject> result = new ArrayList<H5objects.DataObject>(this.addressMap.values());
        result.sort((o1, o2) -> Long.compare(o1.address, o2.address));
        return result;
    }

    static {
        warnings = true;
        magic = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
        magicString = new String(magic, StandardCharsets.UTF_8);
    }

    public static class TypeInfo {
        int hdfType;
        int byteSize;
        DataType dataType;
        int endian = -1;
        boolean unsigned;
        boolean isVString;
        boolean isVlen;
        int vpad;
        TypeInfo base;

        TypeInfo(int hdfType, int byteSize) {
            this.hdfType = hdfType;
            this.byteSize = byteSize;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("hdfType=").append(this.hdfType).append(" byteSize=").append(this.byteSize).append(" dataType=").append((Object)this.dataType);
            buff.append(" unsigned=").append(this.unsigned).append(" isVString=").append(this.isVString).append(" vpad=").append(this.vpad).append(" endian=").append(this.endian);
            if (this.base != null) {
                buff.append("\n   base=").append(this.base);
            }
            return buff.toString();
        }
    }

    public class Vinfo {
        Variable.Builder owner;
        H5objects.DataObjectFacade facade;
        long dataPos;
        TypeInfo typeInfo;
        int[] storageSize;
        boolean isvlen;
        boolean isChunked;
        DataBTree btree;
        H5objects.MessageDatatype mdt;
        H5objects.MessageDataspace mds;
        H5objects.MessageFilter mfp;
        boolean useFillValue;
        byte[] fillValue;

        public String getCompression() {
            if (this.mfp == null) {
                return null;
            }
            Formatter f = new Formatter();
            for (H5objects.Filter filt : this.mfp.filters) {
                f.format("%s ", filt.name);
            }
            return f.toString();
        }

        public int[] getChunking() {
            return this.storageSize;
        }

        public boolean isChunked() {
            return this.isChunked;
        }

        public boolean useFillValue() {
            return this.useFillValue;
        }

        public long[] countStorageSize(Formatter f) throws IOException {
            long[] result = new long[2];
            if (this.btree == null) {
                if (f != null) {
                    f.format("btree is null%n", new Object[0]);
                }
                return result;
            }
            if (this.useFillValue) {
                if (f != null) {
                    f.format("useFillValue - no data is stored%n", new Object[0]);
                }
                return result;
            }
            int count = 0;
            long total = 0L;
            DataBTree.DataChunkIterator iter = this.btree.getDataChunkIteratorFilter(null);
            while (iter.hasNext()) {
                DataBTree.DataChunk dc = iter.next();
                if (f != null) {
                    f.format(" %s%n", dc);
                }
                total += (long)dc.size;
                ++count;
            }
            result[0] = total;
            result[1] = count;
            return result;
        }

        Vinfo() {
        }

        Vinfo(H5objects.DataObjectFacade facade) {
            this.facade = facade;
            this.dataPos = facade.dobj.msl.type == 0 ? facade.dobj.msl.dataAddress : H5headerNew.this.getFileOffset(facade.dobj.msl.dataAddress);
            this.mdt = facade.dobj.mdt;
            this.mds = facade.dobj.mds;
            this.mfp = facade.dobj.mfp;
            this.isvlen = this.mdt.isVlen();
            if (!facade.dobj.mdt.isOK && warnings) {
                log.debug("WARNING HDF5 file " + H5headerNew.this.raf.getLocation() + " not handling " + facade.dobj.mdt);
                return;
            }
            this.isChunked = facade.dobj.msl.type == 2;
            this.storageSize = this.isChunked ? facade.dobj.msl.chunkSize : facade.dobj.mds.dimLength;
            this.typeInfo = this.calcNCtype(facade.dobj.mdt);
        }

        Vinfo(H5objects.MessageDatatype mdt, H5objects.MessageDataspace mds, long dataPos) {
            this.mdt = mdt;
            this.mds = mds;
            this.dataPos = dataPos;
            if (!mdt.isOK && warnings) {
                log.debug("WARNING HDF5 file " + H5headerNew.this.raf.getLocation() + " not handling " + mdt);
                return;
            }
            this.isvlen = this.mdt.isVlen();
            this.typeInfo = this.calcNCtype(mdt);
        }

        void setOwner(Variable.Builder owner) {
            this.owner = owner;
            if (this.btree != null) {
                this.btree.setOwner(owner);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private TypeInfo calcNCtype(H5objects.MessageDatatype mdt) {
            TypeInfo tinfo;
            block15: {
                byte[] flags;
                int byteSize;
                int hdfType;
                block24: {
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            block17: {
                                                block16: {
                                                    hdfType = mdt.type;
                                                    byteSize = mdt.byteSize;
                                                    flags = mdt.flags;
                                                    tinfo = new TypeInfo(hdfType, byteSize);
                                                    if (hdfType != 0) break block16;
                                                    tinfo.dataType = H5headerNew.this.getNCtype(hdfType, byteSize, mdt.unsigned);
                                                    tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                                    tinfo.unsigned = (flags[0] & 8) == 0;
                                                    break block15;
                                                }
                                                if (hdfType != 1) break block17;
                                                tinfo.dataType = H5headerNew.this.getNCtype(hdfType, byteSize, mdt.unsigned);
                                                tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                                break block15;
                                            }
                                            if (hdfType != 2) break block18;
                                            tinfo.dataType = DataType.STRING;
                                            tinfo.endian = (flags[0] & 1) == 0 ? 1 : 0;
                                            break block15;
                                        }
                                        if (hdfType != 3) break block19;
                                        tinfo.dataType = DataType.CHAR;
                                        tinfo.vpad = flags[0] & 0xF;
                                        break block15;
                                    }
                                    if (hdfType != 4) break block20;
                                    tinfo.dataType = H5headerNew.this.getNCtype(hdfType, byteSize, mdt.unsigned);
                                    break block15;
                                }
                                if (hdfType != 5) break block21;
                                tinfo.dataType = DataType.OPAQUE;
                                break block15;
                            }
                            if (hdfType != 6) break block22;
                            tinfo.dataType = DataType.STRUCTURE;
                            break block15;
                        }
                        if (hdfType != 7) break block23;
                        tinfo.endian = 1;
                        tinfo.dataType = DataType.LONG;
                        break block15;
                    }
                    if (hdfType != 8) break block24;
                    if (tinfo.byteSize == 1) {
                        tinfo.dataType = DataType.ENUM1;
                        break block15;
                    } else if (tinfo.byteSize == 2) {
                        tinfo.dataType = DataType.ENUM2;
                        break block15;
                    } else {
                        if (tinfo.byteSize != 4) {
                            log.warn("Illegal byte suze for enum type = {}", (Object)tinfo.byteSize);
                            throw new IllegalStateException("Illegal byte suze for enum type = " + tinfo.byteSize);
                        }
                        tinfo.dataType = DataType.ENUM4;
                    }
                    break block15;
                }
                if (hdfType == 9) {
                    tinfo.isVString = mdt.isVString;
                    tinfo.isVlen = mdt.isVlen;
                    if (mdt.isVString) {
                        tinfo.vpad = flags[0] >> 4 & 0xF;
                        tinfo.dataType = DataType.STRING;
                    } else {
                        tinfo.dataType = H5headerNew.this.getNCtype(mdt.getBaseType(), mdt.getBaseSize(), mdt.base.unsigned);
                        tinfo.endian = mdt.base.endian;
                        tinfo.unsigned = mdt.base.unsigned;
                    }
                } else if (hdfType == 10) {
                    int n = tinfo.endian = (mdt.getFlags()[0] & 1) == 0 ? 1 : 0;
                    if (mdt.isVString()) {
                        tinfo.dataType = DataType.STRING;
                    } else {
                        int basetype = mdt.getBaseType();
                        tinfo.dataType = H5headerNew.this.getNCtype(basetype, mdt.getBaseSize(), mdt.unsigned);
                    }
                } else if (warnings) {
                    log.debug("WARNING not handling hdf dataType = " + hdfType + " size= " + byteSize);
                }
            }
            if (mdt.base != null) {
                tinfo.base = this.calcNCtype(mdt.base);
            }
            return tinfo;
        }

        public String toString() {
            StringBuilder buff = new StringBuilder();
            buff.append("dataPos=").append(this.dataPos).append(" datatype=").append(this.typeInfo);
            if (this.isChunked) {
                buff.append(" isChunked (");
                for (int size : this.storageSize) {
                    buff.append(size).append(" ");
                }
                buff.append(")");
            }
            if (this.mfp != null) {
                buff.append(" hasFilter");
            }
            buff.append("; // ").append(this.extraInfo());
            if (null != this.facade) {
                buff.append("\n").append(this.facade);
            }
            return buff.toString();
        }

        public String extraInfo() {
            StringBuilder buff = new StringBuilder();
            if (this.typeInfo.dataType != DataType.CHAR && this.typeInfo.dataType != DataType.STRING) {
                buff.append(this.typeInfo.unsigned ? " unsigned" : " signed");
            }
            if (this.typeInfo.endian >= 0) {
                buff.append(this.typeInfo.endian == 1 ? " LittleEndian" : " BigEndian");
            }
            if (this.useFillValue) {
                buff.append(" useFillValue");
            }
            return buff.toString();
        }

        DataType getNCDataType() {
            return this.typeInfo.dataType;
        }

        Object getFillValue() {
            return this.fillValue == null ? N3iosp.getFillValueDefault(this.typeInfo.dataType) : this.getFillValueNonDefault();
        }

        Object getFillValueNonDefault() {
            if (this.fillValue == null) {
                return null;
            }
            if (this.typeInfo.dataType.getPrimitiveClassType() == Byte.TYPE || this.typeInfo.dataType == DataType.CHAR) {
                return this.fillValue[0];
            }
            ByteBuffer bbuff = ByteBuffer.wrap(this.fillValue);
            if (this.typeInfo.endian >= 0) {
                bbuff.order(this.typeInfo.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            if (this.typeInfo.dataType.getPrimitiveClassType() == Short.TYPE) {
                ShortBuffer tbuff = bbuff.asShortBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType.getPrimitiveClassType() == Integer.TYPE) {
                IntBuffer tbuff = bbuff.asIntBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType.getPrimitiveClassType() == Long.TYPE) {
                LongBuffer tbuff = bbuff.asLongBuffer();
                return tbuff.get();
            }
            if (this.typeInfo.dataType == DataType.FLOAT) {
                FloatBuffer tbuff = bbuff.asFloatBuffer();
                return Float.valueOf(tbuff.get());
            }
            if (this.typeInfo.dataType == DataType.DOUBLE) {
                DoubleBuffer tbuff = bbuff.asDoubleBuffer();
                return tbuff.get();
            }
            return null;
        }

        Array readArray() throws IOException {
            Layout layout;
            int[] shape = this.mds.dimLength;
            DataType dataType = this.typeInfo.dataType;
            try {
                layout = this.isChunked ? new H5tiledLayout(this, dataType, new Section(shape)) : new LayoutRegular(this.dataPos, dataType.getSize(), shape, null);
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException();
            }
            Object data = IospHelper.readDataFill(H5headerNew.this.raf, layout, dataType, this.getFillValue(), this.typeInfo.endian, false);
            return Array.factory(dataType, shape, data);
        }

        String readString() throws IOException {
            Layout layout;
            int[] shape = new int[]{this.mdt.byteSize};
            DataType dataType = this.typeInfo.dataType;
            try {
                layout = this.isChunked ? new H5tiledLayout(this, dataType, new Section(shape)) : new LayoutRegular(this.dataPos, dataType.getSize(), shape, null);
            }
            catch (InvalidRangeException e) {
                throw new IllegalStateException();
            }
            Object data = IospHelper.readDataFill(H5headerNew.this.raf, layout, dataType, this.getFillValue(), this.typeInfo.endian, true);
            Array dataArray = Array.factory(dataType, shape, data);
            String result = "";
            if (dataArray instanceof ArrayChar.D1) {
                ArrayChar ca = (ArrayChar)dataArray;
                result = ca.getString();
            } else if (dataArray instanceof ArrayObject.D0) {
                ArrayObject ao = (ArrayObject)dataArray;
                result = (String)ao.getObject(0);
            } else {
                log.error("Unsupported array type {} for StructMetadata", (Object)dataArray.getElementType());
            }
            return result;
        }
    }
}

