/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.IospHelper;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutRegular;
import ucar.nc2.iosp.hdf4.H4header;
import ucar.nc2.iosp.hdf4.HdfEos;
import ucar.nc2.iosp.hdf5.H5header;
import ucar.nc2.iosp.hdf5.H5tiledLayout;
import ucar.nc2.iosp.hdf5.H5tiledLayoutBB;
import ucar.nc2.iosp.netcdf3.N3iosp;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.unidata.io.RandomAccessFile;

public class H5iosp
extends AbstractIOServiceProvider {
    public static final String IOSP_MESSAGE_INCLUDE_ORIGINAL_ATTRIBUTES = "IncludeOrgAttributes";
    public static final int VLEN_T_SIZE = 16;
    static boolean debug;
    static boolean debugPos;
    static boolean debugHeap;
    static boolean debugHeapStrings;
    static boolean debugFilter;
    static boolean debugRead;
    static boolean debugFilterIndexer;
    static boolean debugChunkIndexer;
    static boolean debugVlen;
    static boolean debugStructure;
    static boolean useHdfEos;
    static Logger log;
    private H5header headerParser;
    private boolean isEos;
    boolean includeOriginalAttributes;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debug = debugFlag.isSet("H5iosp/read");
        debugPos = debugFlag.isSet("H5iosp/filePos");
        debugHeap = debugFlag.isSet("H5iosp/Heap");
        debugFilter = debugFlag.isSet("H5iosp/filter");
        debugFilterIndexer = debugFlag.isSet("H5iosp/filterIndexer");
        debugChunkIndexer = debugFlag.isSet("H5iosp/chunkIndexer");
        debugVlen = debugFlag.isSet("H5iosp/vlen");
        H5header.setDebugFlags(debugFlag);
        H4header.setDebugFlags(debugFlag);
        if (debugFilter) {
            H5tiledLayoutBB.debugFilter = debugFilter;
        }
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return H5header.isValidFile(raf);
    }

    @Override
    public String getFileTypeId() {
        if (this.isEos) {
            return "HDF5-EOS";
        }
        if (this.headerParser.isNetcdf4()) {
            return DataFormatType.NETCDF4.getDescription();
        }
        return DataFormatType.HDF5.getDescription();
    }

    @Override
    public String getFileTypeDescription() {
        return "Hierarchical Data Format, version 5";
    }

    public void getEosInfo(Formatter f) throws IOException {
        NetcdfFile ncfile = this.headerParser.ncfile;
        Group eosInfo = ncfile.getRootGroup().findGroupLocal("HDFEOS_INFORMATION");
        if (eosInfo != null) {
            HdfEos.getEosInfo(ncfile, eosInfo, f);
        } else {
            f.format("Cant find GROUP '%s'", "HDFEOS_INFORMATION");
        }
    }

    public static void useHdfEos(boolean val) {
        useHdfEos = val;
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.headerParser = new H5header(this.raf, ncfile, this);
        this.headerParser.read(null);
        Group eosInfo = ncfile.getRootGroup().findGroupLocal("HDFEOS_INFORMATION");
        if (eosInfo != null && useHdfEos) {
            this.isEos = HdfEos.amendFromODL(ncfile, eosInfo);
        }
        ncfile.finish();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        if (debugRead) {
            System.out.printf("%s read %s%n", v2.getFullName(), section);
        }
        return this.readData(v2, vinfo.dataPos, section);
    }

    private Array readData(Variable v2, long dataPos, Section wantSection) throws IOException, InvalidRangeException {
        Object data;
        Layout layout;
        H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
        DataType dataType = v2.getDataType();
        if (vinfo.useFillValue) {
            Object pa = IospHelper.makePrimitiveArray((int)wantSection.computeSize(), dataType, vinfo.getFillValue());
            if (dataType == DataType.CHAR) {
                pa = IospHelper.convertByteToChar((byte[])pa);
            }
            return Array.factory(dataType, wantSection.getShape(), pa);
        }
        if (vinfo.mfp != null) {
            if (debugFilter) {
                System.out.println("read variable filtered " + v2.getFullName() + " vinfo = " + vinfo);
            }
            assert (vinfo.isChunked);
            ByteOrder bo = vinfo.typeInfo.endian == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
            layout = new H5tiledLayoutBB(v2, wantSection, this.raf, vinfo.mfp.getFilters(), bo);
            data = vinfo.typeInfo.isVString ? this.readFilteredStringData((LayoutBB)layout) : IospHelper.readDataFill(layout, v2.getDataType(), vinfo.getFillValue());
        } else {
            if (debug) {
                System.out.println("read variable " + v2.getFullName() + " vinfo = " + vinfo);
            }
            DataType readDtype = v2.getDataType();
            int elemSize = v2.getElementSize();
            Object fillValue = vinfo.getFillValue();
            int endian = vinfo.typeInfo.endian;
            wantSection = Section.fill(wantSection, v2.getShape());
            if (vinfo.typeInfo.hdfType == 2) {
                readDtype = vinfo.mdt.timeType;
                elemSize = readDtype.getSize();
                fillValue = N3iosp.getFillValueDefault(readDtype);
            } else if (vinfo.typeInfo.hdfType == 8) {
                H5header.TypeInfo baseInfo = vinfo.typeInfo.base;
                readDtype = baseInfo.dataType;
                elemSize = readDtype.getSize();
                fillValue = N3iosp.getFillValueDefault(readDtype);
                endian = baseInfo.endian;
            } else if (vinfo.typeInfo.hdfType == 9) {
                elemSize = vinfo.typeInfo.byteSize;
                endian = vinfo.typeInfo.endian;
            }
            layout = vinfo.isChunked ? new H5tiledLayout((H5header.Vinfo)v2.getSPobject(), readDtype, wantSection) : new LayoutRegular(dataPos, elemSize, v2.getShape(), wantSection);
            data = this.readData(vinfo, v2, layout, readDtype, wantSection.getShape(), fillValue, endian);
        }
        if (data instanceof Array) {
            return (Array)data;
        }
        if (dataType == DataType.STRUCTURE) {
            return this.convertStructure((Structure)v2, layout, wantSection.getShape(), (byte[])data);
        }
        return Array.factory(dataType, wantSection.getShape(), data);
    }

    public String[] readFilteredStringData(LayoutBB layout) throws IOException {
        int size = (int)layout.getTotalNelems();
        String[] sa = new String[size];
        while (layout.hasNext()) {
            LayoutBB.Chunk chunk = layout.next();
            ByteBuffer bb = chunk.getByteBuffer();
            if (debugHeapStrings) {
                System.out.printf("readFilteredStringData chunk=%s%n", chunk);
            }
            int destPos = (int)chunk.getDestElem();
            for (int i = 0; i < chunk.getNelems(); ++i) {
                sa[destPos++] = this.headerParser.readHeapString(bb, (chunk.getSrcElem() + i) * 16);
            }
        }
        return sa;
    }

    private Object readData(H5header.Vinfo vinfo, Variable v, Layout layout, DataType dataType, int[] shape, Object fillValue, int endian) throws IOException, InvalidRangeException {
        H5header.TypeInfo typeInfo = vinfo.typeInfo;
        if (typeInfo.hdfType == 2) {
            Object data = IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, true);
            Array timeArray = Array.factory(dataType, shape, data);
            String[] stringData = new String[(int)timeArray.getSize()];
            int count = 0;
            while (timeArray.hasNext()) {
                long time = timeArray.nextLong();
                stringData[count++] = CalendarDate.of(time).toString();
            }
            return Array.factory(DataType.STRING, shape, (Object)stringData);
        }
        if (typeInfo.hdfType == 8) {
            Object data = IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian);
            return Array.factory(dataType, shape, data);
        }
        if (typeInfo.isVlen) {
            Array result;
            int i;
            DataType readType = dataType;
            if (typeInfo.base.hdfType == 7) {
                readType = DataType.LONG;
            }
            Array[] data = new Array[(int)layout.getTotalNelems()];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (i = 0; i < chunk.getNelems(); ++i) {
                    long address = chunk.getSrcPos() + (long)(layout.getElemSize() * i);
                    Array vlenArray = this.headerParser.getHeapDataArray(address, readType, endian);
                    data[count++] = typeInfo.base.hdfType == 7 ? this.convertReference(vlenArray) : vlenArray;
                }
            }
            int prefixrank = 0;
            for (i = 0; i < shape.length; ++i) {
                if (shape[i] >= 0) continue;
                prefixrank = i;
                break;
            }
            if (prefixrank == 0) {
                result = data[0];
            } else {
                int[] newshape = new int[prefixrank];
                System.arraycopy(shape, 0, newshape, 0, prefixrank);
                result = Array.makeVlenArray(newshape, data);
            }
            return result;
        }
        if (dataType == DataType.STRUCTURE) {
            int recsize = layout.getElemSize();
            long size = (long)recsize * layout.getTotalNelems();
            byte[] byteArray = new byte[(int)size];
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                if (debugStructure) {
                    System.out.println(" readStructure " + v.getFullName() + " chunk= " + chunk + " index.getElemSize= " + layout.getElemSize());
                }
                this.raf.seek(chunk.getSrcPos());
                this.raf.readFully(byteArray, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return this.convertStructure((Structure)v, layout, shape, byteArray);
        }
        return this.readDataPrimitive(layout, dataType, shape, fillValue, endian, true);
    }

    Array convertReference(Array refArray) throws IOException {
        int nelems = (int)refArray.getSize();
        Index ima = refArray.getIndex();
        String[] result = new String[nelems];
        for (int i = 0; i < nelems; ++i) {
            long reference = refArray.getLong(ima.set(i));
            String name = this.headerParser.getDataObjectName(reference);
            String string = result[i] = name != null ? name : Long.toString(reference);
            if (!debugVlen) continue;
            System.out.printf(" convertReference 0x%x to %s %n", reference, result[i]);
        }
        return Array.factory(DataType.STRING, new int[]{nelems}, (Object)result);
    }

    private ArrayStructure convertStructure(Structure s2, Layout layout, int[] shape, byte[] byteArray) throws IOException, InvalidRangeException {
        StructureMembers sm = s2.makeStructureMembers();
        int calcSize = ArrayStructureBB.setOffsets(sm);
        boolean hasHeap = this.convertStructure(s2, sm);
        int recSize = layout.getElemSize();
        if (recSize < calcSize) {
            log.error("calcSize = {} actualSize = {}%n", (Object)calcSize, (Object)recSize);
            throw new IOException("H5iosp illegal structure size " + s2.getFullName());
        }
        sm.setStructureSize(recSize);
        ByteBuffer bb = ByteBuffer.wrap(byteArray);
        ArrayStructureBB asbb = new ArrayStructureBB(sm, shape, bb, 0);
        if (hasHeap) {
            int destPos = 0;
            int i = 0;
            while ((long)i < layout.getTotalNelems()) {
                this.convertHeap(asbb, destPos, sm);
                destPos += layout.getElemSize();
                ++i;
            }
        }
        return asbb;
    }

    private boolean convertStructure(Structure s2, StructureMembers sm) {
        boolean hasHeap = false;
        for (StructureMembers.Member m3 : sm.getMembers()) {
            Variable v2 = s2.findVariable(m3.getName());
            assert (v2 != null);
            H5header.Vinfo vm = (H5header.Vinfo)v2.getSPobject();
            if (vm.typeInfo.endian >= 0) {
                m3.setDataObject(vm.typeInfo.endian == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            }
            m3.setDataParam((int)vm.dataPos);
            if (v2.getDataType() == DataType.STRING || v2.isVariableLength()) {
                hasHeap = true;
            }
            if (!(v2 instanceof Structure)) continue;
            Structure nested = (Structure)v2;
            StructureMembers nestSm = nested.makeStructureMembers();
            m3.setStructureMembers(nestSm);
            hasHeap |= this.convertStructure(nested, nestSm);
        }
        return hasHeap;
    }

    void convertHeap(ArrayStructureBB asbb, int pos, StructureMembers sm) throws IOException, InvalidRangeException {
        ByteBuffer bb = asbb.getByteBuffer();
        for (StructureMembers.Member m3 : sm.getMembers()) {
            Array result;
            int prefixrank;
            if (m3.getDataType() == DataType.STRING) {
                m3.setDataObject(ByteOrder.nativeOrder());
                int size = m3.getSize();
                int destPos = pos + m3.getDataParam();
                String[] result2 = new String[size];
                for (int i = 0; i < size; ++i) {
                    result2[i] = this.headerParser.readHeapString(bb, destPos + i * 16);
                }
                int index = asbb.addObjectToHeap(result2);
                bb.order(ByteOrder.nativeOrder());
                bb.putInt(destPos, index);
                continue;
            }
            if (!m3.isVariableLength()) continue;
            int startPos = pos + m3.getDataParam();
            bb.order(ByteOrder.LITTLE_ENDIAN);
            ByteOrder bo = (ByteOrder)m3.getDataObject();
            int endian = bo.equals(ByteOrder.LITTLE_ENDIAN) ? 1 : 0;
            int[] fieldshape = m3.getShape();
            int size = 1;
            for (prefixrank = 0; prefixrank < fieldshape.length && fieldshape[prefixrank] >= 0; ++prefixrank) {
                size *= fieldshape[prefixrank];
            }
            assert (size == m3.getSize()) : "Internal error: field size mismatch";
            Array[] fieldarray = new Array[size];
            int destPos = startPos;
            for (int i = 0; i < size; ++i) {
                Array vlenArray;
                fieldarray[i] = vlenArray = this.headerParser.readHeapVlen(bb, destPos, m3.getDataType(), endian);
                destPos += 16;
            }
            if (prefixrank == 0) {
                result = fieldarray[0];
            } else {
                int[] newshape = new int[prefixrank];
                System.arraycopy(fieldshape, 0, newshape, 0, prefixrank);
                result = Array.makeVlenArray(newshape, fieldarray);
            }
            int index = asbb.addObjectToHeap(result);
            bb.order(ByteOrder.nativeOrder());
            bb.putInt(startPos, index);
        }
    }

    Object readDataPrimitive(Layout layout, DataType dataType, int[] shape, Object fillValue, int endian, boolean convertChar) throws IOException {
        if (dataType == DataType.STRING) {
            int size = (int)layout.getTotalNelems();
            String[] sa = new String[size];
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    sa[count++] = this.headerParser.readHeapString(chunk.getSrcPos() + (long)(layout.getElemSize() * i));
                }
            }
            return sa;
        }
        if (dataType == DataType.OPAQUE) {
            Array opArray = Array.factory(DataType.OPAQUE, shape);
            assert (new Section(shape).computeSize() == layout.getTotalNelems());
            int count = 0;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                if (chunk == null) continue;
                int recsize = layout.getElemSize();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    byte[] pa = new byte[recsize];
                    this.raf.seek(chunk.getSrcPos() + (long)(i * recsize));
                    this.raf.readFully(pa, 0, recsize);
                    opArray.setObject(count++, (Object)ByteBuffer.wrap(pa));
                }
            }
            return opArray;
        }
        return IospHelper.readDataFill(this.raf, layout, dataType, fillValue, endian, convertChar);
    }

    private StructureData readStructure(Structure s2, ArrayStructureW asw, long dataPos) throws IOException, InvalidRangeException {
        StructureDataW sdata = new StructureDataW(asw.getStructureMembers());
        if (debug) {
            System.out.println(" readStructure " + s2.getFullName() + " dataPos = " + dataPos);
        }
        for (Variable v2 : s2.getVariables()) {
            H5header.Vinfo vinfo = (H5header.Vinfo)v2.getSPobject();
            if (debug) {
                System.out.println(" readStructureMember " + v2.getFullName() + " vinfo = " + vinfo);
            }
            Array dataArray = this.readData(v2, dataPos + vinfo.dataPos, v2.getShapeAsSection());
            sdata.setMemberData(v2.getShortName(), dataArray);
        }
        return sdata;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.headerParser.close();
    }

    @Override
    public void reacquire() throws IOException {
        super.reacquire();
        this.headerParser.raf = this.raf;
    }

    @Override
    public String toStringDebug(Object o) {
        if (o instanceof Variable) {
            Variable v = (Variable)o;
            H5header.Vinfo vinfo = (H5header.Vinfo)v.getSPobject();
            return vinfo.toString();
        }
        return null;
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        ByteArrayOutputStream os = new ByteArrayOutputStream(100000);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
        try {
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass();
            H5header detailParser = new H5header(this.raf, ncfile, this);
            detailParser.read(pw);
            f.format("%s", super.getDetailInfo());
            f.format("%s", os.toString("UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return f.toString();
    }

    @Override
    public Object sendIospMessage(Object message) {
        if (message.toString().equals(IOSP_MESSAGE_INCLUDE_ORIGINAL_ATTRIBUTES)) {
            this.includeOriginalAttributes = true;
            return null;
        }
        if (message.toString().equals("header")) {
            return this.headerParser;
        }
        if (message.toString().equals("headerEmpty")) {
            NetcdfFileSubclass ncfile = new NetcdfFileSubclass();
            return new H5header(this.raf, ncfile, this);
        }
        return super.sendIospMessage(message);
    }

    NetcdfFile getNetcdfFile() {
        return this.headerParser.ncfile;
    }

    static {
        useHdfEos = true;
        log = LoggerFactory.getLogger(H5iosp.class);
    }
}

