/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.projection;

import com.google.common.math.DoubleMath;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.util.SpecialMathFunction;

public class TransverseMercator
extends ProjectionImpl {
    private double lat0;
    private double lon0;
    private double scale;
    private double earthRadius;
    private double falseEasting;
    private double falseNorthing;

    @Override
    public ProjectionImpl constructCopy() {
        TransverseMercator result = new TransverseMercator(this.getOriginLat(), this.getTangentLon(), this.getScale(), this.getFalseEasting(), this.getFalseNorthing(), this.getEarthRadius());
        result.setDefaultMapArea(this.defaultMapArea);
        result.setName(this.name);
        return result;
    }

    public TransverseMercator() {
        this(40.0, -105.0, 0.9996);
    }

    public TransverseMercator(double lat0, double tangentLon, double scale) {
        this(lat0, tangentLon, scale, 0.0, 0.0, 6371.229);
    }

    public TransverseMercator(double lat0, double tangentLon, double scale, double east, double north) {
        this(lat0, tangentLon, scale, east, north, 6371.229);
    }

    public TransverseMercator(double lat0, double tangentLon, double scale, double east, double north, double radius) {
        super("TransverseMercator", false);
        this.lat0 = Math.toRadians(lat0);
        this.lon0 = Math.toRadians(tangentLon);
        this.earthRadius = radius;
        this.scale = scale * this.earthRadius;
        this.falseEasting = !Double.isNaN(east) ? east : 0.0;
        this.falseNorthing = !Double.isNaN(north) ? north : 0.0;
        this.addParameter("grid_mapping_name", "transverse_mercator");
        this.addParameter("longitude_of_central_meridian", tangentLon);
        this.addParameter("latitude_of_projection_origin", lat0);
        this.addParameter("scale_factor_at_central_meridian", scale);
        this.addParameter("earth_radius", this.earthRadius * 1000.0);
        if (this.falseEasting != 0.0 || this.falseNorthing != 0.0) {
            this.addParameter("false_easting", this.falseEasting);
            this.addParameter("false_northing", this.falseNorthing);
            this.addParameter("units", "km");
        }
    }

    public double getScale() {
        return this.scale / this.earthRadius;
    }

    public double getTangentLon() {
        return Math.toDegrees(this.lon0);
    }

    public double getOriginLat() {
        return Math.toDegrees(this.lat0);
    }

    public double getFalseEasting() {
        return this.falseEasting;
    }

    public double getFalseNorthing() {
        return this.falseNorthing;
    }

    public double getEarthRadius() {
        return this.earthRadius;
    }

    public void setScale(double scale) {
        this.scale = this.earthRadius * scale;
    }

    public void setOriginLat(double lat) {
        this.lat0 = Math.toRadians(lat);
    }

    public void setTangentLon(double lon) {
        this.lon0 = Math.toRadians(lon);
    }

    public void setFalseEasting(double falseEasting) {
        this.falseEasting = falseEasting;
    }

    public void setFalseNorthing(double falseNorthing) {
        this.falseNorthing = falseNorthing;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "Transverse mercator";
    }

    @Override
    public String paramsToString() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "TransverseMercator{lat0=" + this.lat0 + ", lon0=" + this.lon0 + ", scale=" + this.scale + ", earthRadius=" + this.earthRadius + ", falseEasting=" + this.falseEasting + ", falseNorthing=" + this.falseNorthing + '}';
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        double y2;
        if (LatLonPoints.isInfinite(pt1) || LatLonPoints.isInfinite(pt2)) {
            return true;
        }
        double y1 = pt1.getY() - this.falseNorthing;
        return y1 * (y2 = pt2.getY() - this.falseNorthing) < 0.0 && Math.abs(y1 - y2) > 2.0 * this.earthRadius;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransverseMercator that = (TransverseMercator)o;
        double tolerance = 1.0E-6;
        if (DoubleMath.fuzzyCompare(that.earthRadius, this.earthRadius, tolerance) != 0) {
            return false;
        }
        if (DoubleMath.fuzzyCompare(that.falseEasting, this.falseEasting, tolerance) != 0) {
            return false;
        }
        if (DoubleMath.fuzzyCompare(that.falseNorthing, this.falseNorthing, tolerance) != 0) {
            return false;
        }
        if (DoubleMath.fuzzyCompare(that.lat0, this.lat0, tolerance) != 0) {
            return false;
        }
        if (DoubleMath.fuzzyCompare(that.lon0, this.lon0, tolerance) != 0) {
            return false;
        }
        if (DoubleMath.fuzzyCompare(that.scale, this.scale, tolerance) != 0) {
            return false;
        }
        if (this.defaultMapArea == null != (that.defaultMapArea == null)) {
            return false;
        }
        return this.defaultMapArea == null || that.defaultMapArea.equals(this.defaultMapArea);
    }

    public int hashCode() {
        long temp = this.lat0 != 0.0 ? Double.doubleToLongBits(this.lat0) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lon0 != 0.0 ? Double.doubleToLongBits(this.lon0) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.scale != 0.0 ? Double.doubleToLongBits(this.scale) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.earthRadius != 0.0 ? Double.doubleToLongBits(this.earthRadius) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseEasting != 0.0 ? Double.doubleToLongBits(this.falseEasting) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = this.falseNorthing != 0.0 ? Double.doubleToLongBits(this.falseNorthing) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double toY;
        double toX;
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double lon = Math.toRadians(fromLon);
        double lat = Math.toRadians(fromLat);
        double dlon = lon - this.lon0;
        double b = Math.cos(lat) * Math.sin(dlon);
        if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
            toX = Double.POSITIVE_INFINITY;
            toY = Double.POSITIVE_INFINITY;
        } else {
            toX = this.scale * SpecialMathFunction.atanh(b);
            toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0);
        }
        result.setLocation(toX + this.falseEasting, toY + this.falseNorthing);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double fromX = world.getX();
        double fromY = world.getY();
        double x = (fromX - this.falseEasting) / this.scale;
        double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
        double toLon = Math.toDegrees(this.lon0 + Math.atan2(Math.sinh(x), Math.cos(d)));
        double toLat = Math.toDegrees(Math.asin(Math.sin(d) / Math.cosh(x)));
        result.setLatitude(toLat);
        result.setLongitude(toLon);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        float[] fromLatA = from[latIndex];
        float[] fromLonA = from[lonIndex];
        float[] resultXA = to[0];
        float[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lon = Math.toRadians(fromLon);
            double lat = Math.toRadians(fromLat);
            double dlon = lon - this.lon0;
            double b = Math.cos(lat) * Math.sin(dlon);
            if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
                toX = 0.0;
                toY = 0.0;
            } else {
                toX = this.scale * SpecialMathFunction.atanh(b) + this.falseEasting;
                toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0) + this.falseNorthing;
            }
            resultXA[i] = (float)toX;
            resultYA[i] = (float)toY;
        }
        return to;
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        int cnt = from[0].length;
        float[] fromXA = from[0];
        float[] fromYA = from[1];
        float[] toLatA = to[0];
        float[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double x = (fromX - this.falseEasting) / this.scale;
            double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
            double toLon = Math.toDegrees(this.lon0 + Math.atan2(Math.sinh(x), Math.cos(d)));
            double toLat = Math.toDegrees(Math.asin(Math.sin(d) / Math.cosh(x)));
            toLatA[i] = (float)toLat;
            toLonA[i] = (float)toLon;
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        int cnt = from[0].length;
        double[] fromLatA = from[latIndex];
        double[] fromLonA = from[lonIndex];
        double[] resultXA = to[0];
        double[] resultYA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toY;
            double toX;
            double fromLat = fromLatA[i];
            double fromLon = fromLonA[i];
            double lon = Math.toRadians(fromLon);
            double lat = Math.toRadians(fromLat);
            double dlon = lon - this.lon0;
            double b = Math.cos(lat) * Math.sin(dlon);
            if (Math.abs(Math.abs(b) - 1.0) < 1.0E-6) {
                toX = 0.0;
                toY = 0.0;
            } else {
                toX = this.scale * SpecialMathFunction.atanh(b) + this.falseEasting;
                toY = this.scale * (Math.atan2(Math.tan(lat), Math.cos(dlon)) - this.lat0) + this.falseNorthing;
            }
            resultXA[i] = toX;
            resultYA[i] = toY;
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        int cnt = from[0].length;
        double[] fromXA = from[0];
        double[] fromYA = from[1];
        double[] toLatA = to[0];
        double[] toLonA = to[1];
        for (int i = 0; i < cnt; ++i) {
            double toLat;
            double fromX = fromXA[i];
            double fromY = fromYA[i];
            double x = (fromX - this.falseEasting) / this.scale;
            double d = (fromY - this.falseNorthing) / this.scale + this.lat0;
            double toLon = Math.toDegrees(this.lon0 + Math.atan2(Math.sinh(x), Math.cos(d)));
            toLatA[i] = toLat = Math.toDegrees(Math.asin(Math.sin(d) / Math.cosh(x)));
            toLonA[i] = toLon;
        }
        return to;
    }
}

