/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.DapLog;
import dap4.servlet.DapRequest;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FrontPage {
    static final boolean DUMPFILELIST = false;
    protected static final boolean NO_VLEN = false;
    protected static final String[] expatterns = new String[0];
    protected static final FileSource[] SOURCES = new FileSource[]{new FileSource(".nc", "netCDF"), new FileSource(".hdf5", "HDF5"), new FileSource(".dap", "Raw Protocol Output"), new FileSource(".syn", "Synthetic")};
    private static String dap4TestServerPropName = "d4ts";
    public static String dap4TestServer = "remotetest.unidata.ucar.edu";
    protected DapRequest drq = null;
    protected List<Root> roots = null;
    static final String HTML_PREFIX = "<html>\n<head>\n<title>DAP4 Test Files</title>\n<meta http-equiv=\"Content-Type\" content=\"text/html\">\n</meta>\n<body bgcolor=\"#FFFFFF\">\n";
    static final String HTML_HEADER1 = "<h1>DAP4 Test Files</h1>\n";
    static final String HTML_HEADER2;
    static final String HTML_HEADER3 = "<h3>%s Based Test Files</h3>%n";
    static final String TABLE_HEADER = "<table>\n";
    static final String TABLE_FOOTER = "</table>\n";
    static final String HTML_FOOTER = "<hr>\n</html>\n";
    static final String HTML_FORMAT = "<tr>%n<td halign='right'><b>%s:</b></td>%n<td halign='center'><a href='%s.dmr.xml'> DMR.XML </a></div></td>%n<td halign='center'><a href='%s.dap'> DAP </a></div></td>%n<td halign='center'><a href='%s.dsr.xml'> DSR.XML </a></div></td>%n</tr>%n";

    public FrontPage(List<Root> rootinfo, DapRequest req) throws DapException {
        this.drq = req;
        this.roots = rootinfo;
        for (Root root : this.roots) {
            this.buildFileList(root);
        }
    }

    protected void buildFileList(Root rootinfo) throws DapException {
        File root = new File(rootinfo.getFullPath());
        if (!root.isDirectory()) {
            throw new DapException("FrontPage: specified root directory is not a directory: " + rootinfo.getFullPath());
        }
        if (!root.canRead()) {
            throw new DapException("FrontPage: specified root directory is not readable: " + rootinfo.getFullPath());
        }
        File[] candidates = root.listFiles();
        ArrayList<FileSource> activesources = new ArrayList<FileSource>();
        for (FileSource src : SOURCES) {
            ArrayList<File> matches = new ArrayList<File>();
            for (File candidate : candidates) {
                String name = candidate.getName();
                boolean excluded = false;
                for (String exclude : expatterns) {
                    if (name.indexOf(exclude) < 0) continue;
                    excluded = true;
                    break;
                }
                if (excluded || !name.endsWith(src.ext)) continue;
                if (!candidate.canRead()) {
                    DapLog.info((String)("FrontPage: file not readable: " + candidate));
                    continue;
                }
                matches.add(candidate);
            }
            if (matches.size() <= 0) continue;
            matches.sort(new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileSource clone = new FileSource(src.ext, src.tag);
            clone.files = matches;
            activesources.add(clone);
        }
        rootinfo.setFiles(activesources);
    }

    protected String buildPage() throws DapException {
        StringBuilder html = new StringBuilder();
        html.append(HTML_PREFIX);
        html.append(HTML_HEADER1);
        StringBuilder rootnames = new StringBuilder();
        for (Root root : this.roots) {
            if (rootnames.length() > 0) {
                rootnames.append(",");
            }
            rootnames.append(root.dir);
        }
        html.append(String.format(HTML_HEADER2, rootnames));
        for (Root root : this.roots) {
            try {
                for (FileSource src : root.files) {
                    html.append(String.format(HTML_HEADER3, src.tag));
                    html.append(TABLE_HEADER);
                    for (File file : src.files) {
                        String name = file.getName();
                        StringBuilder buf = new StringBuilder();
                        buf.append(this.drq.getControllerPath());
                        buf.append('/');
                        buf.append(DapUtil.canonicalpath((String)root.dir));
                        buf.append('/');
                        buf.append(DapUtil.canonicalpath((String)name));
                        String urlpath = buf.toString();
                        String line = String.format(HTML_FORMAT, name, urlpath, urlpath, urlpath);
                        html.append(line);
                    }
                    html.append(TABLE_FOOTER);
                }
            }
            catch (Exception e) {
                FrontPage.sendtrace(this.drq, e);
            }
        }
        html.append(HTML_FOOTER);
        return html.toString();
    }

    public static void sendtrace(DapRequest drq, Exception e) {
        block2: {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                sw.close();
                FrontPage.sendtext(drq, sw.toString());
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public static void sendtext(DapRequest drq, String s) {
        block2: {
            try {
                s = "+++++++++\n" + (String)s;
                s = (String)s + "+++++++++\n";
                byte[] bytes = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode((String)s));
                OutputStream out = drq.getOutputStream();
                out.write(bytes);
                out.flush();
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    static {
        String d4ts = System.getProperty(dap4TestServerPropName);
        if (d4ts != null && d4ts.length() > 0) {
            dap4TestServer = d4ts;
        }
        HTML_HEADER2 = "<h2>http://" + dap4TestServer + "/d4ts/{%s}</h2>%n<hr>%n";
    }

    static class FileSource {
        public String ext = null;
        public String tag = null;
        public List<File> files = null;

        public FileSource(String ext, String tag) {
            this.ext = ext;
            this.tag = tag;
        }
    }

    public static class Root {
        public String prefix;
        public String dir;
        public List<FileSource> files;

        public String toString() {
            return String.format("{'%s/%s'}", this.prefix, this.dir);
        }

        public Root(String dir, String prefix) {
            this.dir = dir;
            this.prefix = DapUtil.canonicalpath((String)prefix);
        }

        public String getFullPath() {
            return DapUtil.canonjoin((String)this.prefix, (String)this.dir);
        }

        public void setFiles(List<FileSource> files) {
            this.files = files;
        }
    }
}

