/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.DapLog;
import dap4.servlet.DapRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class FrontPage {
    static final boolean DUMPFILELIST = false;
    static final String FPTEMPLATE = "/templates/dap4.frontpage.html.template";
    static final String DFALTTESTSERVER = "remotetest.unidata.ucar.edu";
    protected static final boolean NO_VLEN = false;
    protected static final String[] expatterns = new String[0];
    protected static final FileSource[] SOURCES = new FileSource[]{new FileSource(".nc", "netCDF")};
    private static String dap4TestServerPropName = "d4ts";
    public static String dap4TestServer = null;
    protected DapRequest drq = null;
    protected List<Root> roots = null;
    protected StringBuilder frontpage = null;
    static final String HTML_URL_FORMAT = "http://%s/d4ts/%s/%s";
    static final String HTML_SOURCE = "<h3>${source} Based Test Files</h3>\n<table>\n${rows}\n</table>";
    static final String HTML_ROW;

    public FrontPage(List<Root> rootinfo, DapRequest req) throws DapException {
        this.drq = req;
        this.roots = rootinfo;
        for (Root root : this.roots) {
            this.buildFileList(root);
        }
        if (dap4TestServer == null) {
            try {
                URL url = new URL(this.drq.getRequest().getRequestURL().toString());
                dap4TestServer = url.getHost();
                if (url.getPort() > 0) {
                    dap4TestServer = dap4TestServer + ":" + url.getPort();
                }
            }
            catch (MalformedURLException mue) {
                dap4TestServer = null;
            }
        }
        if (dap4TestServer == null) {
            dap4TestServer = DFALTTESTSERVER;
        }
        try {
            this.frontpage = this.initialPage(dap4TestServer);
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe).setCode(500);
        }
    }

    protected void buildFileList(Root rootinfo) throws DapException {
        File root = new File(rootinfo.getFullPath());
        if (!root.isDirectory()) {
            throw new DapException("FrontPage: specified root directory is not a directory: " + rootinfo.getFullPath());
        }
        if (!root.canRead()) {
            throw new DapException("FrontPage: specified root directory is not readable: " + rootinfo.getFullPath());
        }
        File[] candidates = root.listFiles();
        ArrayList<FileSource> activesources = new ArrayList<FileSource>();
        for (FileSource src : SOURCES) {
            ArrayList<File> matches = new ArrayList<File>();
            for (File candidate : candidates) {
                String name = candidate.getName();
                boolean excluded = false;
                for (String exclude : expatterns) {
                    if (name.indexOf(exclude) < 0) continue;
                    excluded = true;
                    break;
                }
                if (excluded || !name.endsWith(src.ext)) continue;
                if (!candidate.canRead()) {
                    DapLog.info((String)("FrontPage: file not readable: " + candidate));
                    continue;
                }
                matches.add(candidate);
            }
            if (matches.size() <= 0) continue;
            matches.sort(new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            FileSource clone = new FileSource(src.ext, src.tag);
            clone.files = matches;
            activesources.add(clone);
        }
        rootinfo.setFiles(activesources);
    }

    protected String buildPage() throws DapException {
        StringBuilder rootnames = new StringBuilder();
        for (Root root : this.roots) {
            if (rootnames.length() > 0) {
                rootnames.append(",");
            }
            rootnames.append(root.dir);
        }
        StringBuilder sources = new StringBuilder();
        for (Root root : this.roots) {
            try {
                for (FileSource src : root.files) {
                    StringBuilder allrows = new StringBuilder();
                    for (File file : src.files) {
                        String name = file.getName();
                        String rootpath = root.dir;
                        if (rootpath.startsWith("/")) {
                            rootpath = rootpath.substring(1);
                        }
                        Object[] objectArray = new Object[3];
                        objectArray[0] = dap4TestServer;
                        objectArray[1] = rootpath;
                        objectArray[2] = name;
                        String url = String.format(HTML_URL_FORMAT, objectArray);
                        StringBuilder row = new StringBuilder(HTML_ROW);
                        this.substitute(row, "dataset", name);
                        this.substitute(row, "url", url);
                        allrows.append((CharSequence)row);
                    }
                    StringBuilder source = new StringBuilder(HTML_SOURCE);
                    this.substitute(source, "source", src.tag);
                    this.substitute(source, "rows", allrows.toString());
                    sources.append((CharSequence)source);
                }
            }
            catch (Exception e) {
                FrontPage.sendtrace(this.drq, e);
            }
        }
        this.substitute(this.frontpage, "sources", sources.toString());
        return this.frontpage.toString();
    }

    protected StringBuilder initialPage(String testserver) throws IOException {
        StringBuilder page = new StringBuilder();
        String template = this.drq.getWebContentPath(FPTEMPLATE);
        try (FileInputStream stream = new FileInputStream(template);){
            int ch;
            while ((ch = ((InputStream)stream).read()) >= 0) {
                page.append((char)ch);
            }
        }
        this.substitute(page, "dap4TestServer", testserver);
        return page;
    }

    protected void substitute(StringBuilder buf, String macro, String value) {
        int index;
        int from = 0;
        String tag = "${" + macro + "}";
        int taglen = tag.length();
        int valuelen = value.length();
        while ((index = buf.indexOf(tag, from)) >= 0) {
            buf.replace(index, index + taglen, value);
            from = index + valuelen;
        }
    }

    public static void sendtrace(DapRequest drq, Exception e) {
        block2: {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                sw.close();
                FrontPage.sendtext(drq, sw.toString());
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public static void sendtext(DapRequest drq, String s) {
        block2: {
            try {
                s = "+++++++++\n" + (String)s;
                s = (String)s + "+++++++++\n";
                byte[] bytes = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode((String)s));
                OutputStream out = drq.getOutputStream();
                out.write(bytes);
                out.flush();
            }
            catch (IOException ioe) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    static {
        String d4ts = System.getProperty(dap4TestServerPropName);
        if (d4ts != null && d4ts.length() > 0) {
            dap4TestServer = d4ts;
        }
        HTML_ROW = String.join((CharSequence)"\n", "<tr>", "<td halign='right'><b>${dataset}:</b></td>", "<td halign='center'><a href='${url}.dmr'> DMR </a></div></td>", "<td halign='center'><a href='${url}.dap'> DAP </a></div></td>", "<td halign='center'><a href='${url}.dsr'> DSR </a></div></td>", "</tr>", "");
    }

    static class FileSource {
        public String ext = null;
        public String tag = null;
        public List<File> files = null;

        public FileSource(String ext, String tag) {
            this.ext = ext;
            this.tag = tag;
        }
    }

    public static class Root {
        public String prefix;
        public String dir;
        public List<FileSource> files;

        public String toString() {
            return String.format("{'%s/%s'}", this.prefix, this.dir);
        }

        public Root(String prefix, String dir) {
            this.prefix = DapUtil.canonicalpath((String)prefix);
            this.dir = dir;
        }

        public String getFullPath() {
            return this.prefix + "/" + this.dir;
        }

        public void setFiles(List<FileSource> files) {
            this.files = files;
        }
    }
}

