/*
 * Decompiled with CFR 0.152.
 */
package dap4.d4ts;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.d4ts.FrontPage;
import dap4.dap4lib.DapLog;
import dap4.servlet.DapController;
import dap4.servlet.DapRequest;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class D4TSServlet
extends DapController {
    static final boolean DEBUG = false;
    static final boolean PARSEDEBUG = false;
    static final String RESOURCEPATH = "/testfiles";
    protected List<FrontPage.Root> defaultroots = null;

    public void initialize() {
        super.initialize();
        DapLog.info((String)"Initializing d4ts servlet");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        super.handleRequest(req, resp);
    }

    protected void doFavicon(String icopath, DapContext cxt) throws IOException {
        DapRequest drq = (DapRequest)cxt.get(DapRequest.class);
        String favfile = drq.getResourcePath(icopath);
        if (favfile != null) {
            try (FileInputStream fav = new FileInputStream(favfile);){
                byte[] content = DapUtil.readbinaryfile((InputStream)fav);
                OutputStream out = drq.getOutputStream();
                out.write(content);
            }
        }
    }

    protected void doCapabilities(DapRequest drq, DapContext cxt) throws IOException {
        this.addCommonHeaders(drq);
        FrontPage front = this.getFrontPage(drq, cxt);
        String frontpage = front.buildPage();
        if (frontpage == null) {
            throw new DapException("Cannot create front page").setCode(500);
        }
        byte[] frontpage8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(frontpage));
        OutputStream out = drq.getOutputStream();
        out.write(frontpage8);
    }

    public long getBinaryWriteLimit() {
        return 100000000L;
    }

    protected FrontPage getFrontPage(DapRequest drq, DapContext cxt) throws DapException {
        if (this.defaultroots == null) {
            String testroot = drq.getResourcePath("/");
            if (testroot == null) {
                throw new DapException("Cannot locate dataset  directory");
            }
            this.defaultroots = new ArrayList<FrontPage.Root>();
            this.defaultroots.add(new FrontPage.Root(testroot, RESOURCEPATH));
        }
        return new FrontPage(this.defaultroots, drq);
    }

    public String getServletID() {
        return "/d4ts";
    }

    public String getWebContentRoot(DapRequest drq) throws DapException {
        try {
            String servletpath = this.getServletContext().getResource("/").getPath();
            String path = servletpath + "WEB-INF";
            File f = new File(path);
            if (!(f.exists() && f.canRead() && f.isDirectory())) {
                throw new DapException("Cannot find WEB-INF").setCode(404);
            }
            return path;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    public String getResourcePath(DapRequest drq, String location) throws DapException {
        try {
            String root = this.getWebContentRoot(drq);
            if (root == null) {
                throw new DapException("Cannot find WEB-INF").setCode(404);
            }
            StringBuilder path = new StringBuilder(DapUtil.canonicalpath((String)root));
            if (location.charAt(0) != '/') {
                path.append('/');
            }
            path.append(location);
            String result = path.toString();
            File f = new File(result);
            if (!f.exists() || !f.canRead()) {
                throw new DapException("Cannot find Resource path: " + result).setCode(404);
            }
            return result;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe).setCode(404);
        }
    }
}

