/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XURI {
    static final String QUERYSEP = "&";
    static final String FRAGMENTSEP = "&";
    public static final EnumSet<Parts> URLONLY = EnumSet.of(Parts.BASE, Parts.PWD, Parts.HOST, Parts.PATH);
    public static final EnumSet<Parts> URLALL = EnumSet.of(Parts.FORMAT, new Parts[]{Parts.BASE, Parts.PWD, Parts.HOST, Parts.PATH, Parts.QUERY, Parts.FRAG});
    public static final EnumSet<Parts> URLBASE = EnumSet.of(Parts.BASE, new Parts[]{Parts.PWD, Parts.HOST, Parts.PATH, Parts.QUERY, Parts.FRAG});
    public static final EnumSet<Parts> URLPATH = EnumSet.of(Parts.PATH, Parts.QUERY, Parts.FRAG);
    protected String originaluri = null;
    protected boolean isfile = false;
    protected String baseprotocol = null;
    protected String formatprotocol = null;
    protected String userinfo = null;
    protected String host = null;
    protected String path = null;
    protected String query = null;
    protected String frag = null;
    protected Map<String, String> queryfields = new HashMap<String, String>();
    protected Map<String, String> fragfields = new HashMap<String, String>();

    public XURI(String xurl) throws URISyntaxException {
        if (xurl == null) {
            throw new URISyntaxException(xurl, "Null URI");
        }
        this.originaluri = xurl;
        int[] breakpoint = new int[1];
        List<String> protocols = DapUtil.getProtocols(xurl, breakpoint);
        String remainder = xurl.substring(breakpoint[0], xurl.length());
        switch (protocols.size()) {
            case 0: {
                this.formatprotocol = "file";
                this.baseprotocol = "file";
                break;
            }
            case 1: {
                this.formatprotocol = protocols.get(0);
                if ("file".equalsIgnoreCase(this.formatprotocol)) {
                    this.baseprotocol = "file";
                    break;
                }
                this.baseprotocol = "http";
                break;
            }
            case 2: {
                this.baseprotocol = protocols.get(0);
                this.formatprotocol = protocols.get(1);
                break;
            }
            default: {
                throw new URISyntaxException(xurl, "Too many protocols: at most 2 allowed");
            }
        }
        this.isfile = "file".equals(this.baseprotocol);
        if (this.isfile) {
            this.parsefile(remainder);
        } else {
            this.parsenonfile(remainder);
        }
        if (this.query != null) {
            this.parseQuery(this.query);
        }
        if (this.frag != null) {
            this.parseFragment(this.frag);
        }
    }

    protected void parsenonfile(String remainder) throws URISyntaxException {
        URI uri = new URI(this.baseprotocol + ":" + remainder);
        this.userinfo = XURI.canonical(uri.getUserInfo());
        this.host = XURI.canonical(uri.getHost());
        if (uri.getPort() > 0) {
            this.host = this.host + ":" + uri.getPort();
        }
        this.path = XURI.canonical(uri.getPath());
        this.query = uri.getRawQuery();
        this.frag = XURI.canonical(uri.getFragment());
    }

    protected void parsefile(String remainder) {
        String query = null;
        String fragment = null;
        int qindex = remainder.indexOf("?");
        int findex = remainder.lastIndexOf("#");
        if (qindex >= 0) {
            if (findex >= 0 && findex > qindex) {
                fragment = remainder.substring(findex + 1, remainder.length());
                remainder = remainder.substring(0, findex);
            }
            query = remainder.substring(qindex + 1, remainder.length());
            remainder = remainder.substring(0, qindex);
        } else if (findex >= 0) {
            fragment = remainder.substring(findex + 1, remainder.length());
            remainder = remainder.substring(0, findex);
        }
        StringBuilder buf = new StringBuilder(remainder);
        for (int i = 0; i < remainder.length() && buf.charAt(i) == '/'; ++i) {
            buf.deleteCharAt(i);
        }
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(buf.charAt(0)) < 0 || buf.charAt(1) != ':') {
            buf.insert(0, '/');
        }
        this.path = remainder = buf.toString();
        this.frag = fragment;
        this.query = query;
    }

    public String getOriginal() {
        return this.originaluri;
    }

    public String getBaseProtocol() {
        return this.baseprotocol;
    }

    public String getFormatProtocol() {
        return this.formatprotocol;
    }

    public void setBaseProtocol(String base) {
        this.baseprotocol = base;
    }

    public boolean isFile() {
        return this.isfile;
    }

    public String getUserinfo() {
        return this.userinfo;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFrag() {
        return this.frag;
    }

    public Map<String, String> getQueryFields() {
        return this.queryfields;
    }

    public Map<String, String> getFragFields() {
        return this.fragfields;
    }

    public XURI parseQuery(String q) {
        if (q == null || q.length() == 0) {
            return this;
        }
        String[] params = q.split("&");
        this.query = q;
        for (String param : params) {
            String[] pair = param.split("[=]");
            String name = Escape.urlDecode(pair[0]);
            name = name.toLowerCase();
            String value = "";
            if (pair.length <= 1) continue;
            value = Escape.urlDecode(pair[1]);
            this.queryfields.put(name, value);
        }
        return this;
    }

    public XURI parseFragment(String f) {
        if (f == null || f.length() == 0) {
            return this;
        }
        String[] params = f.split("&");
        if (params != null && params.length > 0) {
            this.frag = f;
            for (String param : params) {
                String[] pair = param.split("=");
                String name = Escape.urlDecode(pair[0]);
                name = name.toLowerCase();
                String value = pair.length == 2 ? Escape.urlDecode(pair[1]) : "";
                this.fragfields.put(name, value);
            }
        }
        return this;
    }

    public String assemble(EnumSet<Parts> parts) {
        StringBuilder uri = new StringBuilder();
        int useformat = parts.contains((Object)Parts.FORMAT) ? 1 : 0;
        int usebase = parts.contains((Object)Parts.BASE) ? 2 : 0;
        switch (useformat + usebase) {
            case 0: {
                break;
            }
            case 1: {
                uri.append(this.formatprotocol + ":");
                break;
            }
            case 2: {
                uri.append(this.baseprotocol + ":");
                break;
            }
            case 3: {
                uri.append(this.formatprotocol + ":");
                if (this.baseprotocol.equals(this.formatprotocol)) break;
                uri.append(this.formatprotocol + ":");
            }
        }
        uri.append(this.baseprotocol.equals("file") ? "/" : "//");
        if (this.userinfo != null && parts.contains((Object)Parts.PWD)) {
            uri.append(this.userinfo + ":");
        }
        if (this.host != null && parts.contains((Object)Parts.HOST)) {
            uri.append(this.host);
        }
        if (this.path != null && parts.contains((Object)Parts.PATH)) {
            uri.append(this.path);
        }
        if (this.query != null && parts.contains((Object)Parts.QUERY)) {
            uri.append("?" + this.query);
        }
        if (this.frag != null && parts.contains((Object)Parts.FRAG)) {
            uri.append("#" + this.frag);
        }
        return uri.toString();
    }

    public static String canonical(String s) {
        if (s != null && (s = s.trim()).length() == 0) {
            s = null;
        }
        return s;
    }

    public String toString() {
        return this.originaluri;
    }

    public static enum Parts {
        FORMAT,
        BASE,
        PWD,
        HOST,
        PATH,
        QUERY,
        FRAG;

    }
}

