/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.ErrorResponse;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.RequestMode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ChunkWriter
extends OutputStream {
    public static boolean DEBUG = false;
    public static boolean DUMPDATA = false;
    public static boolean DEBUGHEADER = false;
    static final int MAXCHUNKSIZE = 65535;
    static final long DEFAULTWRITELIMIT = 1000000L;
    static final int SIZEOF_INTEGER = 4;
    public static final byte[] CRLF8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode("\r\n"));
    public static final String XMLDOCUMENTHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>";
    protected OutputStream saveoutput = null;
    protected OutputStream output = null;
    protected State state = State.INITIAL;
    protected int maxbuffersize = 65535;
    protected long writelimit = 1000000L;
    protected long writecount = 0L;
    protected ByteBuffer chunk = null;
    protected ByteBuffer header = null;
    protected ByteOrder writeorder = null;
    protected RequestMode mode = null;
    protected byte[] dmr8 = null;
    protected boolean closed = false;

    public ChunkWriter(OutputStream output, RequestMode mode, ByteOrder writeorder) throws IOException {
        if (DUMPDATA || DEBUG) {
            this.saveoutput = output;
            this.output = new ByteArrayOutputStream();
        } else {
            this.output = output;
        }
        this.setWriteOrder(writeorder);
        this.setMode(mode);
        this.header = ByteBuffer.allocate(4).order(ByteOrder.BIG_ENDIAN);
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public void setMode(RequestMode mode) {
        this.mode = mode;
    }

    public void setBufferSize(int maxsize) {
        if (maxsize < 0 || maxsize > 65535) {
            return;
        }
        this.maxbuffersize = maxsize;
    }

    public ByteOrder getWriteOrder() {
        return this.writeorder;
    }

    public void setWriteOrder(ByteOrder writeorder) {
        this.writeorder = writeorder;
    }

    public void setWriteLimit(long limit) {
        this.writelimit = limit;
    }

    public void writeDSR(String dsr) throws IOException {
        char c;
        int len;
        if (this.state != State.INITIAL) {
            throw new DapException("Attempt to write DSR twice");
        }
        if (dsr == null) {
            throw new DapException("Attempt to write empty DSR");
        }
        for (len = ((String)dsr).length(); len > 0 && ((c = ((String)dsr).charAt(len - 1)) == '\r' || c == '\n'); --len) {
        }
        if (((String)dsr).length() == 0) {
            throw new DapException("Attempt to write empty DSR");
        }
        dsr = ((String)dsr).substring(0, len) + "\r\n";
        dsr = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" + (String)dsr;
        byte[] dsr8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode((String)dsr));
        this.sendDXR(dsr8);
        this.state = State.END;
    }

    public void cacheDMR(String dmr) throws IOException {
        char c;
        int len;
        if (this.state != State.INITIAL) {
            throw new DapException("Attempt to write DMR twice");
        }
        if (dmr == null) {
            throw new DapException("Attempt to write empty DMR");
        }
        for (len = ((String)dmr).length(); len > 0 && ((c = ((String)dmr).charAt(len - 1)) == '\r' || c == '\n'); --len) {
        }
        if (((String)dmr).length() == 0) {
            throw new DapException("Attempt to write empty DMR");
        }
        dmr = ((String)dmr).substring(0, len) + "\r\n";
        dmr = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n" + (String)dmr;
        this.dmr8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode((String)dmr));
        this.state = State.DMR;
    }

    void sendDXR(byte[] dxr8) throws IOException {
        if (dxr8 == null || dxr8.length == 0) {
            return;
        }
        if (this.mode == RequestMode.DMR || this.mode == RequestMode.DSR) {
            this.state = State.END;
        } else {
            int flags = 0;
            if (this.writeorder == ByteOrder.LITTLE_ENDIAN) {
                flags |= 4;
            }
            ChunkWriter.chunkheader(dxr8.length, flags, this.header);
            this.output.write(DapUtil.extract((ByteBuffer)this.header));
            this.state = State.DATA;
        }
        this.output.write(dxr8);
        this.output.flush();
    }

    public void writeError(int httpcode, String msg, String cxt, String other) throws IOException {
        this.dmr8 = null;
        ErrorResponse response = new ErrorResponse(httpcode, msg, cxt, other);
        String errorbody = response.buildXML();
        byte[] errbody8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(errorbody));
        if (this.mode == RequestMode.DMR) {
            this.sendDXR(errbody8);
        } else {
            this.chunk.clear();
            int flags = 3;
            ChunkWriter.chunkheader(errbody8.length, flags, this.header);
            this.output.write(DapUtil.extract((ByteBuffer)this.header));
            this.output.write(errbody8);
            this.output.flush();
        }
        this.state = State.ERROR;
    }

    void writeChunk(int flags) throws IOException {
        if (this.chunk == null) {
            this.chunk = ByteBuffer.allocate(this.maxbuffersize);
        }
        int buffersize = this.chunk.position();
        ChunkWriter.chunkheader(buffersize, flags, this.header);
        this.output.write(DapUtil.extract((ByteBuffer)this.header));
        if (buffersize > 0) {
            this.output.write(this.chunk.array(), 0, buffersize);
        }
        this.chunk.clear();
    }

    public static void chunkheader(int length, int flags, ByteBuffer hdrbuf) throws DapException {
        if (length > 65535 || length < 0) {
            throw new DapException("Illegal chunk size: " + length);
        }
        int hdr = flags << 24 | length;
        hdrbuf.clear();
        hdrbuf.putInt(hdr);
        if (DEBUGHEADER) {
            System.err.printf("header: flags=%x length=%d header=%08x%n", flags, length, hdr);
        }
    }

    void verifystate() throws DapException {
        switch (this.state) {
            case INITIAL: {
                throw new DapException("Attempt to write data before DMR");
            }
            case END: {
                throw new DapException("Attempt to write data after END");
            }
            case ERROR: {
                throw new DapException("Attempt to write data after ERROR");
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.dmr8 != null) {
            this.sendDXR(this.dmr8);
            this.dmr8 = null;
        }
        if (this.mode == RequestMode.DMR) {
            return;
        }
        if (this.chunk == null || this.chunk.position() == 0) {
            return;
        }
        this.verifystate();
        this.state = State.DATA;
        int flags = 1;
        this.writeChunk(flags);
        this.state = State.END;
        this.output.flush();
        if (this.saveoutput != null) {
            this.saveoutput.write(((ByteArrayOutputStream)this.output).toByteArray());
        }
    }

    public byte[] getDump() {
        if ((DUMPDATA || DEBUG) && this.output != null) {
            return ((ByteArrayOutputStream)this.output).toByteArray();
        }
        return null;
    }

    @Override
    public void flush() throws IOException {
        if (this.mode == RequestMode.DMR) {
            return;
        }
        if (this.dmr8 != null) {
            this.sendDXR(this.dmr8);
            this.dmr8 = null;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.verifystate();
        if (this.writecount + (long)len >= this.writelimit) {
            throw new DapException("Attempt to write too much data: limit=" + this.writecount + len).setCode(416);
        }
        if (this.chunk == null) {
            this.chunk = ByteBuffer.allocate(this.maxbuffersize).order(this.getWriteOrder());
        }
        if (this.state == State.DMR) {
            this.chunk.clear();
            this.state = State.DATA;
        }
        assert (this.state == State.DATA);
        if (b.length < off + len) {
            throw new BufferUnderflowException();
        }
        int left = len;
        int offset = off;
        while (left > 0) {
            int towrite;
            int avail = this.chunk.remaining();
            do {
                if (avail == 0) {
                    this.writeChunk(0);
                    avail = this.chunk.remaining();
                }
                towrite = left < avail ? left : avail;
                this.chunk.put(b, off, towrite);
                avail -= towrite;
            } while ((left -= towrite) > 0);
        }
        this.writecount += (long)len;
    }

    protected static enum State {
        ERROR,
        END,
        DATA,
        DMR,
        INITIAL;

    }
}

