/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.data.ChecksumMode;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.dap4lib.RequestMode;
import dap4.dap4lib.XURI;
import dap4.servlet.DapController;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ucar.httpservices.HTTPUtil;

public class DapRequest {
    static final boolean DEBUG = false;
    public static final String WEBINFPATH = "/WEB-INF";
    public static final String RESOURCEDIRNAME = "resources";
    public static final String CONSTRAINTTAG = "dap4.ce";
    public static final ChecksumMode DEFAULTCSUM = ChecksumMode.DAP;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected String url = null;
    protected String querystring = null;
    protected String server = null;
    protected String controllerpath = null;
    protected String datasetpath = null;
    protected RequestMode mode = null;
    protected ResponseFormat format = null;
    protected Map<String, String> queries = new HashMap<String, String>();
    protected DapController controller = null;
    protected ByteOrder order = ByteOrder.nativeOrder();
    protected ChecksumMode checksummode = null;
    protected String resourceroot = null;
    protected ServletContext servletcontext = null;

    public DapRequest(DapController controller, HttpServletRequest request, HttpServletResponse response) throws DapException {
        this.controller = controller;
        this.request = request;
        this.response = response;
        this.servletcontext = request.getServletContext();
        this.resourceroot = (String)this.request.getAttribute("RESOURCEDIR");
        if (this.resourceroot == null && this.servletcontext != null) {
            try {
                URL url = this.servletcontext.getResource(WEBINFPATH);
                if (url == null) {
                    this.resourceroot = null;
                } else {
                    if (!url.getProtocol().equals("file")) {
                        throw new DapException("Cannot locate resource root");
                    }
                    this.resourceroot = DapUtil.canonicalpath((String)(url.getFile() + "/resources"));
                }
            }
            catch (MalformedURLException e) {
                this.resourceroot = null;
            }
            if (this.resourceroot == null) {
                throw new DapException("Cannot locate resource root");
            }
        }
        try {
            this.parse();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void parse() throws IOException {
        String p;
        XURI xuri;
        this.url = this.request.getRequestURL().toString();
        this.querystring = DapController.TESTING ? DapRequest.makeQueryString(this.request) : this.request.getQueryString();
        try {
            xuri = new XURI(this.url).parseQuery(this.querystring);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.request.getScheme());
        buf.append("://");
        buf.append(this.request.getServerName());
        int port = this.request.getServerPort();
        if (port > 0) {
            buf.append(":");
            buf.append(port);
        }
        this.server = buf.toString();
        String id = this.controller.getServletID();
        String sp = DapUtil.canonicalpath((String)this.request.getServletPath());
        Object cp = DapUtil.canonicalpath((String)this.request.getContextPath());
        if (!((String)cp).endsWith(id)) {
            cp = (String)cp + "/" + id;
        }
        buf.append((String)cp);
        this.controllerpath = buf.toString();
        sp = HTTPUtil.relpath((String)sp);
        if (sp.startsWith(id)) {
            sp = sp.substring(id.length());
        }
        this.datasetpath = HTTPUtil.relpath((String)sp);
        this.datasetpath = DapUtil.nullify((String)this.datasetpath);
        this.mode = null;
        if (this.datasetpath == null) {
            this.mode = RequestMode.CAPABILITIES;
            this.format = ResponseFormat.HTML;
        } else {
            String[] pieces = this.datasetpath.split("[.]");
            int modepos = 0;
            for (int i = pieces.length - 1; i >= 1; --i) {
                String ext = pieces[i];
                RequestMode mode = RequestMode.modeFor((String)ext);
                ResponseFormat format = ResponseFormat.formatFor((String)ext);
                if (mode != null) {
                    this.mode = mode;
                    modepos = i;
                    break;
                }
                if (format == null) continue;
                if (this.format != null) {
                    throw new DapException("Multiple response formats specified: " + ext).setCode(400);
                }
                this.format = format;
            }
            if (modepos > 0) {
                this.datasetpath = DapUtil.join((String[])pieces, (String)".", (int)0, (int)modepos);
            }
        }
        if (this.mode == null) {
            this.mode = RequestMode.DSR;
        }
        if (this.format == null) {
            this.format = ResponseFormat.NONE;
        }
        if (this.querystring != null && this.querystring.length() > 0) {
            this.queries = xuri.getQueryFields();
        }
        if ((p = this.queryLookup("ucar.littleendian")) != null) {
            Integer oz = DapUtil.stringToInteger((String)p);
            if (oz == null) {
                this.order = ByteOrder.LITTLE_ENDIAN;
            } else {
                ByteOrder byteOrder = this.order = oz != 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            }
        }
        if ((p = this.queryLookup("ucar.checksummode")) != null) {
            this.checksummode = ChecksumMode.modeFor((String)p);
        }
        if (this.checksummode == null) {
            this.checksummode = DEFAULTCSUM;
        }
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public String getResourceRoot() {
        return this.resourceroot;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksummode;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.querystring == null ? this.url : this.url + "?" + this.querystring;
    }

    public String getDataset() {
        return this.datasetpath;
    }

    public String getServer() {
        return this.server;
    }

    public ServletContext getServletContext() {
        return this.servletcontext;
    }

    public String getControllerPath() {
        return this.controllerpath;
    }

    public String getURLPath() {
        return this.controllerpath + (this.datasetpath == null ? "" : this.datasetpath);
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryLookup(String name) {
        return this.queries.get(name.toLowerCase());
    }

    public Map<String, String> getQueries() {
        return this.queries;
    }

    public String getResourcePath(String relpath) throws IOException {
        return this.controller.getResourcePath(this, relpath);
    }

    public String getDatasetPath() {
        return this.datasetpath;
    }

    static String makeQueryString(HttpServletRequest req) {
        Map map = req.getParameterMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        StringBuilder q = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values == null || values.length == 0) {
                q.append("&");
                q.append((String)entry.getKey());
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                q.append("&");
                q.append((String)entry.getKey());
                q.append("=");
                q.append(values[i]);
            }
        }
        if (q.length() > 0) {
            q.deleteCharAt(0);
        }
        return q.toString();
    }
}

