/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataException;
import dap4.core.data.DataRecord;
import dap4.core.data.DataVariable;
import dap4.core.dmr.DapSequence;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataSequence;
import dap4.dap4shared.D4DataVariable;
import java.util.Arrays;

public class D4DataRecord
extends D4DataVariable
implements DataRecord {
    protected D4DataSequence parent = null;
    protected int recno = 0;
    protected D4DataVariable[] fields;

    public D4DataRecord(D4DSP dsp, DapSequence dap, D4DataSequence parent, int recno) throws DataException {
        super(dsp, dap);
        this.dsp = dsp;
        this.parent = parent;
        this.recno = recno;
        this.fields = new D4DataVariable[dap.getFields().size()];
        Arrays.fill(this.fields, null);
    }

    public void addField(int mindex, D4DataVariable ddv) throws DataException {
        if (mindex < 0 || mindex >= this.fields.length) {
            throw new DataException("Illegal field index: " + mindex);
        }
        this.fields[mindex] = ddv;
    }

    @Override
    public DataVariable readfield(int i) throws DataException {
        if (i < 0 || i >= this.fields.length) {
            throw new DataException("Illegal field index: " + i);
        }
        return this.fields[i];
    }

    @Override
    public DataVariable readfield(String shortname) throws DataException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].getTemplate().getShortName().equals(shortname)) continue;
            return this.fields[i];
        }
        return null;
    }
}

