/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataDataset;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapFactoryDMR;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.parser.Dap4Parser;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public abstract class AbstractDSP
implements DSP {
    protected static final boolean PARSEDEBUG = false;
    protected DapContext context = null;
    protected DapDataset dmr = null;
    protected String path = null;

    @Override
    public abstract DSP open(String var1, DapContext var2) throws DapException;

    @Override
    public abstract DataDataset getDataDataset();

    @Override
    public DSP open(String path) throws DapException {
        return this.open(path, new DapContext());
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public DapDataset getDMR() {
        return this.dmr;
    }

    protected void setContext(DapContext context) {
        this.context = context;
    }

    protected void setRequestResponse() {
    }

    protected void setDataset(DapDataset dataset) throws DapException {
        this.dmr = dataset;
    }

    public void setPath(String path) throws DapException {
        this.path = path;
    }

    protected DapDataset parseDMR(String document) throws DapException {
        Dap4Parser pushparser = new Dap4Parser(new DapFactoryDMR());
        try {
            if (!pushparser.parse(document)) {
                throw new DapException("DMR Parse failed");
            }
        }
        catch (SAXException se) {
            throw new DapException(se);
        }
        if (pushparser.getErrorResponse() != null) {
            throw new DapException("Error Response Document not supported");
        }
        DapDataset result = pushparser.getDMR();
        this.processAttributes(result);
        return result;
    }

    protected void processAttributes(DapDataset dataset) throws DapException {
        List<DapNode> nodes = dataset.getNodeList();
        block3: for (DapNode node : nodes) {
            switch (node.getSort()) {
                case GRID: 
                case SEQUENCE: 
                case STRUCTURE: 
                case GROUP: 
                case DATASET: 
                case ATOMICVARIABLE: {
                    Map<String, DapAttribute> attrs = node.getAttributes();
                    if (attrs.size() <= 0) break;
                    ArrayList<DapAttribute> suppressed = new ArrayList<DapAttribute>();
                    for (DapAttribute dattr : attrs.values()) {
                        if (!this.suppress(dattr.getShortName())) continue;
                        suppressed.add(dattr);
                    }
                    for (DapAttribute dattr : suppressed) {
                        node.removeAttribute(dattr);
                    }
                    continue block3;
                }
            }
        }
    }

    protected boolean suppress(String attrname) {
        if (attrname.startsWith("_Coord")) {
            return true;
        }
        return attrname.equals("_Unsigned");
    }
}

