/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapEnum;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public enum AtomicType {
    Char("Char", 2184),
    Int8("Int8", 2177),
    UInt8("UInt8", 2241),
    Int16("Int16", 2177),
    UInt16("UInt16", 2241),
    Int32("Int32", 2177),
    UInt32("UInt32", 2241),
    Int64("Int64", 2177),
    UInt64("UInt64", 2241),
    Float32("Float32", 2178),
    Float64("Float64", 2178),
    String("String", 2052),
    URL("URL", 2052),
    Opaque("Opaque", 2080),
    Enum("Enum", 144),
    Structure("Structure", 1280),
    Sequence("Sequence", 1536);

    private final String typename;
    private final int classification;
    static Map<Class, AtomicType> classmap;

    private AtomicType(String typename, int classification) {
        this.typename = typename;
        this.classification = classification;
    }

    public final String getTypeName() {
        return this.typename;
    }

    public final int getClassification() {
        return this.classification;
    }

    public static final AtomicType getSignedVersion(AtomicType uat) {
        switch (uat) {
            case Int8: 
            case UInt8: {
                return Int8;
            }
            case Int16: 
            case UInt16: {
                return Int16;
            }
            case Int32: 
            case UInt32: {
                return Int32;
            }
            case Int64: 
            case UInt64: {
                return Int64;
            }
        }
        return null;
    }

    public static final int getSize(AtomicType uat) {
        switch (uat) {
            case Int8: 
            case UInt8: 
            case Char: {
                return 1;
            }
            case Int16: 
            case UInt16: {
                return 2;
            }
            case Int32: 
            case UInt32: 
            case Float32: {
                return 4;
            }
            case Int64: 
            case UInt64: 
            case Float64: {
                return 8;
            }
        }
        return 0;
    }

    public static AtomicType getAtomicType(String typename) {
        for (AtomicType dt : AtomicType.values()) {
            if (!typename.equalsIgnoreCase(dt.getTypeName())) continue;
            return dt;
        }
        return null;
    }

    public boolean isIntegerType() {
        return (this.classification & 1) != 0;
    }

    public boolean isFloatType() {
        return (this.classification & 2) != 0;
    }

    public boolean isStringType() {
        return (this.classification & 4) != 0;
    }

    public boolean isCharType() {
        return (this.classification & 8) != 0;
    }

    public boolean isEnumType() {
        return (this.classification & 0x10) != 0;
    }

    public boolean isOpaqueType() {
        return (this.classification & 0x20) != 0;
    }

    public boolean isStructType() {
        return (this.classification & 0x100) != 0 || (this.classification & 0x200) != 0;
    }

    public boolean isNumericType() {
        return (this.classification & 3) != 0;
    }

    public boolean isUnsigned() {
        return (this.classification & 0x40) != 0;
    }

    public boolean isFixedSize() {
        return (this.classification & 0x80) != 0;
    }

    public boolean isLegalAttrType() {
        return (this.classification & 0x800) != 0;
    }

    public boolean isCompound() {
        return (this.classification & 0x400) != 0;
    }

    public static AtomicType classToType(Object o) {
        if (o == null) {
            return null;
        }
        return classmap.get(o.getClass());
    }

    static {
        classmap = new HashMap<Class, AtomicType>();
        classmap.put(Character.class, Char);
        classmap.put(Byte.class, Int8);
        classmap.put(Short.class, Int16);
        classmap.put(Integer.class, Int32);
        classmap.put(Long.class, Int64);
        classmap.put(Float.class, Float32);
        classmap.put(Double.class, Float64);
        classmap.put(String.class, String);
        classmap.put(URI.class, URL);
        classmap.put(URL.class, URL);
        classmap.put(ByteBuffer.class, Opaque);
        classmap.put(byte[].class, Opaque);
        classmap.put(BigInteger.class, UInt64);
        classmap.put(DapEnum.class, Enum);
    }
}

