/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr.parser;

import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapOtherXML;
import dap4.core.dmr.DapXML;
import dap4.core.dmr.parser.Dap4EventHandler;
import dap4.core.dmr.parser.ParseException;
import dap4.core.dmr.parser.SaxEvent;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Dap4Actions
extends Dap4EventHandler {
    static final float DAPVERSION = 4.0f;
    static final float DMRVERSION = 1.0f;
    static final int RULENULL = 0;
    static final int RULEDIMREF = 1;
    static final int RULEMAPREF = 2;
    static final int RULEVAR = 3;
    static final int RULEMETADATA = 4;
    static final BigInteger BIG_INT64_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    static final DapSort[] METADATASCOPES = new DapSort[]{DapSort.DATASET, DapSort.GROUP, DapSort.DIMENSION, DapSort.MAP, DapSort.ATOMICVARIABLE, DapSort.STRUCTURE, DapSort.SEQUENCE, DapSort.ATTRIBUTESET};

    DapNode newNode(DapSort sort) throws ParseException {
        return this.newNode(null, sort);
    }

    abstract DapNode newNode(String var1, DapSort var2) throws ParseException;

    XMLAttributeMap xml_attribute_map() throws DapException {
        return new XMLAttributeMap();
    }

    XMLAttributeMap xml_attribute_map(XMLAttributeMap map, SaxEvent token) throws DapException {
        assert (map != null && token != null);
        if (map.containsKey(token.name)) {
            throw new DapException("XML attribute: duplicate xml attribute: " + token.name);
        }
        map.put(token.name.toLowerCase(), token);
        return map;
    }

    NamespaceList namespace_list() throws DapException {
        return new NamespaceList();
    }

    NamespaceList namespace_list(NamespaceList list, SaxEvent token) throws DapException {
        assert (list != null);
        if (token != null && !list.contains(token.name)) {
            list.add(token.name);
        }
        return list;
    }

    DapXML createxmltext(String text) throws DapException {
        DapXML node = (DapXML)this.newNode(null, DapSort.XML);
        node.setNodeType(DapXML.NodeType.TEXT);
        node.setText(text);
        return node;
    }

    DapXML createxmlelement(SaxEvent open, XMLAttributeMap map, DapNode parent) throws DapException {
        assert (parent != null);
        DapXML node = (DapXML)this.newNode(open.name, DapSort.XML);
        node.setNodeType(DapXML.NodeType.ELEMENT);
        if (parent.getSort() == DapSort.OTHERXML) {
            DapOtherXML aparent = (DapOtherXML)parent;
            aparent.setRoot(node);
        } else if (parent.getSort() == DapSort.XML) {
            DapXML element = (DapXML)parent;
            assert (element.getNodeType() == DapXML.NodeType.ELEMENT);
            element.addElement(node);
        } else {
            throw new DapException("XMLElement: unknown parent type");
        }
        for (Map.Entry entry : map.entrySet()) {
            SaxEvent att = (SaxEvent)entry.getValue();
            DapXML a = (DapXML)this.newNode(att.name, DapSort.XML);
            a.setNodeType(DapXML.NodeType.ATTRIBUTE);
            a.addXMLAttribute(a);
        }
        return node;
    }

    abstract void enterdataset(XMLAttributeMap var1) throws ParseException;

    abstract void leavedataset() throws ParseException;

    abstract void entergroup(SaxEvent var1) throws ParseException;

    abstract void leavegroup() throws ParseException;

    abstract void enterenumdef(XMLAttributeMap var1) throws ParseException;

    abstract void leaveenumdef() throws ParseException;

    abstract void enumconst(SaxEvent var1, SaxEvent var2) throws ParseException;

    abstract void enterdimdef(XMLAttributeMap var1) throws ParseException;

    abstract void leavedimdef() throws ParseException;

    abstract void dimref(SaxEvent var1) throws ParseException;

    abstract void enteratomicvariable(SaxEvent var1, SaxEvent var2) throws ParseException;

    abstract void leaveatomicvariable(SaxEvent var1) throws ParseException;

    abstract void enterenumvariable(XMLAttributeMap var1) throws ParseException;

    abstract void leaveenumvariable(SaxEvent var1) throws ParseException;

    abstract void entermap(SaxEvent var1) throws ParseException;

    abstract void leavemap() throws ParseException;

    abstract void enterstructurevariable(SaxEvent var1) throws ParseException;

    abstract void leavestructurevariable(SaxEvent var1) throws ParseException;

    abstract void entersequencevariable(SaxEvent var1) throws ParseException;

    abstract void leavesequencevariable(SaxEvent var1) throws ParseException;

    abstract void enteratomicattribute(XMLAttributeMap var1, NamespaceList var2) throws ParseException;

    abstract void leaveatomicattribute() throws ParseException;

    abstract void entercontainerattribute(XMLAttributeMap var1, NamespaceList var2) throws ParseException;

    abstract void leavecontainerattribute() throws ParseException;

    abstract void value(SaxEvent var1) throws ParseException;

    abstract void enterotherxml(XMLAttributeMap var1) throws ParseException;

    abstract void leaveotherxml() throws ParseException;

    abstract void enterxmlelement(SaxEvent var1, XMLAttributeMap var2) throws ParseException;

    abstract void leavexmlelement(SaxEvent var1) throws ParseException;

    abstract void xmltext(SaxEvent var1) throws ParseException;

    abstract void entererror(XMLAttributeMap var1) throws ParseException;

    abstract void leaveerror() throws ParseException;

    abstract void errormessage(SaxEvent var1) throws ParseException;

    abstract void errorcontext(SaxEvent var1) throws ParseException;

    abstract void errorotherinfo(SaxEvent var1) throws ParseException;

    static class NamespaceList
    extends ArrayList<String> {
        NamespaceList() {
        }
    }

    static class XMLAttributeMap
    extends HashMap<String, SaxEvent> {
        XMLAttributeMap() {
        }
    }
}

