/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.dmr.DapDataset;
import dap4.core.util.DapContext;
import dap4.core.util.DapDump;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.ChecksumMode;
import dap4.dap4shared.ChunkInputStream;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.DSP;
import dap4.dap4shared.RequestMode;
import dap4.dap4shared.XURI;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPUtil;

public class HttpDSP
extends D4DSP {
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected static final String DAP4PROTO = "dap4";
    protected static final String FILEPROTO = "file";
    protected static final String DMRSUFFIX = "dmr";
    protected static final String DATASUFFIX = "dap";
    protected static final String DSRSUFFIX = "dsr";
    protected static final String QUERYSTART = "?";
    protected static final String CONSTRAINTTAG = "dap4.ce";
    protected static final String CHECKSUMTAG = "checksum";
    protected static final String PROTOTAG = "protocol";
    protected static final int DFALTPRELOADSIZE = 50000;
    protected static final String[] DAPEXTENSIONS = new String[]{"dmr", "dap", "dds", "das", "ddx", "dods"};
    protected static final String[] DAP4EXTENSIONS = new String[]{"dmr", "dap"};
    protected String originalurl = null;
    protected boolean allowCompression = true;
    protected String basece = null;
    protected int status = 200;
    protected XURI xuri = null;

    public static boolean match(String url, DapContext context) {
        try {
            XURI xuri = new XURI(url);
            return xuri.getLeadProtocol().equals(DAP4PROTO) || xuri.getParameters().get(PROTOTAG).equals(DAP4PROTO);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Override
    public DSP open(String url, DapContext context) throws DapException {
        this.setContext(context);
        this.originalurl = url;
        this.setURL(url);
        this.basece = this.xuri.getFields().get(CONSTRAINTTAG);
        this.build();
        return this;
    }

    @Override
    public void close() {
    }

    protected void build() throws DapException {
        String methodurl = HttpDSP.buildURL(this.xuri.assemble(XURI.URLONLY), DATASUFFIX, this.dmr, this.basece);
        this.checksummode = ChecksumMode.modeFor(this.xuri.getParameters().get(CHECKSUMTAG));
        if (this.checksummode == null) {
            this.checksummode = ChecksumMode.DAP;
        }
        InputStream stream = this.callServer(methodurl);
        try {
            ChunkInputStream reader;
            if (DEBUG) {
                byte[] raw = DapUtil.readbinaryfile(stream);
                ByteArrayInputStream bis = new ByteArrayInputStream(raw);
                DapDump.dumpbytestream(raw, this.order, "httpdsp.build");
                reader = new ChunkInputStream(bis, RequestMode.DAP, this.getOrder());
            } else {
                reader = new ChunkInputStream(stream, RequestMode.DAP, this.getOrder());
            }
            String document = reader.readDMR();
            byte[] bytes = DapUtil.readbinaryfile(reader);
            super.build(document, bytes, this.getOrder());
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DapException(t);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException reader) {}
        }
    }

    protected InputStream callServer(String methodurl) throws DapException {
        try {
            URI uri = HTTPUtil.parseToURI(methodurl);
        }
        catch (URISyntaxException mue) {
            throw new DapException("Malformed url: " + methodurl);
        }
        long start = System.currentTimeMillis();
        long stop = 0L;
        this.status = 0;
        HTTPMethod method = null;
        try {
            method = HTTPFactory.Get(methodurl);
            if (this.allowCompression) {
                method.setCompression("deflate,gzip");
            }
            this.status = method.execute();
            if (this.status != 200) {
                String msg = method.getResponseAsString();
                throw new DapException("Request failure: " + method.getStatusText() + ": " + methodurl).setCode(this.status);
            }
            return method.getResponseAsStream();
        }
        catch (Exception e) {
            if (method != null) {
                method.close();
            }
            throw new DapException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCapabilities(String url) throws IOException {
        String saveurl = this.xuri.getOriginal();
        this.setURL(url);
        String fdsurl = HttpDSP.buildURL(this.xuri.assemble(XURI.URLALL), DSRSUFFIX, null, null);
        try {
            String document;
            InputStream stream = this.callServer(fdsurl);
            byte[] bytes = DapUtil.readbinaryfile(stream);
            String string = document = new String(bytes, DapUtil.UTF8);
            return string;
        }
        finally {
            this.setURL(saveurl);
        }
    }

    protected static String buildURL(String baseurl, String suffix, DapDataset template, String ce) {
        StringBuilder methodurl = new StringBuilder();
        methodurl.append(baseurl);
        if (suffix != null) {
            methodurl.append('.');
            methodurl.append(suffix);
        }
        if (ce != null && ce.length() > 0) {
            methodurl.append(QUERYSTART);
            methodurl.append(CONSTRAINTTAG);
            methodurl.append('=');
            methodurl.append(ce);
        }
        return methodurl.toString();
    }

    protected void setURL(String url) throws DapException {
        try {
            this.xuri = new XURI(url);
        }
        catch (URISyntaxException use) {
            throw new DapException(use);
        }
    }
}

