/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.ChunkInputStream;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.DSP;
import dap4.dap4shared.RequestMode;
import dap4.dap4shared.XURI;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.ByteOrder;

public class FileDSP
extends D4DSP {
    protected byte[] raw = null;

    public FileDSP() {
        this.setOrder(ByteOrder.nativeOrder());
    }

    public static boolean match(String path, DapContext context) {
        try {
            XURI xuri = new XURI(path);
            return xuri.getProtocols().size() == 0 || xuri.getBaseProtocol().equals("file");
        }
        catch (URISyntaxException use) {
            return false;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public DSP open(String path, DapContext context) throws DapException {
        this.setPath(path);
        try {
            String filepath = path;
            XURI xuri = new XURI(path);
            if (xuri.getProtocols().size() > 0) {
                filepath = xuri.getPath();
            }
            FileInputStream stream = new FileInputStream(filepath);
            this.raw = DapUtil.readbinaryfile(stream);
            stream.close();
            stream = new FileInputStream(filepath);
            ChunkInputStream rdr = new ChunkInputStream(stream, RequestMode.DAP);
            String document = rdr.readDMR();
            byte[] serialdata = DapUtil.readbinaryfile(rdr);
            stream.close();
            super.build(document, serialdata, rdr.getByteOrder());
            return this;
        }
        catch (URISyntaxException use) {
            throw new DapException(use);
        }
        catch (IOException ioe) {
            throw new DapException(ioe);
        }
    }
}

